/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.engine;

import icyllis.arc3d.core.RefCnt;
import icyllis.arc3d.core.SharedPtr;
import icyllis.arc3d.engine.BackendFormat;
import icyllis.arc3d.engine.BackendImage;
import icyllis.arc3d.engine.BackendRenderTarget;
import icyllis.arc3d.engine.Buffer;
import icyllis.arc3d.engine.Caps;
import icyllis.arc3d.engine.Context;
import icyllis.arc3d.engine.Device;
import icyllis.arc3d.engine.GpuRenderTarget;
import icyllis.arc3d.engine.GraphicsPipeline;
import icyllis.arc3d.engine.IResourceKey;
import icyllis.arc3d.engine.ISurface;
import icyllis.arc3d.engine.IUniqueKey;
import icyllis.arc3d.engine.Image;
import icyllis.arc3d.engine.ImageDesc;
import icyllis.arc3d.engine.PipelineDesc;
import icyllis.arc3d.engine.PipelineKey;
import icyllis.arc3d.engine.RenderPassDesc;
import icyllis.arc3d.engine.Resource;
import icyllis.arc3d.engine.ResourceCache;
import icyllis.arc3d.engine.Sampler;
import icyllis.arc3d.engine.SamplerDesc;
import icyllis.arc3d.engine.SharedResourceCache;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.VisibleForTesting;

public abstract class ResourceProvider {
    protected final Device mDevice;
    protected final Context mContext;
    protected final ResourceCache mResourceCache;
    private PipelineKey mGraphicsPipelineKey;
    private IResourceKey mImageScratchKey;
    private final Buffer.ResourceKey mBufferKey = new Buffer.ResourceKey();

    protected ResourceProvider(Device device, Context context, long maxResourceBudget) {
        this.mDevice = device;
        this.mContext = context;
        this.mResourceCache = new ResourceCache(context, maxResourceBudget);
    }

    protected void destroy() {
        this.mResourceCache.shutdown();
    }

    @Nullable
    @SharedPtr
    public GraphicsPipeline findOrCreateGraphicsPipeline(PipelineDesc pipelineDesc, RenderPassDesc renderPassDesc) {
        SharedResourceCache cache = this.mDevice.getSharedResourceCache();
        this.mGraphicsPipelineKey = this.mDevice.getCaps().makeGraphicsPipelineKey(this.mGraphicsPipelineKey, pipelineDesc, renderPassDesc);
        @SharedPtr GraphicsPipeline pipeline = cache.findGraphicsPipeline(this.mGraphicsPipelineKey);
        if (pipeline == null) {
            PipelineKey key = this.mGraphicsPipelineKey.copy();
            pipeline = this.createGraphicsPipeline(key.mPipelineDesc, renderPassDesc);
            if (pipeline != null) {
                pipeline = cache.insertGraphicsPipeline(key, pipeline);
            }
        }
        return pipeline;
    }

    @SharedPtr
    protected GraphicsPipeline createGraphicsPipeline(PipelineDesc pipelineDesc, RenderPassDesc renderPassDesc) {
        return null;
    }

    @Deprecated
    @Nullable
    @SharedPtr
    public final Image createImage(int width, int height, BackendFormat format, int sampleCount, int surfaceFlags, @Nullable String label) {
        assert (this.mContext.isOwnerThread());
        if (this.mContext.isDeviceLost()) {
            return null;
        }
        if (format.isCompressed()) {
            return null;
        }
        if (((surfaceFlags &= 0xEF) & 8) != 0) {
            surfaceFlags &= 0xFFFFFFBF;
        }
        if ((surfaceFlags & 0x40) != 0) {
            surfaceFlags &= 0xFFFFFFFD;
            surfaceFlags |= 0x20;
        }
        if ((surfaceFlags & 2) != 0) {
            width = ISurface.getApproxSize(width);
            height = ISurface.getApproxSize(height);
            surfaceFlags &= 0xA8;
            surfaceFlags |= 1;
        }
        if (!this.mDevice.getCaps().validateSurfaceParams(width, height, format, sampleCount, surfaceFlags)) {
            return null;
        }
        return null;
    }

    @Nullable
    @SharedPtr
    public final Image findOrCreateImage(ImageDesc desc, boolean budgeted, @Nullable String label) {
        IResourceKey key = this.mDevice.getCaps().computeImageKey(desc, this.mImageScratchKey);
        if (key == null) {
            return null;
        }
        this.mImageScratchKey = key;
        Image image = this.findAndRefScratchImage(key, budgeted, label);
        if (image != null) {
            return image;
        }
        image = this.createNewImage(desc, budgeted, label);
        if (image == null) {
            return null;
        }
        image.setKey(key.copy());
        this.mResourceCache.insertResource(image);
        return image;
    }

    @Nullable
    @SharedPtr
    public final Image createNewImage(ImageDesc desc, boolean budgeted, @Nullable String label) {
        if (desc.isCompressed()) {
            return null;
        }
        Image image = this.onCreateNewImage(desc, budgeted);
        if (image != null) {
            assert (image.getDesc() == desc);
            if (label != null) {
                image.setLabel(label);
            }
        }
        return image;
    }

    @Nullable
    @ApiStatus.OverrideOnly
    @SharedPtr
    protected abstract Image onCreateNewImage(ImageDesc var1, boolean var2);

    @Nullable
    @SharedPtr
    public final Image findAndRefScratchImage(IResourceKey key, boolean budgeted, @Nullable String label) {
        assert (this.mContext.isOwnerThread());
        assert (!this.mDevice.isDeviceLost());
        Resource resource = this.mResourceCache.findAndRefResource(key, budgeted);
        if (resource != null) {
            this.mDevice.getStats().incNumScratchTexturesReused();
            if (label != null) {
                resource.setLabel(label);
            }
            return (Image)resource;
        }
        return null;
    }

    @Nullable
    @SharedPtr
    public final Image findAndRefScratchImage(ImageDesc desc, boolean budgeted, @Nullable String label) {
        assert (this.mContext.isOwnerThread());
        assert (!this.mDevice.isDeviceLost());
        IResourceKey key = this.mDevice.getCaps().computeImageKey(desc, this.mImageScratchKey);
        if (key == null) {
            return null;
        }
        this.mImageScratchKey = key;
        return this.findAndRefScratchImage(key, budgeted, label);
    }

    @Deprecated
    @Nullable
    @SharedPtr
    public final Image createTexture(int width, int height, BackendFormat format, int sampleCount, int surfaceFlags, String label) {
        assert (this.mContext.isOwnerThread());
        if (this.mDevice.isDeviceLost()) {
            return null;
        }
        if (format.isCompressed()) {
            return null;
        }
        return this.createImage(width, height, format, sampleCount, surfaceFlags |= 8, label);
    }

    @Nullable
    @SharedPtr
    public final Sampler findOrCreateCompatibleSampler(@Nonnull SamplerDesc desc) {
        @SharedPtr Sampler sampler = (Sampler)this.mResourceCache.findAndRefResource(desc, true);
        if (sampler != null) {
            return sampler;
        }
        sampler = this.createSampler(desc);
        if (sampler == null) {
            return null;
        }
        sampler.setKey(desc);
        this.mResourceCache.insertResource(sampler);
        return sampler;
    }

    @Nullable
    @SharedPtr
    protected abstract Sampler createSampler(SamplerDesc var1);

    @Deprecated
    @Nullable
    @SharedPtr
    public final GpuRenderTarget createRenderTarget(int width, int height, @Nullable BackendFormat colorFormat, int colorFlags, @Nullable BackendFormat resolveFormat, int resolveFlags, @Nullable BackendFormat depthStencilFormat, int depthStencilFlags, int sampleCount, int surfaceFlags, @Nullable String label) {
        Image[] imageArray;
        Image[] imageArray2;
        assert (this.mContext.isOwnerThread());
        assert (!this.mDevice.isDeviceLost());
        Caps caps = this.mDevice.getCaps();
        if (sampleCount <= 1) {
            resolveFormat = null;
        }
        colorFlags = colorFormat != null ? (colorFlags |= 0x20) : 0;
        resolveFlags = resolveFormat != null ? (resolveFlags |= 0x20) : 0;
        depthStencilFlags = depthStencilFormat != null ? (depthStencilFlags |= 0x20) : 0;
        if (((surfaceFlags |= 0x20) & 2) != 0) {
            width = ISurface.getApproxSize(width);
            height = ISurface.getApproxSize(height);
        }
        if (colorFormat != null && !caps.validateSurfaceParams(width, height, colorFormat, sampleCount, colorFlags)) {
            return null;
        }
        if (resolveFormat != null && !caps.validateSurfaceParams(width, height, resolveFormat, 1, resolveFlags)) {
            return null;
        }
        if (depthStencilFormat != null && !caps.validateSurfaceParams(width, height, depthStencilFormat, sampleCount, depthStencilFlags)) {
            return null;
        }
        GpuRenderTarget renderTarget = this.findAndRefScratchRenderTarget(width, height, colorFormat, colorFlags, resolveFormat, resolveFlags, depthStencilFormat, depthStencilFlags, sampleCount, surfaceFlags, label);
        if (renderTarget != null) {
            if ((surfaceFlags & 1) == 0) {
                renderTarget.makeBudgeted(false);
            }
            return renderTarget;
        }
        Image colorAtt = null;
        if (colorFormat != null && (colorAtt = this.createImage(width, height, colorFormat, sampleCount, colorFlags, (String)(label == null ? null : (label.isEmpty() ? "" : label + "_C0")))) == null) {
            return null;
        }
        Image resolveAtt = null;
        if (resolveFormat != null && (resolveAtt = this.createImage(width, height, resolveFormat, 1, resolveFlags, (String)(label == null ? null : (label.isEmpty() ? "" : label + "_R0")))) == null) {
            RefCnt.move(colorAtt);
            return null;
        }
        Image depthStencilAtt = null;
        if (depthStencilFormat != null && (depthStencilAtt = this.createImage(width, height, depthStencilFormat, sampleCount, depthStencilFlags, (String)(label == null ? null : (label.isEmpty() ? "" : label + "_DS")))) == null) {
            RefCnt.move(colorAtt);
            RefCnt.move(resolveAtt);
            return null;
        }
        if (colorFormat != null) {
            Image[] imageArray3 = new Image[1];
            imageArray2 = imageArray3;
            imageArray3[0] = colorAtt;
        } else {
            imageArray2 = null;
        }
        if (resolveFormat != null) {
            Image[] imageArray4 = new Image[1];
            imageArray = imageArray4;
            imageArray4[0] = resolveAtt;
        } else {
            imageArray = null;
        }
        renderTarget = this.createRenderTarget(1, imageArray2, imageArray, null, depthStencilAtt, surfaceFlags);
        if (renderTarget != null) {
            return renderTarget;
        }
        RefCnt.move(colorAtt);
        RefCnt.move(resolveAtt);
        RefCnt.move(depthStencilAtt);
        return null;
    }

    @Deprecated
    @Nullable
    @SharedPtr
    public final GpuRenderTarget createRenderTarget(int numColorTargets, @Nullable Image[] colorTargets, @Nullable Image[] resolveTargets, @Nullable int[] mipLevels, @Nullable Image depthStencilTarget, int surfaceFlags) {
        return this.mDevice.createRenderTarget(numColorTargets, colorTargets, resolveTargets, mipLevels, depthStencilTarget, surfaceFlags);
    }

    @Deprecated
    @Nullable
    @SharedPtr
    public final GpuRenderTarget createRenderTarget(int width, int height, int sampleCount) {
        return null;
    }

    @Deprecated
    @Nullable
    @SharedPtr
    public final GpuRenderTarget findAndRefScratchRenderTarget(IResourceKey key, String label) {
        assert (this.mContext.isOwnerThread());
        assert (!this.mDevice.isDeviceLost());
        assert (key instanceof GpuRenderTarget.ResourceKey);
        Resource resource = this.mResourceCache.findAndRefResource(key, true);
        if (resource != null) {
            this.mDevice.getStats().incNumScratchRenderTargetsReused();
            if (label != null) {
                resource.setLabel(label);
            }
            return (GpuRenderTarget)resource;
        }
        return null;
    }

    @Deprecated
    @Nullable
    @SharedPtr
    public final GpuRenderTarget findAndRefScratchRenderTarget(int width, int height, BackendFormat colorFormat, int colorFlags, BackendFormat resolveFormat, int resolveFlags, BackendFormat depthStencilFormat, int depthStencilFlags, int sampleCount, int surfaceFlags, String label) {
        return null;
    }

    @Deprecated
    @Nullable
    @SharedPtr
    public final GpuRenderTarget wrapRenderableBackendTexture(BackendImage texture, int sampleCount, boolean ownership) {
        if (this.mDevice.isDeviceLost()) {
            return null;
        }
        return this.mDevice.wrapRenderableBackendTexture(texture, sampleCount, ownership);
    }

    @Deprecated
    @Nullable
    @SharedPtr
    public final GpuRenderTarget wrapGLDefaultFramebuffer(int width, int height, int sampleCount, int depthBits, int stencilBits, BackendFormat format) {
        return this.mDevice.wrapGLDefaultFramebuffer(width, height, sampleCount, depthBits, stencilBits, format);
    }

    @Deprecated
    @Nullable
    @SharedPtr
    public final GpuRenderTarget wrapBackendRenderTarget(BackendRenderTarget backendRenderTarget) {
        if (this.mDevice.isDeviceLost()) {
            return null;
        }
        return this.mDevice.wrapBackendRenderTarget(backendRenderTarget);
    }

    @Nullable
    @SharedPtr
    public final Buffer findOrCreateBuffer(long size, int usage, String label) {
        if (this.mDevice.isDeviceLost()) {
            return null;
        }
        @SharedPtr Buffer buffer = (Buffer)this.mResourceCache.findAndRefResource(this.mBufferKey.set(usage, size), true);
        if (buffer != null) {
            buffer.setLabel(label);
            return buffer;
        }
        buffer = this.createNewBuffer(size, usage);
        if (buffer == null) {
            return null;
        }
        buffer.setKey(this.mBufferKey.copy());
        buffer.setLabel(label);
        this.mResourceCache.insertResource(buffer);
        return buffer;
    }

    @Nullable
    @SharedPtr
    public final Buffer createNewBuffer(long size, int usage) {
        if (size <= 0L) {
            this.mContext.getLogger().error("Failed to create buffer: invalid size {}", (Object)size);
            return null;
        }
        if ((usage & 0x18) != 0 && (usage & 0x10000) != 0) {
            return null;
        }
        return this.onCreateNewBuffer(size, usage);
    }

    @Nullable
    @SharedPtr
    protected abstract Buffer onCreateNewBuffer(long var1, int var3);

    public final void assignUniqueKeyToResource(IUniqueKey key, Resource resource) {
        if (this.mDevice.isDeviceLost() || resource == null) {
            return;
        }
    }

    public long getResourceCacheLimit() {
        return this.mResourceCache.getMaxBudget();
    }

    public long getResourceCacheBudgetedBytes() {
        return this.mResourceCache.getBudgetedBytes();
    }

    public long getResourceCachePurgeableBytes() {
        return this.mResourceCache.getPurgeableBytes();
    }

    public void freeGpuResources() {
        this.mResourceCache.purgeResources();
    }

    public void purgeResourcesNotUsedSince(long timeMillis) {
        this.mResourceCache.purgeResourcesNotUsedSince(timeMillis);
    }

    @VisibleForTesting
    public ResourceCache getResourceCache() {
        return this.mResourceCache;
    }
}

