/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.engine;

import icyllis.arc3d.core.RawPtr;
import icyllis.arc3d.engine.CommandBuffer;
import icyllis.arc3d.engine.Device;
import icyllis.arc3d.engine.ImmediateContext;
import icyllis.arc3d.engine.ResourceProvider;
import icyllis.arc3d.engine.task.Task;
import java.util.ArrayDeque;

public abstract class QueueManager {
    private final Device mDevice;
    protected ImmediateContext mContext;
    protected CommandBuffer mCurrentCommandBuffer;
    private final ArrayDeque<CommandBuffer> mAvailableCommandBuffers = new ArrayDeque();
    private final ArrayDeque<CommandBuffer> mOutstandingCommandBuffers = new ArrayDeque();
    private int mMaxCommandBuffers;

    protected QueueManager(Device device) {
        this.mDevice = device;
    }

    public boolean addTask(@RawPtr Task task) {
        if (task == null) {
            return false;
        }
        if (!this.prepareCommandBuffer(this.mContext.getResourceProvider())) {
            return false;
        }
        return task.execute(this.mContext, this.mCurrentCommandBuffer) != 1;
    }

    public boolean submit() {
        if (this.mCurrentCommandBuffer == null) {
            return true;
        }
        if (this.mCurrentCommandBuffer.submit(this)) {
            this.mOutstandingCommandBuffers.add(this.mCurrentCommandBuffer);
            this.mMaxCommandBuffers = Math.max(this.mMaxCommandBuffers, this.mOutstandingCommandBuffers.size());
            this.mCurrentCommandBuffer = null;
            return true;
        }
        return false;
    }

    public int getMaxCommandBuffers() {
        return this.mMaxCommandBuffers;
    }

    public boolean hasOutstandingWork() {
        return !this.mOutstandingCommandBuffers.isEmpty();
    }

    public void finishOutstandingWork() {
        CommandBuffer last = this.mOutstandingCommandBuffers.peekLast();
        if (last != null) {
            last.waitUntilFinished();
        }
        this.checkForFinishedWork();
        assert (this.mOutstandingCommandBuffers.isEmpty());
    }

    public void checkForFinishedWork() {
        CommandBuffer front = this.mOutstandingCommandBuffers.peekFirst();
        while (front != null && front.checkFinishedAndReset()) {
            this.mAvailableCommandBuffers.push(this.mOutstandingCommandBuffers.removeFirst());
            front = this.mOutstandingCommandBuffers.peekFirst();
        }
    }

    protected boolean prepareCommandBuffer(ResourceProvider resourceProvider) {
        if (this.mCurrentCommandBuffer == null) {
            if (!this.mAvailableCommandBuffers.isEmpty()) {
                this.mCurrentCommandBuffer = this.mAvailableCommandBuffers.pop();
                this.mCurrentCommandBuffer.begin();
                return true;
            }
            this.mCurrentCommandBuffer = this.createNewCommandBuffer(resourceProvider);
            if (this.mCurrentCommandBuffer == null) {
                return false;
            }
            this.mCurrentCommandBuffer.begin();
        }
        return true;
    }

    protected abstract CommandBuffer createNewCommandBuffer(ResourceProvider var1);
}

