/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.engine;

import icyllis.arc3d.core.RawPtr;
import icyllis.arc3d.core.SharedPtr;
import icyllis.arc3d.engine.CommandBuffer;
import icyllis.arc3d.engine.Context;
import icyllis.arc3d.engine.Device;
import icyllis.arc3d.engine.QueueManager;
import icyllis.arc3d.engine.RecordingContext;
import icyllis.arc3d.engine.RecordingContextOptions;
import icyllis.arc3d.engine.task.Task;
import icyllis.arc3d.granite.RendererProvider;
import icyllis.arc3d.granite.StaticBufferManager;
import javax.annotation.Nullable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.VisibleForTesting;

public final class ImmediateContext
extends Context {
    private QueueManager mQueueManager;

    @ApiStatus.Internal
    public ImmediateContext(Device device, QueueManager queueManager) {
        super(device);
        this.mQueueManager = queueManager;
    }

    @Nullable
    @SharedPtr
    public RecordingContext makeRecordingContext() {
        return this.makeRecordingContext(new RecordingContextOptions());
    }

    @Nullable
    @SharedPtr
    public RecordingContext makeRecordingContext(RecordingContextOptions options) {
        RecordingContext rContext = new RecordingContext(this.mDevice);
        if (rContext.init(options)) {
            return rContext;
        }
        rContext.unref();
        return null;
    }

    public void resetContext(int state) {
        this.checkOwnerThread();
        this.mDevice.markContextDirty(state);
    }

    public boolean isDiscarded() {
        return this.mDevice != null && this.mDevice.isDeviceLost();
    }

    @ApiStatus.Internal
    public QueueManager getQueueManager() {
        return this.mQueueManager;
    }

    public boolean addTask(@RawPtr Task task) {
        return this.mQueueManager.addTask(task);
    }

    public boolean submit() {
        this.checkOwnerThread();
        boolean success = this.mQueueManager.submit();
        this.mQueueManager.checkForFinishedWork();
        return success;
    }

    public void checkForFinishedWork() {
        this.checkOwnerThread();
        this.mQueueManager.checkForFinishedWork();
    }

    @VisibleForTesting
    @ApiStatus.Internal
    public CommandBuffer currentCommandBuffer() {
        if (this.mQueueManager.prepareCommandBuffer(this.mResourceProvider)) {
            return this.mQueueManager.mCurrentCommandBuffer;
        }
        return null;
    }

    @Override
    public boolean isDeviceLost() {
        return this.mDevice != null && this.mDevice.isDeviceLost();
    }

    @Override
    public void freeGpuResources() {
        this.checkForFinishedWork();
        this.mResourceProvider.freeGpuResources();
        this.mDevice.freeGpuResources();
    }

    @Override
    public void performDeferredCleanup(long msNotUsed) {
        this.checkForFinishedWork();
        long timeMillis = System.currentTimeMillis() - msNotUsed;
        this.mResourceProvider.purgeResourcesNotUsedSince(timeMillis);
        this.mDevice.purgeResourcesNotUsedSince(timeMillis);
    }

    public boolean init() {
        assert (this.isOwnerThread());
        if (this.mDevice == null) {
            return false;
        }
        if (!super.init(this.mDevice.getOptions())) {
            return false;
        }
        this.mQueueManager.mContext = this;
        StaticBufferManager staticBufferManager = new StaticBufferManager(this.mResourceProvider, this.getCaps());
        RendererProvider rendererProvider = new RendererProvider(this.getCaps(), staticBufferManager);
        int result = staticBufferManager.flush(this.mQueueManager, this.getSharedResourceCache());
        if (result == 1) {
            return false;
        }
        if (result == 0 && !this.mQueueManager.submit()) {
            return false;
        }
        this.mDevice.mRendererProvider = rendererProvider;
        return true;
    }

    @Override
    protected void deallocate() {
        super.deallocate();
        if (this.mDevice != null) {
            this.mDevice.disconnect(true);
        }
        this.mQueueManager.finishOutstandingWork();
    }
}

