/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.engine;

import icyllis.arc3d.core.Pixels;
import icyllis.arc3d.core.Pixmap;
import icyllis.arc3d.core.RawPtr;
import icyllis.arc3d.core.RefCnt;
import icyllis.arc3d.core.SharedPtr;
import icyllis.arc3d.engine.BackendFormat;
import icyllis.arc3d.engine.BackendImage;
import icyllis.arc3d.engine.BackendRenderTarget;
import icyllis.arc3d.engine.Context;
import icyllis.arc3d.engine.GpuSurface;
import icyllis.arc3d.engine.IUniqueKey;
import icyllis.arc3d.engine.ImageViewProxy;
import icyllis.arc3d.engine.RecordingContext;
import icyllis.arc3d.engine.RenderTargetProxy;
import icyllis.arc3d.engine.ResourceProvider;
import icyllis.arc3d.engine.SurfaceProxy;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ImageProxyCache {
    private final Context mContext;
    private final Object2ObjectOpenHashMap<IUniqueKey, ImageViewProxy> mUniquelyKeyedProxies;

    ImageProxyCache(RecordingContext context) {
        this.mContext = context;
        this.mUniquelyKeyedProxies = new Object2ObjectOpenHashMap();
    }

    public boolean assignUniqueKeyToProxy(IUniqueKey key, ImageViewProxy proxy) {
        assert (key != null);
        if (this.mContext.isDeviceLost() || proxy == null) {
            return false;
        }
        assert (!this.mUniquelyKeyedProxies.containsKey((Object)key));
        this.mUniquelyKeyedProxies.put((Object)key, (Object)proxy);
        return true;
    }

    public void dropUniqueRefs() {
    }

    public void dropUniqueRefsOlderThan(long nanoTime) {
    }

    public void adoptUniqueKeyFromSurface(ImageViewProxy proxy, GpuSurface texture) {
    }

    public void processInvalidUniqueKey(Object key, ImageViewProxy proxy, boolean invalidateResource) {
    }

    @Deprecated
    @Nullable
    @SharedPtr
    public ImageViewProxy createTexture(BackendFormat format, int width, int height, int surfaceFlags) {
        assert (this.mContext.isOwnerThread());
        if (this.mContext.isDeviceLost()) {
            return null;
        }
        if (format.isCompressed()) {
            return null;
        }
        if (!this.mContext.getCaps().validateSurfaceParams(width, height, format, 1, surfaceFlags)) {
            return null;
        }
        if (this.isDeferredProvider()) {
            surfaceFlags |= 0x400;
        } else assert ((surfaceFlags & 0x400) == 0);
        return null;
    }

    @Deprecated
    @Nullable
    @SharedPtr
    public ImageViewProxy createTextureFromPixels(@Nonnull Pixmap pixmap, @Nonnull @RawPtr Pixels pixels, int dstColorType, int surfaceFlags) {
        int height;
        this.mContext.checkOwnerThread();
        assert ((surfaceFlags & 2) == 0 || (surfaceFlags & 4) == 0);
        if (this.mContext.isDeviceLost()) {
            return null;
        }
        if (!pixmap.getInfo().isValid()) {
            return null;
        }
        if (!pixels.isImmutable()) {
            return null;
        }
        BackendFormat format = this.mContext.getCaps().getDefaultBackendFormat(dstColorType, false);
        if (format == null) {
            return null;
        }
        int srcColorType = pixmap.getColorType();
        int width = pixmap.getWidth();
        ImageViewProxy texture = this.createLazyTexture(format, width, height = pixmap.getHeight(), surfaceFlags, new PixelsCallback(pixels, srcColorType, dstColorType));
        if (texture == null) {
            return null;
        }
        if (!this.isDeferredProvider()) {
            // empty if block
        }
        return texture;
    }

    @Deprecated
    @Nullable
    @SharedPtr
    public RenderTargetProxy createRenderTexture(BackendFormat format, int width, int height, int sampleCount, int surfaceFlags) {
        assert (this.mContext.isOwnerThread());
        if (this.mContext.isDeviceLost()) {
            return null;
        }
        if (format.isCompressed()) {
            return null;
        }
        if (!this.mContext.getCaps().validateSurfaceParams(width, height, format, sampleCount, surfaceFlags)) {
            return null;
        }
        if (this.isDeferredProvider()) {
            surfaceFlags |= 0x400;
        } else assert ((surfaceFlags & 0x400) == 0);
        return new RenderTargetProxy(format, width, height, sampleCount, surfaceFlags);
    }

    @Deprecated
    @Nullable
    @SharedPtr
    public RenderTargetProxy wrapRenderableBackendTexture(BackendImage texture, int sampleCount, boolean ownership, boolean cacheable, Runnable releaseCallback) {
        if (this.mContext.isDeviceLost()) {
            return null;
        }
        sampleCount = this.mContext.getCaps().getRenderTargetSampleCount(sampleCount, texture.getBackendFormat());
        assert (sampleCount > 0);
        return null;
    }

    @Deprecated
    @Nullable
    @SharedPtr
    public RenderTargetProxy wrapBackendRenderTarget(BackendRenderTarget backendRenderTarget, Runnable rcReleaseCB) {
        if (this.mContext.isDeviceLost()) {
            return null;
        }
        return null;
    }

    @Deprecated
    @Nullable
    @SharedPtr
    public ImageViewProxy createLazyTexture(BackendFormat format, int width, int height, int surfaceFlags, SurfaceProxy.LazyInstantiateCallback callback) {
        this.mContext.checkOwnerThread();
        if (this.mContext.isDeviceLost()) {
            return null;
        }
        assert (width <= 0 && height <= 0 || width > 0 && height > 0);
        Objects.requireNonNull(callback);
        if (format == null || format.getBackend() != this.mContext.getBackend()) {
            return null;
        }
        if (width > this.mContext.getCaps().maxTextureSize() || height > this.mContext.getCaps().maxTextureSize()) {
            return null;
        }
        if (this.isDeferredProvider()) {
            surfaceFlags |= 0x400;
        } else assert ((surfaceFlags & 0x400) == 0);
        return null;
    }

    public boolean isDeferredProvider() {
        return false;
    }

    @Deprecated
    private static final class PixelsCallback
    implements SurfaceProxy.LazyInstantiateCallback {
        private Pixels mPixels;
        private final int mSrcColorType;
        private final int mDstColorType;

        public PixelsCallback(Pixels pixels, int srcColorType, int dstColorType) {
            this.mPixels = RefCnt.create(pixels);
            this.mSrcColorType = srcColorType;
            this.mDstColorType = dstColorType;
        }

        @Override
        public SurfaceProxy.LazyCallbackResult onLazyInstantiate(ResourceProvider provider, BackendFormat format, int width, int height, int sampleCount, int surfaceFlags, String label) {
            assert (this.mPixels.getBase() == null);
            this.close();
            return null;
        }

        @Override
        public void close() {
            this.mPixels = RefCnt.move(this.mPixels);
        }
    }
}

