/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.core.shaders;

import icyllis.arc3d.core.ColorSpace;
import icyllis.arc3d.core.MathUtil;
import icyllis.arc3d.core.shaders.Shader;

public final class Color4fShader
implements Shader {
    private final float mR;
    private final float mG;
    private final float mB;
    private final float mA;
    private final ColorSpace mColorSpace;

    public Color4fShader(float r, float g, float b, float a, ColorSpace colorSpace) {
        this.mR = r;
        this.mG = g;
        this.mB = b;
        this.mA = MathUtil.pin(a, 0.0f, 1.0f);
        this.mColorSpace = colorSpace;
    }

    @Override
    public boolean isOpaque() {
        return this.mA == 1.0f;
    }

    @Override
    public boolean isConstant() {
        return true;
    }

    public float r() {
        return this.mR;
    }

    public float g() {
        return this.mG;
    }

    public float b() {
        return this.mB;
    }

    public float a() {
        return this.mA;
    }

    public ColorSpace getColorSpace() {
        return this.mColorSpace;
    }

    @Override
    public void ref() {
    }

    @Override
    public void unref() {
    }
}

