/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.core.image;

import icyllis.arc3d.core.image.LZWDecoder;
import java.io.EOFException;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class GIFDecoder {
    public static volatile int sDefaultDelayMillis = 40;
    private final ByteBuffer mBuf;
    private final int mHeaderPos;
    private final int mScreenWidth;
    private final int mScreenHeight;
    @Nullable
    private final byte[] mGlobalPalette;
    private final byte[] mImage;
    @Nullable
    private byte[] mTmpPalette;
    private final byte[] mTmpImage;
    private final int[] mTmpInterlace;

    public GIFDecoder(ByteBuffer buf) throws IOException {
        int b;
        this.mBuf = buf;
        if (this.readByte() != 71 || this.readByte() != 73 || this.readByte() != 70 || this.readByte() != 56 || (b = this.readByte()) != 55 && b != 57 || this.readByte() != 97) {
            throw new IOException("Not GIF");
        }
        this.mScreenWidth = this.readShort();
        this.mScreenHeight = this.readShort();
        int packedField = this.readByte();
        this.skipBytes(2);
        this.mGlobalPalette = (byte[])((packedField & 0x80) != 0 ? this.readPalette(2 << (packedField & 7), -1, null) : null);
        this.mImage = new byte[this.mScreenWidth * this.mScreenHeight * 4];
        this.mTmpImage = new byte[this.mScreenWidth * this.mScreenHeight];
        this.mTmpInterlace = new int[this.mScreenHeight];
        this.mHeaderPos = this.mBuf.position();
    }

    public static boolean checkMagic(@Nonnull byte[] buf) {
        return buf.length >= 6 && buf[0] == 71 && buf[1] == 73 && buf[2] == 70 && buf[3] == 56 && (buf[4] == 55 || buf[4] == 57) && buf[5] == 97;
    }

    public int getScreenWidth() {
        return this.mScreenWidth;
    }

    public int getScreenHeight() {
        return this.mScreenHeight;
    }

    public int decodeNextFrame(ByteBuffer pixels) throws IOException {
        int imageControlCode = this.syncNextFrame();
        if (imageControlCode < 0) {
            throw new IOException();
        }
        int left = this.readShort();
        int top = this.readShort();
        int width = this.readShort();
        int height = this.readShort();
        if (left + width > this.mScreenWidth || top + height > this.mScreenHeight) {
            throw new IOException();
        }
        int packedField = this.readByte();
        boolean isTransparent = (imageControlCode >>> 24 & 1) != 0;
        int transparentIndex = isTransparent ? imageControlCode >>> 16 & 0xFF : -1;
        boolean localPalette = (packedField & 0x80) != 0;
        boolean isInterlaced = (packedField & 0x40) != 0;
        int paletteSize = 2 << (packedField & 7);
        if (this.mTmpPalette == null || this.mTmpPalette.length < paletteSize * 4) {
            this.mTmpPalette = new byte[paletteSize * 4];
        }
        byte[] palette = localPalette ? this.readPalette(paletteSize, transparentIndex, this.mTmpPalette) : Objects.requireNonNull(this.mGlobalPalette);
        int delayTime = imageControlCode & 0xFFFF;
        int disposalCode = imageControlCode >>> 26 & 7;
        this.decodeImage(this.mTmpImage, width, height, isInterlaced ? this.computeInterlaceReIndex(height, this.mTmpInterlace) : null);
        this.decodePalette(this.mTmpImage, palette, transparentIndex, left, top, width, height, disposalCode, pixels);
        return delayTime != 0 ? delayTime * 10 : sDefaultDelayMillis;
    }

    @Nonnull
    private byte[] readPalette(int size, int transparentIndex, @Nullable byte[] palette) throws IOException {
        if (palette == null) {
            palette = new byte[size * 4];
        }
        int iPos = 0;
        for (int i = 0; i < size; ++i) {
            try {
                this.mBuf.get(palette, iPos, 3);
            }
            catch (BufferUnderflowException e) {
                throw new EOFException();
            }
            palette[iPos + 3] = i == transparentIndex ? 0 : -1;
            iPos += 4;
        }
        return palette;
    }

    public void skipExtension() throws IOException {
        int blockSize = this.readByte();
        while (blockSize != 0) {
            this.skipBytes(blockSize);
            blockSize = this.readByte();
        }
    }

    private int readControlCode() throws IOException {
        int blockSize = this.readByte();
        int packedField = this.readByte();
        int delayTime = this.readShort();
        int transparentIndex = this.readByte();
        if (blockSize != 4 || this.readByte() != 0) {
            throw new IOException();
        }
        return ((packedField & 0x1F) << 24) + (transparentIndex << 16) + delayTime;
    }

    private int syncNextFrame() throws IOException {
        int ch;
        int controlData = 0;
        boolean restarted = false;
        block5: while (true) {
            ch = this.read();
            switch (ch) {
                case 44: {
                    return controlData;
                }
                case 33: {
                    if (this.readByte() == 249) {
                        controlData = this.readControlCode();
                        continue block5;
                    }
                    this.skipExtension();
                    continue block5;
                }
                case -1: 
                case 59: {
                    if (restarted) {
                        return -1;
                    }
                    this.mBuf.position(this.mHeaderPos);
                    controlData = 0;
                    restarted = true;
                    continue block5;
                }
            }
            break;
        }
        throw new IOException(String.valueOf(ch));
    }

    private void decodeImage(byte[] image, int width, int height, @Nullable int[] interlace) throws IOException {
        LZWDecoder dec = LZWDecoder.getInstance();
        byte[] data = dec.setData(this.mBuf, this.readByte());
        int y = 0;
        int iPos = 0;
        int xr = width;
        block0: while (true) {
            int len;
            if ((len = dec.readString()) == -1) {
                this.skipExtension();
                return;
            }
            int pos = 0;
            while (true) {
                if (pos >= len) continue block0;
                int ax = Math.min(xr, len - pos);
                System.arraycopy(data, pos, image, iPos, ax);
                iPos += ax;
                pos += ax;
                if ((xr -= ax) != 0) continue;
                if (++y == height) {
                    this.skipExtension();
                    return;
                }
                int iY = interlace == null ? y : interlace[y];
                iPos = iY * width;
                xr = width;
            }
            break;
        }
    }

    @Nonnull
    private int[] computeInterlaceReIndex(int height, int[] data) {
        int i;
        int pos = 0;
        for (i = 0; i < height; i += 8) {
            data[pos++] = i;
        }
        for (i = 4; i < height; i += 8) {
            data[pos++] = i;
        }
        for (i = 2; i < height; i += 4) {
            data[pos++] = i;
        }
        for (i = 1; i < height; i += 2) {
            data[pos++] = i;
        }
        return data;
    }

    private void restoreToBackground(byte[] image, int left, int top, int width, int height) {
        for (int y = 0; y < height; ++y) {
            int iPos = ((top + y) * this.mScreenWidth + left) * 4;
            for (int x = 0; x < width; ++x) {
                image[iPos + 3] = 0;
                iPos += 4;
            }
        }
    }

    private void decodePalette(byte[] srcImage, byte[] palette, int transparentIndex, int left, int top, int width, int height, int disposalCode, ByteBuffer pixels) {
        if (disposalCode == 3) {
            pixels.put(this.mImage);
            for (int y = 0; y < height; ++y) {
                int index;
                int x;
                int iPos = ((top + y) * this.mScreenWidth + left) * 4;
                int i = y * width;
                if (transparentIndex < 0) {
                    for (x = 0; x < width; ++x) {
                        index = 0xFF & srcImage[i + x];
                        pixels.put(iPos, palette, index * 4, 4);
                        iPos += 4;
                    }
                    continue;
                }
                for (x = 0; x < width; ++x) {
                    index = 0xFF & srcImage[i + x];
                    if (index != transparentIndex) {
                        pixels.put(iPos, palette, index * 4, 4);
                    }
                    iPos += 4;
                }
            }
            pixels.rewind();
        } else {
            byte[] image = this.mImage;
            for (int y = 0; y < height; ++y) {
                int index;
                int x;
                int iPos = ((top + y) * this.mScreenWidth + left) * 4;
                int i = y * width;
                if (transparentIndex < 0) {
                    for (x = 0; x < width; ++x) {
                        index = 0xFF & srcImage[i + x];
                        System.arraycopy(palette, index * 4, image, iPos, 4);
                        iPos += 4;
                    }
                    continue;
                }
                for (x = 0; x < width; ++x) {
                    index = 0xFF & srcImage[i + x];
                    if (index != transparentIndex) {
                        System.arraycopy(palette, index * 4, image, iPos, 4);
                    }
                    iPos += 4;
                }
            }
            pixels.put(image).rewind();
            if (disposalCode == 2) {
                this.restoreToBackground(this.mImage, left, top, width, height);
            }
        }
    }

    private int read() {
        try {
            return this.mBuf.get() & 0xFF;
        }
        catch (BufferUnderflowException e) {
            return -1;
        }
    }

    public int readByte() throws IOException {
        try {
            return this.mBuf.get() & 0xFF;
        }
        catch (BufferUnderflowException e) {
            throw new EOFException();
        }
    }

    private int readShort() throws IOException {
        int lsb = this.readByte();
        int msb = this.readByte();
        return lsb + (msb << 8);
    }

    private void skipBytes(int n) throws IOException {
        try {
            this.mBuf.position(this.mBuf.position() + n);
        }
        catch (IllegalArgumentException e) {
            throw new EOFException();
        }
    }
}

