/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.core.effects;

import icyllis.arc3d.core.ColorSpace;
import icyllis.arc3d.core.RawPtr;
import icyllis.arc3d.core.RefCnt;
import icyllis.arc3d.core.SharedPtr;
import icyllis.arc3d.core.effects.ColorFilter;
import java.util.Objects;

public final class ComposeColorFilter
extends RefCnt
implements ColorFilter {
    @SharedPtr
    private final ColorFilter mAfter;
    @SharedPtr
    private final ColorFilter mBefore;

    ComposeColorFilter(@SharedPtr ColorFilter before, @SharedPtr ColorFilter after) {
        this.mBefore = Objects.requireNonNull(before);
        this.mAfter = Objects.requireNonNull(after);
    }

    @Override
    protected void deallocate() {
        this.mAfter.unref();
        this.mBefore.unref();
    }

    @RawPtr
    public ColorFilter getBefore() {
        return this.mBefore;
    }

    @RawPtr
    public ColorFilter getAfter() {
        return this.mAfter;
    }

    @Override
    public boolean isAlphaUnchanged() {
        return this.mAfter.isAlphaUnchanged() && this.mBefore.isAlphaUnchanged();
    }

    @Override
    public void filterColor4f(float[] col, float[] out, ColorSpace dstCS) {
        this.mBefore.filterColor4f(col, out, dstCS);
        this.mAfter.filterColor4f(out, out, dstCS);
    }
}

