/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.core;

import icyllis.arc3d.core.Canvas;
import icyllis.arc3d.core.GenerationID;
import icyllis.arc3d.core.Image;
import icyllis.arc3d.core.ImageInfo;
import icyllis.arc3d.core.RawPtr;
import icyllis.arc3d.core.Rect2i;
import icyllis.arc3d.core.Rect2ic;
import icyllis.arc3d.core.RefCnt;
import icyllis.arc3d.core.SharedPtr;
import icyllis.arc3d.engine.BackendFormat;
import icyllis.arc3d.engine.BackendImage;
import icyllis.arc3d.engine.Caps;
import icyllis.arc3d.engine.RecordingContext;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jetbrains.annotations.ApiStatus;

public abstract class Surface
extends RefCnt {
    private final int mWidth;
    private final int mHeight;
    private GenerationID mGenerationID;
    private Canvas mCachedCanvas;
    @SharedPtr
    private Image mCachedImage;
    protected static final int kPreserve_ContentChangeMode = 0;
    protected static final int kDiscard_ContentChangeMode = 1;

    protected Surface(int width, int height) {
        assert (width > 0 && height > 0);
        this.mWidth = width;
        this.mHeight = height;
    }

    @Nullable
    public static Surface makeFromBackendTexture(RecordingContext context, BackendImage backendImage, int origin, int sampleCount, int colorType, Runnable releaseCallback) {
        if (context == null || sampleCount < 1 || colorType == 0) {
            if (releaseCallback != null) {
                releaseCallback.run();
            }
            return null;
        }
        if (!Surface.validateBackendTexture(context.getCaps(), backendImage, sampleCount, colorType, true)) {
            if (releaseCallback != null) {
                releaseCallback.run();
            }
            return null;
        }
        return null;
    }

    @Nullable
    public static Surface makeRenderTarget(RecordingContext context, ImageInfo imageInfo, int origin, int sampleCount, boolean mipmapped, boolean budgeted) {
        if (context == null || imageInfo == null || sampleCount < 1) {
            return null;
        }
        return null;
    }

    private static boolean validateBackendTexture(Caps caps, BackendImage backendImage, int sampleCount, int colorType, boolean texturable) {
        if (backendImage == null) {
            return false;
        }
        BackendFormat backendFormat = backendImage.getBackendFormat();
        if (!caps.isFormatCompatible(colorType, backendFormat)) {
            return false;
        }
        if (caps.isFormatRenderable(colorType, backendFormat, sampleCount)) {
            return false;
        }
        return !texturable || caps.isFormatTexturable(backendFormat);
    }

    @Override
    protected void deallocate() {
        if (this.mCachedCanvas != null) {
            this.mCachedCanvas.mSurface = null;
            this.mCachedCanvas.close();
            this.mCachedCanvas = null;
        }
        this.mCachedImage = RefCnt.move(this.mCachedImage);
    }

    public final int getWidth() {
        return this.mWidth;
    }

    public final int getHeight() {
        return this.mHeight;
    }

    @Nonnull
    public abstract ImageInfo getImageInfo();

    public final GenerationID getGenerationID() {
        if (this.mGenerationID == null) {
            assert (this.mCachedCanvas == null || this.mCachedCanvas.mSurface == this);
            this.mGenerationID = new GenerationID();
        }
        return this.mGenerationID;
    }

    public final void notifyWillChange() {
        this.aboutToDraw(1);
    }

    @RawPtr
    public final RecordingContext getRecordingContext() {
        return this.onGetRecordingContext();
    }

    @RawPtr
    public final Canvas getCanvas() {
        return this.getCachedCanvas();
    }

    @Nullable
    @SharedPtr
    public final Image makeImageSnapshot() {
        return RefCnt.create(this.getCachedImage());
    }

    @Nullable
    @SharedPtr
    public final Image makeImageSnapshot(@Nonnull Rect2ic subset) {
        Rect2i bounds = new Rect2i(subset);
        if (!bounds.intersect(0, 0, this.mWidth, this.mHeight)) {
            return null;
        }
        assert (!bounds.isEmpty());
        if (bounds.mLeft == 0 && bounds.mTop == 0 && bounds.mRight == this.mWidth && bounds.mBottom == this.mHeight) {
            return this.makeImageSnapshot();
        }
        return this.onNewImageSnapshot(bounds);
    }

    @ApiStatus.Internal
    @RawPtr
    public final Canvas getCachedCanvas() {
        if (this.mCachedCanvas == null) {
            this.mCachedCanvas = this.onNewCanvas();
            if (this.mCachedCanvas != null) {
                this.mCachedCanvas.mSurface = this;
            }
        }
        return this.mCachedCanvas;
    }

    @ApiStatus.Internal
    @RawPtr
    public final Image getCachedImage() {
        if (this.mCachedImage != null) {
            return this.mCachedImage;
        }
        this.mCachedImage = this.onNewImageSnapshot(null);
        assert (this.mCachedCanvas == null || this.mCachedCanvas.mSurface == this);
        return this.mCachedImage;
    }

    @ApiStatus.Internal
    public final boolean hasCachedImage() {
        return this.mCachedImage != null;
    }

    @ApiStatus.Internal
    @RawPtr
    protected RecordingContext onGetRecordingContext() {
        return null;
    }

    @ApiStatus.Internal
    @RawPtr
    protected abstract Canvas onNewCanvas();

    @Nullable
    @ApiStatus.Internal
    @SharedPtr
    protected abstract Image onNewImageSnapshot(@Nullable Rect2ic var1);

    @ApiStatus.Internal
    protected void onDiscard() {
    }

    @ApiStatus.Internal
    protected abstract boolean onCopyOnWrite(int var1);

    @ApiStatus.Internal
    protected void onRestoreBackingMutability() {
    }

    final boolean hasOutstandingImageSnapshot() {
        return this.mCachedImage != null && !this.mCachedImage.unique();
    }

    final boolean aboutToDraw(int changeMode) {
        this.mGenerationID = null;
        assert (this.mCachedCanvas == null || this.mCachedCanvas.mSurface == this);
        if (this.mCachedImage != null) {
            boolean unique = this.mCachedImage.unique();
            if (!unique && !this.onCopyOnWrite(changeMode)) {
                return false;
            }
            this.mCachedImage = RefCnt.move(this.mCachedImage);
            if (unique) {
                this.onRestoreBackingMutability();
            }
        } else if (changeMode == 1) {
            this.onDiscard();
        }
        return true;
    }
}

