/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.core;

import icyllis.arc3d.core.MathUtil;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class SamplingOptions {
    public static final int FILTER_MODE_NEAREST = 0;
    public static final int FILTER_MODE_LINEAR = 1;
    public static final int MIPMAP_MODE_NONE = 0;
    public static final int MIPMAP_MODE_NEAREST = 1;
    public static final int MIPMAP_MODE_LINEAR = 2;
    public static final SamplingOptions POINT = new SamplingOptions(0);
    public static final SamplingOptions LINEAR = new SamplingOptions(1);
    public static final SamplingOptions MIN_MAG_MIP_POINT = new SamplingOptions(0, 1);
    public static final SamplingOptions MIN_MAG_POINT_MIP_LINEAR = new SamplingOptions(0, 2);
    public static final SamplingOptions MIN_MAG_LINEAR_MIP_POINT = new SamplingOptions(1, 1);
    public static final SamplingOptions MIN_MAG_MIP_LINEAR = new SamplingOptions(1, 2);
    public static final SamplingOptions MIN_POINT_MAG_LINEAR = new SamplingOptions(0, 1, 0);
    public static final SamplingOptions MIN_LINEAR_MAG_POINT = new SamplingOptions(1, 0, 0);
    public static final SamplingOptions MIN_POINT_MAG_LINEAR_MIP_POINT = new SamplingOptions(0, 1, 1);
    public static final SamplingOptions MIN_LINEAR_MAG_MIP_POINT = new SamplingOptions(1, 0, 1);
    public static final SamplingOptions MIN_POINT_MAG_MIP_LINEAR = new SamplingOptions(0, 1, 2);
    public static final SamplingOptions MIN_LINEAR_MAG_POINT_MIP_LINEAR = new SamplingOptions(1, 0, 2);
    public static final SamplingOptions CUBIC_BSPLINE = new SamplingOptions(1.0f, 0.0f, 0);
    public static final SamplingOptions MITCHELL = new SamplingOptions(0.33333334f, 0.33333334f, 0);
    public static final SamplingOptions PHOTOSHOP_BICUBIC = new SamplingOptions(0.0f, 0.75f, 0);
    public static final SamplingOptions CATMULLROM = new SamplingOptions(0.0f, 0.5f, 0);
    static final SamplingOptions[] COMMON_SAMPLING_OPTIONS = new SamplingOptions[]{POINT, MIN_LINEAR_MAG_POINT, MIN_POINT_MAG_LINEAR, LINEAR, MIN_MAG_MIP_POINT, MIN_LINEAR_MAG_MIP_POINT, MIN_POINT_MAG_LINEAR_MIP_POINT, MIN_MAG_LINEAR_MIP_POINT, MIN_MAG_POINT_MIP_LINEAR, MIN_LINEAR_MAG_POINT_MIP_LINEAR, MIN_POINT_MAG_MIP_LINEAR, MIN_MAG_MIP_LINEAR};
    public final byte mMinFilter;
    public final byte mMagFilter;
    public final byte mMipmapMode;
    public final boolean mUseCubic;
    public final float mCubicB;
    public final float mCubicC;
    public final int mMaxAnisotropy;

    SamplingOptions(int filter) {
        this(filter, filter, 0);
    }

    SamplingOptions(int filter, int mipmap) {
        this(filter, filter, mipmap);
    }

    SamplingOptions(int minFilter, int magFilter, int mipmapMode) {
        this.mMinFilter = (byte)minFilter;
        this.mMagFilter = (byte)magFilter;
        this.mMipmapMode = (byte)mipmapMode;
        this.mUseCubic = false;
        this.mCubicC = 0.0f;
        this.mCubicB = 0.0f;
        this.mMaxAnisotropy = 0;
    }

    SamplingOptions(float cubicB, float cubicC, int maxAnisotropy) {
        this.mMagFilter = 0;
        this.mMinFilter = 0;
        this.mMipmapMode = 0;
        this.mUseCubic = maxAnisotropy == 0;
        this.mCubicB = cubicB;
        this.mCubicC = cubicC;
        this.mMaxAnisotropy = maxAnisotropy;
    }

    public static SamplingOptions make(int filter) {
        return filter == 0 ? POINT : LINEAR;
    }

    public static SamplingOptions make(int filter, int mipmap) {
        return SamplingOptions.make(filter, filter, mipmap);
    }

    public static SamplingOptions make(int minFilter, int magFilter, int mipmapMode) {
        int index = minFilter | magFilter << 1 | mipmapMode << 2;
        return COMMON_SAMPLING_OPTIONS[index];
    }

    public static SamplingOptions makeCubic(float B, float C) {
        return new SamplingOptions(MathUtil.pin(B, 0.0f, 1.0f), MathUtil.pin(C, 0.0f, 1.0f), 0);
    }

    public static SamplingOptions makeAnisotropy(int maxAnisotropy) {
        return new SamplingOptions(0.0f, 0.0f, Math.max(maxAnisotropy, 1));
    }

    public boolean isAnisotropy() {
        return this.mMaxAnisotropy != 0;
    }

    public int hashCode() {
        int result = this.mMinFilter;
        result = 31 * result + this.mMagFilter;
        result = 31 * result + this.mMipmapMode;
        result = 31 * result + (this.mUseCubic ? 1 : 0);
        result = 31 * result + Float.floatToIntBits(this.mCubicB);
        result = 31 * result + Float.floatToIntBits(this.mCubicC);
        result = 31 * result + this.mMaxAnisotropy;
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof SamplingOptions) {
            SamplingOptions that = (SamplingOptions)o;
            return this.mMinFilter == that.mMinFilter && this.mMagFilter == that.mMagFilter && this.mMipmapMode == that.mMipmapMode && this.mUseCubic == that.mUseCubic && this.mCubicB == that.mCubicB && this.mCubicC == that.mCubicC && this.mMaxAnisotropy == that.mMaxAnisotropy;
        }
        return false;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MipmapMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface FilterMode {
    }
}

