/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.core;

import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;

public class Pair<L, R>
implements Map.Entry<L, R> {
    L left;
    R right;

    public Pair() {
    }

    public Pair(L left, R right) {
        this.left = left;
        this.right = right;
    }

    @Nonnull
    public static <L, R> Pair<L, R> of(L left, R right) {
        return new Pair<L, R>(left, right);
    }

    @Nonnull
    public static <L, R> Pair<L, R> of(Map.Entry<L, R> entry) {
        if (entry == null) {
            return new Pair<L, R>();
        }
        return new Pair<L, R>(entry.getKey(), entry.getValue());
    }

    @Override
    public final L getKey() {
        return this.left;
    }

    @Override
    public final R getValue() {
        return this.right;
    }

    @Override
    public R setValue(R value) {
        throw new UnsupportedOperationException();
    }

    public final L getLeft() {
        return this.left;
    }

    public final R getRight() {
        return this.right;
    }

    public final L getFirst() {
        return this.left;
    }

    public final R getSecond() {
        return this.right;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.left) ^ Objects.hashCode(this.right);
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof Map.Entry) {
            Map.Entry e = (Map.Entry)o;
            return Objects.equals(this.left, e.getKey()) && Objects.equals(this.right, e.getValue());
        }
        return false;
    }

    public String toString() {
        return "(" + this.left + "," + this.right + ")";
    }
}

