/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.core;

import icyllis.arc3d.core.Blender;
import icyllis.arc3d.core.Canvas;
import icyllis.arc3d.core.GlyphRunList;
import icyllis.arc3d.core.Image;
import icyllis.arc3d.core.Matrix4c;
import icyllis.arc3d.core.NoDrawCanvas;
import icyllis.arc3d.core.Paint;
import icyllis.arc3d.core.RawPtr;
import icyllis.arc3d.core.Rect2fc;
import icyllis.arc3d.core.RefCnt;
import icyllis.arc3d.core.RoundRect;
import icyllis.arc3d.core.SamplingOptions;
import icyllis.arc3d.core.SharedPtr;
import icyllis.arc3d.core.TextBlob;
import icyllis.arc3d.core.Vertices;
import java.util.Arrays;

public class NWayCanvas
extends NoDrawCanvas {
    protected Canvas[] mList = new Canvas[10];
    protected int mSize = 0;

    public NWayCanvas(int width, int height) {
        super(width, height);
    }

    @Override
    public void close() {
        this.removeAll();
        super.close();
    }

    public void addCanvas(@RawPtr Canvas canvas) {
        assert (this.mSize == 0 || this.mList[0].getRootDevice() != this.getRootDevice());
        if (canvas != null) {
            if (this.mSize == this.mList.length) {
                this.mList = Arrays.copyOf(this.mList, this.mSize + (this.mSize >> 1));
            }
            this.mList[this.mSize++] = canvas;
        }
    }

    public void removeCanvas(@RawPtr Canvas canvas) {
        int index = -1;
        for (int i = 0; i < this.mSize; ++i) {
            if (this.mList[i] != canvas) continue;
            index = i;
            break;
        }
        if (index != -1) {
            this.mList[index] = this.mList[this.mSize - 1];
            this.mList[--this.mSize] = null;
        }
    }

    public void removeAll() {
        for (int i = 0; i < this.mSize; ++i) {
            this.mList[i] = null;
        }
        this.mSize = 0;
    }

    @Override
    protected void willSave() {
        for (int i = 0; i < this.mSize; ++i) {
            this.mList[i].save();
        }
        super.willSave();
    }

    @Override
    protected void willRestore() {
        for (int i = 0; i < this.mSize; ++i) {
            this.mList[i].restore();
        }
        super.willRestore();
    }

    @Override
    protected void didTranslate(float dx, float dy, float dz) {
        for (int i = 0; i < this.mSize; ++i) {
            this.mList[i].translate(dx, dy, dz);
        }
    }

    @Override
    protected void didScale(float sx, float sy, float sz) {
        for (int i = 0; i < this.mSize; ++i) {
            this.mList[i].scale(sx, sy, sz);
        }
    }

    @Override
    protected void didConcat(Matrix4c matrix) {
        for (int i = 0; i < this.mSize; ++i) {
            this.mList[i].concat(matrix);
        }
    }

    @Override
    protected void didSetMatrix(Matrix4c matrix) {
        for (int i = 0; i < this.mSize; ++i) {
            this.mList[i].setMatrix(matrix);
        }
    }

    @Override
    protected void onClipRect(Rect2fc rect, int clipOp, boolean doAA) {
        for (int i = 0; i < this.mSize; ++i) {
            this.mList[i].clipRect(rect, clipOp, doAA);
        }
        super.onClipRect(rect, clipOp, doAA);
    }

    @Override
    protected void onDrawPaint(Paint paint) {
        for (int i = 0; i < this.mSize; ++i) {
            this.mList[i].drawPaint(paint);
        }
    }

    @Override
    protected void onDrawPoints(int mode, float[] pts, int offset, int count, Paint paint) {
        for (int i = 0; i < this.mSize; ++i) {
            this.mList[i].drawPoints(mode, pts, offset, count, paint);
        }
    }

    @Override
    protected void onDrawLine(float x0, float y0, float x1, float y1, int cap, float width, Paint paint) {
        for (int i = 0; i < this.mSize; ++i) {
            this.mList[i].drawLine(x0, y0, x1, y1, cap, width, paint);
        }
    }

    @Override
    protected void onDrawRect(Rect2fc r, Paint paint) {
        for (int i = 0; i < this.mSize; ++i) {
            this.mList[i].drawRect(r, paint);
        }
    }

    @Override
    protected void onDrawRoundRect(RoundRect rr, Paint paint) {
        for (int i = 0; i < this.mSize; ++i) {
            this.mList[i].drawRoundRect(rr, paint);
        }
    }

    @Override
    protected void onDrawCircle(float cx, float cy, float radius, Paint paint) {
        for (int i = 0; i < this.mSize; ++i) {
            this.mList[i].drawCircle(cx, cy, radius, paint);
        }
    }

    @Override
    protected void onDrawArc(float cx, float cy, float radius, float startAngle, float sweepAngle, int cap, float width, Paint paint) {
        for (int i = 0; i < this.mSize; ++i) {
            this.mList[i].drawArc(cx, cy, radius, startAngle, sweepAngle, cap, width, paint);
        }
    }

    @Override
    protected void onDrawPie(float cx, float cy, float radius, float startAngle, float sweepAngle, Paint paint) {
        for (int i = 0; i < this.mSize; ++i) {
            this.mList[i].drawPie(cx, cy, radius, startAngle, sweepAngle, paint);
        }
    }

    @Override
    protected void onDrawChord(float cx, float cy, float radius, float startAngle, float sweepAngle, Paint paint) {
        for (int i = 0; i < this.mSize; ++i) {
            this.mList[i].drawChord(cx, cy, radius, startAngle, sweepAngle, paint);
        }
    }

    @Override
    protected void onDrawImageRect(@RawPtr Image image, Rect2fc src, Rect2fc dst, SamplingOptions sampling, Paint paint, int constraint) {
        for (int i = 0; i < this.mSize; ++i) {
            this.mList[i].drawImageRect(image, src, dst, sampling, paint, constraint);
        }
    }

    @Override
    protected void onDrawTextBlob(TextBlob blob, float originX, float originY, Paint paint) {
        for (int i = 0; i < this.mSize; ++i) {
            this.mList[i].drawTextBlob(blob, originX, originY, paint);
        }
    }

    @Override
    protected void onDrawGlyphRunList(GlyphRunList glyphRunList, Paint paint) {
        for (int i = 0; i < this.mSize; ++i) {
            this.mList[i].onDrawGlyphRunList(glyphRunList, paint);
        }
    }

    @Override
    protected void onDrawVertices(Vertices vertices, @SharedPtr Blender blender, Paint paint) {
        for (int i = 0; i < this.mSize; ++i) {
            this.mList[i].drawVertices(vertices, RefCnt.create(blender), paint);
        }
        RefCnt.move(blender);
    }
}

