/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.core;

import icyllis.arc3d.core.PixelUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import org.jetbrains.annotations.ApiStatus;

public final class ColorInfo {
    public static final int COMPRESSION_NONE = 0;
    public static final int COMPRESSION_ETC2_RGB8_UNORM = 1;
    public static final int COMPRESSION_BC1_RGB8_UNORM = 2;
    public static final int COMPRESSION_BC1_RGBA8_UNORM = 3;
    public static final int COMPRESSION_COUNT = 4;
    public static final int AT_UNKNOWN = 0;
    public static final int AT_OPAQUE = 1;
    public static final int AT_PREMUL = 2;
    public static final int AT_UNPREMUL = 3;
    public static final int CT_UNKNOWN = 0;
    public static final int CT_BGR_565 = 1;
    public static final int CT_R_8 = 2;
    public static final int CT_RG_88 = 3;
    @ApiStatus.Internal
    public static final int CT_RGB_888 = 4;
    public static final int CT_RGBX_8888 = 5;
    public static final int CT_RGBA_8888 = 6;
    public static final int CT_BGRA_8888 = 7;
    @ApiStatus.Internal
    public static final int CT_RGBA_8888_SRGB = 8;
    public static final int CT_RGBA_1010102 = 9;
    public static final int CT_BGRA_1010102 = 10;
    @ApiStatus.Internal
    public static final int CT_R_16 = 11;
    @ApiStatus.Internal
    public static final int CT_R_F16 = 12;
    @ApiStatus.Internal
    public static final int CT_RG_1616 = 13;
    @ApiStatus.Internal
    public static final int CT_RG_F16 = 14;
    public static final int CT_RGBA_16161616 = 15;
    public static final int CT_RGBA_F16 = 16;
    public static final int CT_RGBA_F16_CLAMPED = 17;
    public static final int CT_RGBA_F32 = 18;
    public static final int CT_ALPHA_8 = 19;
    public static final int CT_ALPHA_16 = 20;
    public static final int CT_ALPHA_F16 = 21;
    public static final int CT_GRAY_8 = 22;
    @ApiStatus.Internal
    public static final int CT_GRAY_ALPHA_88 = 23;
    @ApiStatus.Internal
    public static final int CT_ABGR_8888 = 24;
    @ApiStatus.Internal
    public static final int CT_ARGB_8888 = 25;
    public static final int CT_RGBA_8888_NATIVE = PixelUtils.NATIVE_BIG_ENDIAN ? 24 : 6;
    public static final int CT_BGRA_8888_NATIVE = PixelUtils.NATIVE_BIG_ENDIAN ? 25 : 7;
    public static final int CT_R5G6B5_UNORM = 1;
    public static final int CT_R8G8_UNORM = 3;
    public static final int CT_A16_UNORM = 20;
    public static final int CT_A16_FLOAT = 21;
    public static final int CT_A16G16_UNORM = 13;
    public static final int CT_R16G16_FLOAT = 14;
    public static final int CT_R16G16B16A16_UNORM = 15;
    @ApiStatus.Internal
    public static final int CT_COUNT = 26;

    public static int colorTypeCount() {
        return 26;
    }

    public static int bytesPerPixel(int ct) {
        return switch (ct) {
            case 0 -> 0;
            case 2, 19, 22 -> 1;
            case 1, 3, 11, 12, 20, 21, 23 -> 2;
            case 4 -> 3;
            case 5, 6, 7, 8, 9, 10, 13, 14, 24, 25 -> 4;
            case 15, 16, 17 -> 8;
            case 18 -> 16;
            default -> throw new AssertionError(ct);
        };
    }

    public static int maxBitsPerChannel(int ct) {
        return switch (ct) {
            case 0 -> 0;
            case 1 -> 6;
            case 2, 3, 4, 5, 6, 7, 8, 19, 22, 23, 24, 25 -> 8;
            case 9, 10 -> 10;
            case 11, 12, 13, 14, 15, 16, 17, 20, 21 -> 16;
            case 18 -> 32;
            default -> throw new AssertionError(ct);
        };
    }

    public static int validateAlphaType(int ct, int at) {
        switch (ct) {
            case 0: {
                at = 0;
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                if (at == 3) {
                    at = 2;
                }
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 23: 
            case 24: 
            case 25: {
                if (at == 1 || at == 2 || at == 3) break;
                throw new IllegalArgumentException("at is unknown");
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 22: {
                at = 1;
                break;
            }
            default: {
                throw new AssertionError(ct);
            }
        }
        return at;
    }

    @ApiStatus.Internal
    public static int colorTypeChannelFlags(int ct) {
        return switch (ct) {
            case 0 -> 0;
            case 19, 20, 21 -> 8;
            case 1, 4, 5 -> 7;
            case 6, 7, 8, 9, 10, 15, 16, 17, 18, 24, 25 -> 15;
            case 3, 13, 14 -> 3;
            case 22 -> 16;
            case 2, 11, 12 -> 1;
            case 23 -> 24;
            default -> throw new AssertionError(ct);
        };
    }

    public static boolean colorTypeIsAlphaOnly(int ct) {
        return ColorInfo.colorTypeChannelFlags(ct) == 8;
    }

    public static String colorTypeToString(int ct) {
        return switch (ct) {
            case 0 -> "UNKNOWN";
            case 2 -> "R_8";
            case 19 -> "ALPHA_8";
            case 22 -> "GRAY_8";
            case 1 -> "BGR_565";
            case 3 -> "RG_88";
            case 11 -> "R_16";
            case 12 -> "R_F16";
            case 20 -> "ALPHA_16";
            case 21 -> "ALPHA_F16";
            case 23 -> "GRAY_ALPHA_88";
            case 4 -> "RGB_888";
            case 5 -> "RGBX_8888";
            case 6 -> "RGBA_8888";
            case 7 -> "BGRA_8888";
            case 24 -> "ABGR_8888";
            case 25 -> "ARGB_8888";
            case 10 -> "BGRA_1010102";
            case 9 -> "RGBA_1010102";
            case 13 -> "RG_1616";
            case 14 -> "RG_F16";
            case 8 -> "RGBA_8888_SRGB";
            case 15 -> "RGBA_16161616";
            case 16 -> "RGBA_F16";
            case 17 -> "RGBA_F16_CLAMPED";
            case 18 -> "RGBA_F32";
            default -> throw new AssertionError(ct);
        };
    }

    private ColorInfo() {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @ApiStatus.Internal
    public static @interface ColorType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @ApiStatus.Internal
    public static @interface AlphaType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @ApiStatus.Internal
    public static @interface CompressionType {
    }
}

