/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.network.shared;

import dev.technici4n.moderndynamics.network.TickHelper;
import java.util.Arrays;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_2350;

public class TransferLimits
extends SnapshotParticipant<long[]> {
    private static final long MAX_TICK_DIFF = 20L;
    private static final long MAX_BUFFER_FACTOR = 50L;
    private long lastUpdateTick = 0L;
    private final long[] available = new long[6];
    private final LimitSupplier limitSupplier;
    private final long maxBuffer;

    public TransferLimits(LimitSupplier limitSupplier, long maxBuffer) {
        this.limitSupplier = limitSupplier;
        this.maxBuffer = maxBuffer;
    }

    private void checkForNewTick() {
        long currentTick = TickHelper.getTickCounter();
        if (currentTick != this.lastUpdateTick) {
            if (this.maxBuffer <= 0L || this.lastUpdateTick == 0L) {
                for (class_2350 dir : class_2350.values()) {
                    int i = dir.method_10146();
                    this.available[i] = this.limitSupplier.getLimit(dir);
                }
            } else {
                long tickDiff = currentTick - this.lastUpdateTick;
                for (class_2350 dir : class_2350.values()) {
                    int i = dir.method_10146();
                    long tickLimit = this.limitSupplier.getLimit(dir);
                    if (tickLimit > 0L) {
                        long potentialBuffer = Math.min(this.available[i] + tickLimit * tickDiff, this.maxBuffer);
                        this.available[i] = Math.max(potentialBuffer, tickLimit);
                        continue;
                    }
                    this.available[i] = 0L;
                }
            }
            this.lastUpdateTick = currentTick;
        }
    }

    public long limit(int side, long amount) {
        StoragePreconditions.notNegative((long)amount);
        this.checkForNewTick();
        if (this.limitSupplier.getLimit(class_2350.method_10143((int)side)) == 0L) {
            return 0L;
        }
        return Math.min(this.available[side], amount);
    }

    public void use(int side, long amount, TransactionContext tx) {
        this.updateSnapshots(tx);
        int n = side;
        this.available[n] = this.available[n] - amount;
    }

    protected long[] createSnapshot() {
        return Arrays.copyOf(this.available, this.available.length);
    }

    protected void readSnapshot(long[] snapshot) {
        System.arraycopy(snapshot, 0, this.available, 0, snapshot.length);
    }

    @FunctionalInterface
    public static interface LimitSupplier {
        public long getLimit(class_2350 var1);
    }
}

