/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.network.mienergy;

import dev.technici4n.moderndynamics.attachment.AttachmentItem;
import dev.technici4n.moderndynamics.compat.mi.MIProxy;
import dev.technici4n.moderndynamics.network.NetworkManager;
import dev.technici4n.moderndynamics.network.NodeHost;
import dev.technici4n.moderndynamics.network.mienergy.MICableTier;
import dev.technici4n.moderndynamics.network.mienergy.MIEnergyCache;
import dev.technici4n.moderndynamics.pipe.PipeBlockEntity;
import java.util.List;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import org.jetbrains.annotations.Nullable;
import team.reborn.energy.api.EnergyStorage;

public class MIEnergyHost
extends NodeHost {
    private static final NetworkManager<MIEnergyHost, MIEnergyCache> MANAGER = NetworkManager.get(MIEnergyCache.class, MIEnergyCache::new);
    public final MICableTier tier;
    private long energy = 0L;

    public MIEnergyHost(PipeBlockEntity pipe, MICableTier tier) {
        super(pipe);
        this.tier = tier;
    }

    @Override
    protected void doUpdate() {
        this.updateConnections();
    }

    @Override
    public boolean acceptsAttachment(AttachmentItem attachment, class_1799 stack) {
        return false;
    }

    @Override
    public boolean canConnectTo(class_2350 connectionDirection, NodeHost adjacentHost) {
        return super.canConnectTo(connectionDirection, adjacentHost) && ((MIEnergyHost)adjacentHost).tier == this.tier;
    }

    public void gatherCapabilities(@Nullable List<EnergyStorage> out) {
        int oldConnections = this.inventoryConnections;
        for (int i = 0; i < 6; ++i) {
            if ((this.inventoryConnections & 1 << i) <= 0 || (this.pipeConnections & 1 << i) != 0) continue;
            class_2350 dir = class_2350.method_10143((int)i);
            EnergyStorage adjacentCap = (EnergyStorage)MIProxy.INSTANCE.getLookup().find(this.pipe.method_10997(), this.pipe.method_11016().method_10093(dir), (Object)dir.method_10153());
            if (adjacentCap != null && MIProxy.INSTANCE.canConnect(adjacentCap, this.tier)) {
                if (out == null) continue;
                out.add(adjacentCap);
                continue;
            }
            this.inventoryConnections ^= 1 << i;
        }
        if (oldConnections != this.inventoryConnections) {
            this.pipe.sync();
        }
    }

    public void updateConnections() {
        int oldConnections = this.inventoryConnections;
        this.inventoryConnections = 63 - (this.pipeConnections | this.pipe.connectionBlacklist);
        this.gatherCapabilities(null);
        if (oldConnections != this.inventoryConnections) {
            this.pipe.sync();
        }
    }

    @Override
    public void writeNbt(class_2487 tag) {
        super.writeNbt(tag);
        tag.method_10544("mi_energy", this.energy);
    }

    @Override
    public void readNbt(class_2487 tag) {
        super.readNbt(tag);
        this.energy = Math.max(0L, Math.min(tag.method_10537("mi_energy"), this.getMaxEnergy()));
    }

    @Override
    public NetworkManager<MIEnergyHost, MIEnergyCache> getManager() {
        return MANAGER;
    }

    @Override
    @Nullable
    public Object getApiInstance(BlockApiLookup<?, class_2350> lookup, @Nullable class_2350 side) {
        return null;
    }

    public long getEnergy() {
        return this.energy;
    }

    public long getMaxEnergy() {
        return this.tier.getMax();
    }

    public void setEnergy(long energy) {
        if (energy < 0L || energy > this.getMaxEnergy()) {
            throw new IllegalArgumentException("Invalid energy value " + energy);
        }
        this.energy = energy;
        this.pipe.method_5431();
    }
}

