/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.network.item;

import dev.technici4n.moderndynamics.network.item.SimulatedInsertionTargets;
import dev.technici4n.moderndynamics.network.item.StartTravelCallback;
import it.unimi.dsi.fastutil.objects.Object2LongLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_148;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_5539;
import org.jetbrains.annotations.Nullable;

public class SimulatedInsertionTarget {
    private final SimulatedInsertionTargets.Coord coord;
    private final Supplier<@Nullable Storage<ItemVariant>> storageFinder;
    private final Object2LongMap<ItemVariant> awaitedStacks = new Object2LongLinkedOpenHashMap();
    private final Participant participant = new Participant();

    public SimulatedInsertionTarget(SimulatedInsertionTargets.Coord coord, Supplier<@Nullable Storage<ItemVariant>> storageFinder) {
        this.coord = coord;
        this.storageFinder = storageFinder;
    }

    public boolean hasStorage() {
        return this.storageFinder.get() != null;
    }

    public long insert(ItemVariant variant, long maxAmount, TransactionContext transaction, StartTravelCallback callback) {
        try {
            return this.innerInsert(variant, maxAmount, transaction, callback);
        }
        catch (Throwable t) {
            class_128 report = class_128.method_560((Throwable)t, (String)"Item pipe simulated insertion failed");
            class_129 target = report.method_562("Simulated insertion details");
            class_129.method_586((class_129)target, (class_5539)this.coord.world(), (class_2338)this.coord.pos(), (class_2680)this.coord.world().method_8320(this.coord.pos()));
            target.method_578("Accessed from side", (Object)this.coord.direction());
            target.method_577("Storage", () -> Objects.toString(this.storageFinder.get(), null)).method_578("Item variant", (Object)variant).method_578("Max amount", (Object)maxAmount).method_578("Transaction", (Object)transaction);
            throw new class_148(report);
        }
    }

    private long innerInsert(ItemVariant variant, long maxAmount, TransactionContext transaction, StartTravelCallback callback) {
        StoragePreconditions.notBlankNotNegative((TransferVariant)variant, (long)maxAmount);
        Storage<ItemVariant> targetStorage = this.storageFinder.get();
        if (targetStorage == null) {
            return 0L;
        }
        try (Transaction nested = transaction.openNested();){
            for (Object2LongMap.Entry entry : this.awaitedStacks.object2LongEntrySet()) {
                if (targetStorage.insert((Object)((ItemVariant)entry.getKey()), entry.getLongValue(), (TransactionContext)nested) == entry.getLongValue()) continue;
                long l = 0L;
                return l;
            }
            maxAmount = targetStorage.insert((Object)variant, maxAmount, (TransactionContext)nested);
        }
        if (maxAmount == 0L) {
            return 0L;
        }
        this.participant.updateSnapshots(transaction);
        this.startAwaiting(variant, maxAmount);
        this.participant.pendingStacks.add(new PendingStack(variant, maxAmount, callback));
        return maxAmount;
    }

    public void startAwaiting(ItemVariant variant, long amount) {
        this.awaitedStacks.mergeLong((Object)variant, amount, Long::sum);
    }

    public void stopAwaiting(ItemVariant variant, long amount) {
        long awaited = this.awaitedStacks.removeLong((Object)variant);
        if (awaited > amount) {
            this.awaitedStacks.put((Object)variant, awaited - amount);
        }
    }

    private class Participant
    extends SnapshotParticipant<Integer> {
        private final List<PendingStack> pendingStacks = new ArrayList<PendingStack>();

        private Participant() {
        }

        protected Integer createSnapshot() {
            return this.pendingStacks.size();
        }

        protected void readSnapshot(Integer snapshot) {
            while (this.pendingStacks.size() > snapshot) {
                PendingStack stack = this.pendingStacks.remove(this.pendingStacks.size() - 1);
                SimulatedInsertionTarget.this.stopAwaiting(stack.variant, stack.amount);
            }
        }

        protected void onFinalCommit() {
            for (PendingStack pendingStack : this.pendingStacks) {
                pendingStack.callback.startTravel(pendingStack.variant, pendingStack.amount);
            }
            this.pendingStacks.clear();
        }
    }

    private record PendingStack(ItemVariant variant, long amount, StartTravelCallback callback) {
    }
}

