/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.network.item;

import dev.technici4n.moderndynamics.attachment.attached.AttachedAttachment;
import dev.technici4n.moderndynamics.attachment.attached.ItemAttachedIo;
import dev.technici4n.moderndynamics.network.NetworkNode;
import dev.technici4n.moderndynamics.network.item.FailedInsertStrategy;
import dev.technici4n.moderndynamics.network.item.ItemCache;
import dev.technici4n.moderndynamics.network.item.ItemHost;
import dev.technici4n.moderndynamics.network.item.SimulatedInsertionTarget;
import dev.technici4n.moderndynamics.network.item.SimulatedInsertionTargets;
import dev.technici4n.moderndynamics.network.item.TravelingItem;
import dev.technici4n.moderndynamics.pipe.PipeBlockEntity;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;

public class ItemPath {
    public final class_2338 startingPos;
    public final class_2338 targetPos;
    public final class_2350[] path;
    @Nullable
    private ItemPath reversed;

    public ItemPath(class_2338 startingPos, class_2338 targetPos, class_2350[] path) {
        this(startingPos, targetPos, path, null);
    }

    private ItemPath(class_2338 startingPos, class_2338 targetPos, class_2350[] path, @Nullable ItemPath reversed) {
        this.startingPos = startingPos;
        this.targetPos = targetPos;
        this.path = path;
        this.reversed = reversed;
    }

    public NetworkNode<ItemHost, ItemCache> getStartingPoint(class_3218 level) {
        return ItemHost.MANAGER.findNode(level, this.startingPos.method_10093(this.path[0]));
    }

    public SimulatedInsertionTarget getInsertionTarget(class_1937 world) {
        return SimulatedInsertionTargets.getTarget(world, this.targetPos, this.getTargetBlockSide());
    }

    public class_2350 getLastDirection() {
        return this.path[this.path.length - 1];
    }

    public class_2350 getTargetBlockSide() {
        return this.getLastDirection().method_10153();
    }

    public TravelingItem makeTravelingItem(ItemVariant variant, long amount, double speedMultiplier) {
        return new TravelingItem(variant, amount, this, FailedInsertStrategy.SEND_BACK_TO_SOURCE, speedMultiplier, 0.0);
    }

    @Nullable
    AttachedAttachment getEndAttachment(class_3218 level) {
        NetworkNode<ItemHost, ItemCache> lastNode = ItemHost.MANAGER.findNode(level, this.targetPos.method_10093(this.getTargetBlockSide()));
        ItemHost host = lastNode.getHost();
        return host.getAttachment(this.getLastDirection());
    }

    Predicate<ItemVariant> getEndFilter(class_3218 level) {
        PipeBlockEntity pipe;
        AttachedAttachment attachedAttachment;
        class_2338 endPipe = this.targetPos.method_10093(this.getTargetBlockSide());
        class_2586 class_25862 = level.method_8321(endPipe);
        if (class_25862 instanceof PipeBlockEntity && (attachedAttachment = (pipe = (PipeBlockEntity)class_25862).getAttachment(this.getLastDirection())) instanceof ItemAttachedIo) {
            ItemAttachedIo io = (ItemAttachedIo)attachedAttachment;
            if (!io.isEnabledViaRedstone(pipe)) {
                return v -> false;
            }
            return io::matchesItemFilter;
        }
        return v -> true;
    }

    public ItemPath reversed() {
        if (this.reversed == null) {
            class_2350[] reversedPath = new class_2350[this.path.length];
            for (int i = 0; i < this.path.length; ++i) {
                reversedPath[this.path.length - i - 1] = this.path[i].method_10153();
            }
            this.reversed = new ItemPath(this.targetPos, this.startingPos, reversedPath, this);
        }
        return this.reversed;
    }
}

