/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.network.fluid;

import com.google.common.primitives.Ints;
import dev.technici4n.moderndynamics.attachment.IoAttachmentType;
import dev.technici4n.moderndynamics.attachment.attached.FluidAttachedIo;
import dev.technici4n.moderndynamics.network.NetworkCache;
import dev.technici4n.moderndynamics.network.NetworkNode;
import dev.technici4n.moderndynamics.network.fluid.ConnectedFluidStorage;
import dev.technici4n.moderndynamics.network.fluid.FluidHost;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.ResourceAmount;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_3218;

public class FluidCache
extends NetworkCache<FluidHost, FluidCache> {
    private FluidCacheStorage fluidStorage = null;
    private long attractorBuffer = 0L;
    private boolean allowNetworkIo = true;

    protected FluidCache(class_3218 level, List<NetworkNode<FluidHost, FluidCache>> networkNodes) {
        super(level, networkNodes);
    }

    public FluidCacheStorage getOrCreateStorage() {
        this.combine();
        return this.fluidStorage;
    }

    @Override
    protected void doCombine() {
        FluidVariant fv = FluidVariant.blank();
        long amount = 0L;
        for (NetworkNode node : this.nodes) {
            FluidHost host = (FluidHost)node.getHost();
            if (host.getVariant().isBlank()) continue;
            if (fv.isBlank()) {
                fv = host.getVariant();
            }
            amount += host.getAmount();
        }
        this.fluidStorage = new FluidCacheStorage();
        this.fluidStorage.variant = fv;
        this.fluidStorage.amount = amount;
    }

    @Override
    protected void doSeparate() {
        if (Transaction.getLifecycle() == Transaction.Lifecycle.OPEN || Transaction.getLifecycle() == Transaction.Lifecycle.CLOSING) {
            throw new IllegalStateException("Can't separate a network when a transaction is open!");
        }
        this.nodes.sort(Comparator.comparingLong(node -> 81000L));
        int remainingNodes = this.nodes.size();
        for (NetworkNode node2 : this.nodes) {
            FluidHost host = (FluidHost)node2.getHost();
            long nodeAmount = Math.min(81000L, this.fluidStorage.amount / (long)remainingNodes);
            host.setContents(this.fluidStorage.variant, nodeAmount);
            this.fluidStorage.amount -= nodeAmount;
            --remainingNodes;
        }
        this.fluidStorage = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doTick() {
        this.combine();
        ArrayList<ConnectedFluidStorage> targets = new ArrayList<ConnectedFluidStorage>();
        for (Object node : this.nodes) {
            if (!((FluidHost)((NetworkNode)node).getHost()).isTicking()) continue;
            ((FluidHost)((NetworkNode)node).getHost()).gatherCapabilities(targets);
        }
        ArrayList<FluidAttachedIo> attractors = new ArrayList<FluidAttachedIo>();
        for (ConnectedFluidStorage conn : targets) {
            if (conn.attachment() == null || conn.attachment().getType() != IoAttachmentType.ATTRACTOR) continue;
            attractors.add(conn.attachment());
        }
        boolean changedVariant = false;
        this.allowNetworkIo = false;
        try (Transaction tx = Transaction.openOuter();){
            FluidVariant newVariant;
            if (this.fluidStorage.isResourceBlank() && !(newVariant = this.findVariantForNetwork(targets, attractors, (TransactionContext)tx)).isBlank() && this.canChangeVariant()) {
                this.fluidStorage.variant = newVariant;
                changedVariant = true;
            }
            if (!this.fluidStorage.isResourceBlank()) {
                this.extractFluid(targets, (TransactionContext)tx);
                this.attractFluid(targets, attractors, (TransactionContext)tx);
                this.distributeFluid(targets, (TransactionContext)tx);
                if (this.fluidStorage.amount == 0L && this.canChangeVariant()) {
                    this.fluidStorage.variant = FluidVariant.blank();
                    changedVariant = true;
                }
            }
            tx.commit();
        }
        finally {
            this.allowNetworkIo = true;
        }
        if (changedVariant) {
            this.separate();
        }
        this.separate();
    }

    private boolean canChangeVariant() {
        for (NetworkNode node : this.nodes) {
            if (((FluidHost)node.getHost()).isTicking()) continue;
            return false;
        }
        return true;
    }

    private FluidVariant findVariantForNetwork(List<ConnectedFluidStorage> targets, List<FluidAttachedIo> attractors, TransactionContext tx) {
        for (ConnectedFluidStorage t : targets) {
            FluidVariant toExtract;
            if (t.attachment() == null || t.attachment().getType() != IoAttachmentType.EXTRACTOR || (toExtract = (FluidVariant)StorageUtil.findExtractableResource(t.storage(), fv -> t.attachment().matchesFilter((FluidVariant)fv), (TransactionContext)tx)) == null) continue;
            return toExtract;
        }
        if (!attractors.isEmpty()) {
            Predicate<FluidVariant> attractorFilter = fv -> {
                for (FluidAttachedIo a : attractors) {
                    if (!a.matchesFilter((FluidVariant)fv)) continue;
                    return true;
                }
                return false;
            };
            for (ConnectedFluidStorage t : targets) {
                FluidVariant toExtract = (FluidVariant)StorageUtil.findExtractableResource(t.storage(), attractorFilter, (TransactionContext)tx);
                if (toExtract == null) continue;
                return toExtract;
            }
        }
        return FluidVariant.blank();
    }

    private void extractFluid(List<ConnectedFluidStorage> targets, TransactionContext tx) {
        this.fluidStorage.amount += FluidCache.transferForTargets(Storage::extract, targets, this.fluidStorage.variant, this.fluidStorage.getCapacity() - this.fluidStorage.amount, tx, ConnectedFluidStorage::extractorFilteredStorage);
    }

    private void attractFluid(List<ConnectedFluidStorage> targets, List<FluidAttachedIo> attractors, TransactionContext tx) {
        long attractorPower = 0L;
        for (FluidAttachedIo attractor : attractors) {
            attractorPower += attractor.matchesFilter(this.fluidStorage.variant) ? attractor.getFluidMaxIo() : 0L;
        }
        long maxAttract = this.attractorBuffer + attractorPower;
        long attracted = FluidCache.transferForTargets(Storage::extract, targets, this.fluidStorage.variant, Math.min(this.fluidStorage.getCapacity() - this.fluidStorage.amount, maxAttract), tx, ConnectedFluidStorage::storage);
        this.attractorBuffer = Math.min(maxAttract - attracted, 81000L);
        this.fluidStorage.amount += attracted;
    }

    private void distributeFluid(List<ConnectedFluidStorage> targets, TransactionContext tx) {
        this.fluidStorage.amount -= FluidCache.transferForTargets(Storage::insert, targets, this.fluidStorage.variant, this.fluidStorage.amount, tx, ConnectedFluidStorage.filterAttractors(true));
        this.fluidStorage.amount -= FluidCache.transferForTargets(Storage::insert, targets, this.fluidStorage.variant, this.fluidStorage.amount, tx, ConnectedFluidStorage.filterAttractors(false));
    }

    private static long transferForTargets(TransferOperation operation, List<ConnectedFluidStorage> targets, FluidVariant variant, long maxAmount, TransactionContext tx, Function<ConnectedFluidStorage, Storage<FluidVariant>> storageGetter) {
        if (maxAmount == 0L) {
            return 0L;
        }
        int intMaxAmount = Ints.saturatedCast((long)maxAmount);
        ArrayList<FluidTarget> sortableTargets = new ArrayList<FluidTarget>(targets.size());
        for (ConnectedFluidStorage connectedFluidStorage : targets) {
            Storage<FluidVariant> storage = storageGetter.apply(connectedFluidStorage);
            if (storage == null) continue;
            sortableTargets.add(new FluidTarget(storage));
        }
        Collections.shuffle(sortableTargets);
        for (FluidTarget fluidTarget : sortableTargets) {
            Transaction simulation = tx.openNested();
            try {
                fluidTarget.simulationResult = operation.transfer(fluidTarget.target, variant, intMaxAmount, (TransactionContext)simulation);
            }
            finally {
                if (simulation == null) continue;
                simulation.close();
            }
        }
        sortableTargets.sort(Comparator.comparingLong(t -> t.simulationResult));
        long transferredAmount = 0L;
        for (int i = 0; i < sortableTargets.size(); ++i) {
            FluidTarget target = (FluidTarget)sortableTargets.get(i);
            int remainingTargets = sortableTargets.size() - i;
            long remainingAmount = maxAmount - transferredAmount;
            int targetMaxAmount = Ints.saturatedCast((long)(remainingAmount / (long)remainingTargets));
            transferredAmount += operation.transfer(target.target, variant, targetMaxAmount, tx);
        }
        return transferredAmount;
    }

    @Override
    public void appendDebugInfo(StringBuilder out) {
        super.appendDebugInfo(out);
        if (this.fluidStorage == null) {
            out.append("no fluid storage\n");
        } else {
            out.append("fluid variant = ").append(this.fluidStorage.variant).append("\n");
            out.append("amount = ").append(this.fluidStorage.amount).append("\n");
            out.append("capacity = ").append(this.fluidStorage.getCapacity()).append("\n");
        }
    }

    static boolean areCompatible(FluidVariant v1, FluidVariant v2) {
        return v1.isBlank() || v2.isBlank() || v1.equals(v2);
    }

    public class FluidCacheStorage
    extends SnapshotParticipant<ResourceAmount<FluidVariant>>
    implements SingleSlotStorage<FluidVariant> {
        private FluidVariant variant;
        private long amount;

        public long insert(FluidVariant insertedVariant, long maxAmount, TransactionContext transaction) {
            long insertedAmount;
            StoragePreconditions.notBlankNotNegative((TransferVariant)insertedVariant, (long)maxAmount);
            if (!FluidCache.this.allowNetworkIo) {
                return 0L;
            }
            if ((insertedVariant.equals(this.variant) || this.variant.isBlank() && FluidCache.this.canChangeVariant()) && (insertedAmount = Math.min(maxAmount, this.getCapacity() - this.amount)) > 0L) {
                this.updateSnapshots(transaction);
                if (this.variant.isBlank()) {
                    this.variant = insertedVariant;
                    this.amount = insertedAmount;
                } else {
                    this.amount += insertedAmount;
                }
                return insertedAmount;
            }
            return 0L;
        }

        public long extract(FluidVariant extractedVariant, long maxAmount, TransactionContext transaction) {
            long extractedAmount;
            StoragePreconditions.notBlankNotNegative((TransferVariant)extractedVariant, (long)maxAmount);
            if (!FluidCache.this.allowNetworkIo) {
                return 0L;
            }
            if (extractedVariant.equals(this.variant) && (extractedAmount = Math.min(maxAmount, this.amount)) > 0L) {
                this.updateSnapshots(transaction);
                this.amount -= extractedAmount;
                if (this.amount == 0L && FluidCache.this.canChangeVariant()) {
                    this.variant = FluidVariant.blank();
                }
                return extractedAmount;
            }
            return 0L;
        }

        public boolean isResourceBlank() {
            return this.variant.isBlank();
        }

        public FluidVariant getResource() {
            return this.variant;
        }

        public long getAmount() {
            return this.amount;
        }

        public long getCapacity() {
            return (long)FluidCache.this.nodes.size() * 81000L;
        }

        protected ResourceAmount<FluidVariant> createSnapshot() {
            return new ResourceAmount((Object)this.variant, this.amount);
        }

        protected void readSnapshot(ResourceAmount<FluidVariant> snapshot) {
            this.variant = (FluidVariant)snapshot.resource();
            this.amount = snapshot.amount();
        }

        protected void onFinalCommit() {
            FluidVariant oldVariant = ((FluidHost)((NetworkNode)FluidCache.this.nodes.get(0)).getHost()).getVariant();
            if (!Objects.equals(oldVariant, this.variant)) {
                FluidCache.this.separate();
            }
        }
    }

    static interface TransferOperation {
        public long transfer(Storage<FluidVariant> var1, FluidVariant var2, long var3, TransactionContext var5);
    }

    private static class FluidTarget {
        final Storage<FluidVariant> target;
        long simulationResult;

        FluidTarget(Storage<FluidVariant> target) {
            this.target = target;
        }
    }
}

