/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.client.compat.rei;

import dev.technici4n.moderndynamics.attachment.upgrade.UpgradeType;
import dev.technici4n.moderndynamics.client.compat.rei.UpgradeDisplay;
import dev.technici4n.moderndynamics.init.MdItems;
import dev.technici4n.moderndynamics.util.MdId;
import java.util.ArrayList;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_5250;

@Environment(value=EnvType.CLIENT)
public class UpgradeCategory
implements DisplayCategory<UpgradeDisplay> {
    public static final CategoryIdentifier<UpgradeDisplay> ID = CategoryIdentifier.of((class_2960)MdId.of("upgrades"));

    public Renderer getIcon() {
        return EntryStacks.of((class_1935)MdItems.EXTRACTOR);
    }

    public class_2561 getTitle() {
        return class_2561.method_43471((String)"gui.moderndynamics.rei.upgrade_category");
    }

    public CategoryIdentifier<UpgradeDisplay> getCategoryIdentifier() {
        return ID;
    }

    public List<Widget> setupDisplay(UpgradeDisplay display, Rectangle bounds) {
        ArrayList<Widget> widgets = new ArrayList<Widget>();
        UpgradeType type = display.upgradeInfo;
        class_2960 texture = MdId.of("textures/gui/icons.png");
        int baseY = bounds.y + 5 + 36;
        int countXOffset = 17;
        int countY = bounds.y + 18 + 36;
        int effectWidth = 23;
        int effectSpacing = 5;
        widgets.add((Widget)Widgets.createRecipeBase((Rectangle)bounds));
        Point upgradeSlotPoint = new Point(bounds.x + 7, bounds.y + 7);
        widgets.add((Widget)Widgets.createSlot((Point)upgradeSlotPoint).entry(EntryStacks.of((class_1935)display.item)));
        widgets.add((Widget)Widgets.createLabel((Point)new Point(bounds.x + 29, bounds.y + 11), (class_2561)class_2561.method_43469((String)"gui.moderndynamics.tooltip.upgrades_max", (Object[])new Object[]{type.getSlotLimit()})).leftAligned().noShadow().color(-12566464, -4473925));
        widgets.add((Widget)Widgets.createLabel((Point)new Point(bounds.getCenterX(), bounds.y + 5 + 22), (class_2561)class_2561.method_43471((String)"gui.moderndynamics.tooltip.upgrades_effects").method_10862(class_2583.field_24360.method_30938(Boolean.valueOf(true)))).noShadow().color(-12566464, -4473925));
        ArrayList<UpgradeEffect> effects = new ArrayList<UpgradeEffect>();
        effects.add(new UpgradeEffect(0, type.isEnableAdvancedBehavior() ? -1 : 0, "enableAdvancedBehavior", class_1074.method_4662((String)"gui.moderndynamics.tooltip.advanced_behavior_available", (Object[])new Object[0])));
        effects.add(new UpgradeEffect(16, type.getAddFilterSlots(), "addFilterSlots", "+" + type.getAddFilterSlots()));
        effects.add(new UpgradeEffect(32, type.getAddItemCount(), "addItemCount", "+" + type.getAddItemCount()));
        effects.add(new UpgradeEffect(48, type.getAddItemSpeed(), "addItemSpeed", "+" + type.getAddItemSpeed() * 100 + "%"));
        effects.add(new UpgradeEffect(64, type.getAddItemTransferFrequency(), "addItemTransferFrequency", "+" + type.getAddItemTransferFrequency() * 100 + "%"));
        effects.add(new UpgradeEffect(80, type.getAddFluidTransfer(), "addFluidTransfer", "+" + type.getAddFluidTransfer() * 100 + "%"));
        effects.add(new UpgradeEffect(96, type.getMultiplyFluidTransfer(), "multiplyFluidTransfer", "+" + type.getMultiplyFluidTransfer() * 100 + "%"));
        effects.removeIf(e -> e.count() == 0);
        if (effects.size() > 0) {
            int totalWidth = effects.size() * effectWidth + (effects.size() - 1) * effectSpacing;
            int baseX = bounds.x + (bounds.getWidth() - totalWidth) / 2;
            for (UpgradeEffect e2 : effects) {
                Rectangle tooltipRect = new Rectangle(baseX, baseY, 20, 20);
                class_2583 greenStyle = class_2583.field_24360.method_27706(class_124.field_1060);
                class_5250 tooltip = class_2561.method_43469((String)("gui.moderndynamics.tooltip.upgrade_" + e2.upgradeName()), (Object[])new Object[]{class_2561.method_43470((String)e2.greenText).method_10862(greenStyle)});
                widgets.add(Widgets.createTexturedWidget((class_2960)texture, (int)baseX, (int)baseY, (float)e2.textureU(), (float)0.0f, (int)16, (int)16));
                String renderedString = e2.count() > 0 ? "" + e2.count() : "";
                widgets.add((Widget)Widgets.createLabel((Point)new Point(baseX + countXOffset, countY), (class_2561)class_2561.method_43470((String)renderedString)).noShadow().color(-12566464, -4473925));
                widgets.add(Widgets.createDrawableWidget((guiGraphics, mouseX, mouseY, delta) -> {
                    if (tooltipRect.contains(mouseX, mouseY)) {
                        Tooltip.create((class_2561[])new class_2561[]{tooltip}).queue();
                    }
                }));
                baseX += effectWidth + effectSpacing;
            }
        }
        return widgets;
    }

    public int getDisplayHeight() {
        return 67;
    }

    @Environment(value=EnvType.CLIENT)
    private record UpgradeEffect(int textureU, int count, String upgradeName, String greenText) {
    }
}

