/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.attachment.attached;

import com.google.common.base.Preconditions;
import dev.technici4n.moderndynamics.attachment.IoAttachmentItem;
import dev.technici4n.moderndynamics.attachment.attached.AttachedIo;
import dev.technici4n.moderndynamics.attachment.attached.ItemCachedFilter;
import dev.technici4n.moderndynamics.attachment.settings.FilterDamageMode;
import dev.technici4n.moderndynamics.attachment.settings.FilterModMode;
import dev.technici4n.moderndynamics.attachment.settings.FilterNbtMode;
import dev.technici4n.moderndynamics.attachment.settings.FilterSimilarMode;
import dev.technici4n.moderndynamics.attachment.settings.OversendingMode;
import dev.technici4n.moderndynamics.attachment.settings.RoutingMode;
import dev.technici4n.moderndynamics.init.MdMenus;
import dev.technici4n.moderndynamics.model.AttachmentModelData;
import dev.technici4n.moderndynamics.pipe.PipeBlockEntity;
import dev.technici4n.moderndynamics.util.DropHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3532;
import net.minecraft.class_3908;
import org.jetbrains.annotations.Nullable;

public class ItemAttachedIo
extends AttachedIo {
    private final Map<ItemVariant, Long> stuffedItems = new LinkedHashMap<ItemVariant, Long>();
    private int roundRobinIndex;
    private final class_2371<ItemVariant> filters = class_2371.method_10213((int)15, (Object)ItemVariant.blank());
    private FilterDamageMode filterDamage;
    private FilterNbtMode filterNbt;
    private FilterModMode filterMod;
    private FilterSimilarMode filterSimilar;
    private RoutingMode routingMode;
    private OversendingMode oversendingMode;
    private int maxItemsInInventory;
    private int maxItemsExtracted;
    boolean maxItemsExtractedAtMax;
    @Nullable
    private ItemCachedFilter cachedFilter;

    public ItemAttachedIo(IoAttachmentItem item, class_2487 configData, Runnable setChangedCallback) {
        super(item, configData, setChangedCallback);
        class_2499 filterTags = configData.method_10554("filters", 10);
        for (int i = 0; i < this.filters.size(); ++i) {
            class_2487 filterTag = filterTags.method_10602(i);
            if (filterTag.method_33133()) continue;
            this.filters.set(i, (Object)ItemVariant.fromNbt((class_2487)filterTag));
        }
        this.filterDamage = (FilterDamageMode)ItemAttachedIo.readEnum((Enum[])FilterDamageMode.values(), (class_2487)configData, (String)"filterDamage", (Enum)FilterDamageMode.RESPECT_DAMAGE);
        this.filterNbt = (FilterNbtMode)ItemAttachedIo.readEnum((Enum[])FilterNbtMode.values(), (class_2487)configData, (String)"filterNbt", (Enum)FilterNbtMode.RESPECT_NBT);
        this.filterMod = (FilterModMode)ItemAttachedIo.readEnum((Enum[])FilterModMode.values(), (class_2487)configData, (String)"filterMod", (Enum)FilterModMode.IGNORE_MOD);
        this.filterSimilar = (FilterSimilarMode)ItemAttachedIo.readEnum((Enum[])FilterSimilarMode.values(), (class_2487)configData, (String)"filterSimilar", (Enum)FilterSimilarMode.IGNORE_SIMILAR);
        this.routingMode = (RoutingMode)ItemAttachedIo.readEnum((Enum[])RoutingMode.values(), (class_2487)configData, (String)"routingMode", (Enum)RoutingMode.CLOSEST);
        this.oversendingMode = (OversendingMode)ItemAttachedIo.readEnum((Enum[])OversendingMode.values(), (class_2487)configData, (String)"oversendingMode", (Enum)OversendingMode.PREVENT_OVERSENDING);
        if (configData.method_10573("maxItemsExtracted", 3)) {
            this.setMaxItemsExtracted(configData.method_10550("maxItemsExtracted"));
        } else {
            this.setMaxItemsExtracted(this.getMaxItemsExtractedMaximum());
        }
        this.maxItemsInInventory = configData.method_10550("maxItemsInInventory");
        this.maxItemsInInventory = class_3532.method_15340((int)this.maxItemsInInventory, (int)0, (int)this.getMaxItemsExtractedMaximum());
        this.stuffedItems.clear();
        class_2499 stuffedTag = configData.method_10554("stuffed", 10);
        for (int i = 0; i < stuffedTag.size(); ++i) {
            class_2487 compound = stuffedTag.method_10602(i);
            ItemVariant variant = ItemVariant.fromNbt((class_2487)compound);
            long amount = compound.method_10537("#a");
            if (variant.isBlank() || amount <= 0L) continue;
            this.stuffedItems.put(variant, amount);
        }
        this.roundRobinIndex = Math.max(0, configData.method_10550("roundRobinIndex"));
    }

    @Override
    public class_2487 writeConfigTag(class_2487 configData) {
        super.writeConfigTag(configData);
        class_2499 filterTags = new class_2499();
        for (ItemVariant filter : this.filters) {
            if (filter.isBlank()) {
                filterTags.add((Object)new class_2487());
                continue;
            }
            filterTags.add((Object)filter.toNbt());
        }
        configData.method_10566("filters", (class_2520)filterTags);
        ItemAttachedIo.writeEnum(this.filterDamage, configData, "filterDamage");
        ItemAttachedIo.writeEnum(this.filterNbt, configData, "filterNbt");
        ItemAttachedIo.writeEnum(this.filterMod, configData, "filterMod");
        ItemAttachedIo.writeEnum(this.filterSimilar, configData, "filterSimilar");
        ItemAttachedIo.writeEnum(this.routingMode, configData, "routingMode");
        ItemAttachedIo.writeEnum(this.oversendingMode, configData, "oversendingMode");
        if (this.maxItemsExtracted < this.getMaxItemsExtractedMaximum()) {
            configData.method_10569("maxItemsExtracted", this.maxItemsExtracted);
        } else {
            configData.method_10551("maxItemsExtracted");
        }
        if (this.maxItemsInInventory > 0) {
            configData.method_10569("maxItemsInInventory", this.maxItemsInInventory);
        } else {
            configData.method_10551("maxItemsInInventory");
        }
        class_2499 stuffedTag = new class_2499();
        for (Map.Entry<ItemVariant, Long> entry : this.stuffedItems.entrySet()) {
            class_2487 compound = entry.getKey().toNbt();
            compound.method_10544("#a", entry.getValue().longValue());
            stuffedTag.add((Object)compound);
        }
        if (!stuffedTag.isEmpty()) {
            configData.method_10566("stuffed", (class_2520)stuffedTag);
        }
        if (this.roundRobinIndex != 0) {
            configData.method_10569("roundRobinIndex", this.roundRobinIndex);
        }
        return configData;
    }

    @Override
    public void onUpgradesChanged() {
        super.onUpgradesChanged();
        if (this.maxItemsExtractedAtMax) {
            this.setMaxItemsExtracted(this.getMaxItemsExtractedMaximum());
        }
        this.setMaxItemsExtracted(this.getMaxItemsExtracted());
    }

    public boolean matchesItemFilter(ItemVariant variant) {
        return this.getCachedFilter().matchesItem(variant);
    }

    public ItemVariant getFilter(int idx) {
        return (ItemVariant)this.filters.get(idx);
    }

    public void setFilter(int idx, ItemVariant variant) {
        if (!variant.equals(this.filters.get(idx))) {
            this.filters.set(idx, (Object)variant);
            this.setChangedCallback.run();
            this.resetCachedFilter();
        }
    }

    public double getItemSpeedupFactor() {
        return this.upgradeContainer.getItemSpeedupFactor();
    }

    public int getItemOperationTickDelay() {
        return this.upgradeContainer.getItemOperationTickDelay();
    }

    @Override
    public boolean hasMenu() {
        return true;
    }

    @Override
    @Nullable
    public class_3908 createMenu(PipeBlockEntity pipe, class_2350 side) {
        return MdMenus.ITEM_IO.createMenu(pipe, side, this);
    }

    @Override
    public AttachmentModelData getModelData() {
        if (this.isStuffed()) {
            return AttachmentModelData.from(this.getItem().attachment.getStuffed(), this.getItem());
        }
        return super.getModelData();
    }

    @Override
    public List<class_1799> getDrops() {
        ArrayList<class_1799> drops = new ArrayList<class_1799>(super.getDrops());
        for (Map.Entry<ItemVariant, Long> entry : this.stuffedItems.entrySet()) {
            DropHelper.splitIntoStacks(entry.getKey(), entry.getValue(), drops::add);
        }
        return drops;
    }

    public boolean isStuffed() {
        return this.stuffedItems.size() > 0;
    }

    public Map<ItemVariant, Long> getStuffedItems() {
        return this.stuffedItems;
    }

    public FilterDamageMode getFilterDamage() {
        return this.filterDamage;
    }

    public void setFilterDamage(FilterDamageMode filterDamage) {
        if (filterDamage != this.filterDamage) {
            this.filterDamage = filterDamage;
            this.resetCachedFilter();
        }
    }

    public FilterNbtMode getFilterNbt() {
        return this.isAdvancedBehaviorAllowed() ? this.filterNbt : FilterNbtMode.RESPECT_NBT;
    }

    public void setFilterNbt(FilterNbtMode filterNbt) {
        if (filterNbt != this.filterNbt) {
            this.filterNbt = filterNbt;
            this.resetCachedFilter();
        }
    }

    public FilterModMode getFilterMod() {
        return this.filterMod;
    }

    public void setFilterMod(FilterModMode filterMod) {
        if (filterMod != this.filterMod) {
            this.filterMod = filterMod;
            this.resetCachedFilter();
        }
    }

    public FilterSimilarMode getFilterSimilar() {
        return this.filterSimilar;
    }

    public void setFilterSimilar(FilterSimilarMode value) {
        if (value != this.filterSimilar) {
            this.filterSimilar = value;
            this.resetCachedFilter();
        }
    }

    public RoutingMode getRoutingMode() {
        return this.isAdvancedBehaviorAllowed() ? this.routingMode : RoutingMode.CLOSEST;
    }

    public void setRoutingMode(RoutingMode mode) {
        this.routingMode = mode;
    }

    public OversendingMode getOversendingMode() {
        return this.isAdvancedBehaviorAllowed() ? this.oversendingMode : OversendingMode.PREVENT_OVERSENDING;
    }

    public void setOversendingMode(OversendingMode mode) {
        this.oversendingMode = mode;
    }

    public int getMaxItemsInInventory() {
        return this.maxItemsInInventory;
    }

    public void setMaxItemsInInventory(int value) {
        this.maxItemsInInventory = class_3532.method_15340((int)value, (int)0, (int)Integer.MAX_VALUE);
    }

    public int getMaxItemsExtracted() {
        return this.maxItemsExtracted;
    }

    public void setMaxItemsExtracted(int value) {
        this.maxItemsExtracted = class_3532.method_15340((int)value, (int)1, (int)this.getMaxItemsExtractedMaximum());
        this.maxItemsExtractedAtMax = this.maxItemsExtracted == this.getMaxItemsExtractedMaximum();
    }

    public int getMaxItemsExtractedMaximum() {
        return this.upgradeContainer.getItemsPerOperation();
    }

    private ItemCachedFilter getCachedFilter() {
        if (this.cachedFilter == null) {
            this.cachedFilter = new ItemCachedFilter(this.filters.subList(0, this.getFilterSize()), this.getFilterInversion(), this.filterDamage, this.getFilterNbt(), this.filterMod);
        }
        return this.cachedFilter;
    }

    @Override
    protected void resetCachedFilter() {
        this.cachedFilter = null;
    }

    public int getRoundRobinIndex(int maxValue) {
        Preconditions.checkArgument((maxValue > 0 ? 1 : 0) != 0, (Object)"maxValue > 0");
        this.roundRobinIndex %= maxValue;
        return this.roundRobinIndex;
    }

    public void incrementRoundRobin(int incrementSize) {
        if (this.getRoutingMode() == RoutingMode.ROUND_ROBIN) {
            this.roundRobinIndex += incrementSize;
            this.setChangedCallback.run();
        }
    }

    public long moveStuffedToStorage(Storage<ItemVariant> targetStorage, long maxAmount) {
        long totalMoved = 0L;
        try (Transaction tx = Transaction.openOuter();){
            Iterator<Map.Entry<ItemVariant, Long>> it = this.stuffedItems.entrySet().iterator();
            while (it.hasNext() && totalMoved < maxAmount) {
                Map.Entry<ItemVariant, Long> entry = it.next();
                long stuffedAmount = entry.getValue();
                long inserted = targetStorage.insert((Object)entry.getKey(), Math.min(stuffedAmount, maxAmount - totalMoved), (TransactionContext)tx);
                if (inserted <= 0L) continue;
                totalMoved += inserted;
                if (inserted < stuffedAmount) {
                    entry.setValue(stuffedAmount - inserted);
                    continue;
                }
                it.remove();
            }
            tx.commit();
        }
        return totalMoved;
    }
}

