/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.datagen;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLanguageProvider;
import net.minecraft.class_1291;
import net.minecraft.class_1299;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2405;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7403;
import net.minecraft.class_7417;
import net.minecraft.class_7784;
import net.minecraft.class_7924;
import snownee.kiwi.KiwiModule;
import snownee.kiwi.config.ConfigHandler;
import snownee.kiwi.config.ConfigUI;
import snownee.kiwi.config.KiwiConfigManager;
import snownee.kiwi.datagen.GameObjectLookup;
import snownee.kiwi.util.Util;

public class KiwiLanguageProvider
extends FabricLanguageProvider {
    protected final FabricDataOutput dataOutput;
    protected final String languageCode;

    public KiwiLanguageProvider(FabricDataOutput dataOutput) {
        this(dataOutput, "en_us");
    }

    public KiwiLanguageProvider(FabricDataOutput dataOutput, String languageCode) {
        super(dataOutput, languageCode);
        this.dataOutput = dataOutput;
        this.languageCode = languageCode;
    }

    public void generateTranslations(FabricLanguageProvider.TranslationBuilder translationBuilder) {
    }

    public Optional<Path> createPath(String path, String extension) {
        return this.dataOutput.getModContainer().findPath("assets/%s/lang/%s.%s".formatted(this.dataOutput.getModId(), path, extension));
    }

    public void putExistingTranslations(FabricLanguageProvider.TranslationBuilder translationBuilder) {
        this.putExistingTranslations(translationBuilder, this.languageCode + ".existing");
    }

    public void putExistingTranslations(FabricLanguageProvider.TranslationBuilder translationBuilder, String path) {
        try {
            Path existingFilePath = this.createPath(path, "json").orElseThrow();
            translationBuilder.add(existingFilePath);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to add existing language file!", e);
        }
    }

    public void putExistingYamlTranslations(FabricLanguageProvider.TranslationBuilder translationBuilder) {
        this.putExistingYamlTranslations(translationBuilder, this.languageCode + ".existing");
    }

    public void putExistingYamlTranslations(FabricLanguageProvider.TranslationBuilder translationBuilder, String path) {
        try {
            Path existingFilePath = this.createPath(path, "yaml").orElseThrow();
            try (BufferedReader reader = Files.newBufferedReader(existingFilePath);){
                Map map = Util.loadYaml(reader, Map.class);
                for (Map.Entry entry : map.entrySet()) {
                    translationBuilder.add((String)entry.getKey(), entry.getValue().toString());
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to add existing language file!", e);
        }
    }

    public CompletableFuture<?> method_10319(class_7403 writer) {
        TreeMap<String, String> translationEntries = new TreeMap<String, String>();
        this.preGenerate(translationEntries);
        if ("en_us".equals(this.languageCode)) {
            this.generateGameObjectsEntries(translationEntries);
            this.generateConfigEntries(translationEntries);
            this.generateTranslations((key, value) -> {
                Objects.requireNonNull(key);
                Objects.requireNonNull(value);
                if (translationEntries.containsKey(key)) {
                    throw new RuntimeException("Existing translation key found - " + key + " - Duplicate will be ignored.");
                }
                translationEntries.put(key, value);
            });
            FabricLanguageProvider.TranslationBuilder translationBuilder = (key, value) -> {
                Objects.requireNonNull(key);
                Objects.requireNonNull(value);
                translationEntries.put(key, value);
            };
            if (this.createPath("en_us.existing", "yaml").map(x$0 -> Files.exists(x$0, new LinkOption[0])).orElse(false).booleanValue()) {
                this.putExistingYamlTranslations(translationBuilder);
            } else if (this.createPath("en_us.existing", "json").map(x$0 -> Files.exists(x$0, new LinkOption[0])).orElse(false).booleanValue()) {
                this.putExistingTranslations(translationBuilder);
            }
        }
        this.postGenerate(translationEntries);
        JsonObject langEntryJson = new JsonObject();
        for (Map.Entry<String, String> entry : translationEntries.entrySet()) {
            langEntryJson.addProperty(entry.getKey(), entry.getValue());
        }
        return class_2405.method_10320((class_7403)writer, (JsonElement)langEntryJson, (Path)this.getLangFilePath(this.languageCode));
    }

    protected void postGenerate(TreeMap<String, String> translationEntries) {
    }

    protected void preGenerate(TreeMap<String, String> translationEntries) {
    }

    protected void generateConfigEntries(Map<String, String> translationEntries) {
        Joiner joiner = Joiner.on((char)'.');
        for (ConfigHandler handler : KiwiConfigManager.allConfigs) {
            if (!Objects.equals(handler.getModId(), this.dataOutput.getModId()) || handler.getFileName().equals("test") || handler.getFileName().equals("kiwi-modules") || handler.getClazz().getDeclaredAnnotation(KiwiModule.Skip.class) != null) continue;
            String key = handler.getTranslationKey();
            if (Objects.equals(key, handler.getFileName())) {
                translationEntries.put("kiwi.config." + key, Util.friendlyText(key));
            }
            HashSet subCats = Sets.newHashSet();
            for (ConfigHandler.Value<?> value : handler.getValueMap().values()) {
                ConfigUI.Hide hide = value.getAnnotation(ConfigUI.Hide.class);
                if (hide != null) continue;
                ArrayList path = Lists.newArrayList((Object[])value.path.split("\\."));
                String title = Util.friendlyText((String)path.remove(path.size() - 1));
                String subCatKey = joiner.join((Iterable)path);
                if (!path.isEmpty() && !subCats.contains(subCatKey)) {
                    subCats.add(subCatKey);
                    translationEntries.put(handler.getModId() + ".config." + subCatKey, Util.friendlyText((String)path.get(path.size() - 1)));
                }
                translationEntries.put(value.translation, title);
                translationEntries.put(value.translation + ".desc", "");
            }
        }
    }

    private Path getLangFilePath(String code) {
        return this.dataOutput.method_45973(class_7784.class_7490.field_39368, "lang").method_44107(new class_2960(this.dataOutput.getModId(), code));
    }

    protected void generateGameObjectsEntries(Map<String, String> translationEntries) {
        this.generateGameObjectEntries(translationEntries, class_7924.field_41254, class_2248::method_9539);
        this.generateGameObjectEntries(translationEntries, class_7924.field_41197, class_1792::method_7876);
        this.generateGameObjectEntries(translationEntries, class_7924.field_41266, class_1299::method_5882);
        this.generateGameObjectEntries(translationEntries, class_7924.field_44688, tab -> {
            class_2561 component = tab.method_7737();
            class_7417 patt7549$temp = component.method_10851();
            if (patt7549$temp instanceof class_2588) {
                class_2588 contents = (class_2588)patt7549$temp;
                return contents.method_11022();
            }
            return null;
        });
        this.generateGameObjectEntries(translationEntries, class_7924.field_41263, stat -> class_156.method_646((String)"stat", (class_2960)stat));
        this.generateGameObjectEntries(translationEntries, class_7924.field_41208, class_1291::method_5567);
    }

    protected <T> void generateGameObjectEntries(Map<String, String> translationEntries, class_5321<class_2378<T>> registryKey, Function<T, String> keyMapper) {
        GameObjectLookup.allHolders(registryKey, this.dataOutput.getModId()).forEach(holder -> {
            String key = (String)keyMapper.apply(holder.comp_349());
            if (key != null) {
                translationEntries.put(key, Util.friendlyText(holder.method_40237().method_29177().method_12832()));
            }
        });
    }
}

