/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.block;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import net.minecraft.class_1750;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.customization.block.KBlockSettings;

public interface KBlockUtils {
    public static final Interner<class_2769<?>> PROPERTY_INTERNER = Interners.newStrongInterner();
    public static final BiMap<String, class_2769<?>> COMMON_PROPERTIES = KBlockUtils.generateCommonProperties();

    public static BiMap<String, class_2769<?>> generateCommonProperties() {
        ImmutableBiMap.Builder map = ImmutableBiMap.builder();
        map.put((Object)"attached", (Object)class_2741.field_12493);
        map.put((Object)"bottom", (Object)class_2741.field_16562);
        map.put((Object)"conditional", (Object)class_2741.field_12486);
        map.put((Object)"disarmed", (Object)class_2741.field_12553);
        map.put((Object)"drag", (Object)class_2741.field_12526);
        map.put((Object)"enabled", (Object)class_2741.field_12515);
        map.put((Object)"extended", (Object)class_2741.field_12552);
        map.put((Object)"eye", (Object)class_2741.field_12488);
        map.put((Object)"falling", (Object)class_2741.field_12480);
        map.put((Object)"hanging", (Object)class_2741.field_16561);
        map.put((Object)"has_record", (Object)class_2741.field_12544);
        map.put((Object)"has_book", (Object)class_2741.field_17393);
        map.put((Object)"inverted", (Object)class_2741.field_12501);
        map.put((Object)"in_wall", (Object)class_2741.field_12491);
        map.put((Object)"lit", (Object)class_2741.field_12548);
        map.put((Object)"locked", (Object)class_2741.field_12502);
        map.put((Object)"occupied", (Object)class_2741.field_12528);
        map.put((Object)"open", (Object)class_2741.field_12537);
        map.put((Object)"persistent", (Object)class_2741.field_12514);
        map.put((Object)"powered", (Object)class_2741.field_12484);
        map.put((Object)"short", (Object)class_2741.field_12535);
        map.put((Object)"signal_fire", (Object)class_2741.field_17394);
        map.put((Object)"snowy", (Object)class_2741.field_12512);
        map.put((Object)"triggered", (Object)class_2741.field_12522);
        map.put((Object)"unstable", (Object)class_2741.field_12539);
        map.put((Object)"waterlogged", (Object)class_2741.field_12508);
        map.put((Object)"berries", (Object)class_2741.field_28716);
        map.put((Object)"bloom", (Object)class_2741.field_37651);
        map.put((Object)"shrieking", (Object)class_2741.field_37652);
        map.put((Object)"can_summon", (Object)class_2741.field_38423);
        map.put((Object)"horizontal_axis", (Object)class_2741.field_12529);
        map.put((Object)"axis", (Object)class_2741.field_12496);
        map.put((Object)"up", (Object)class_2741.field_12519);
        map.put((Object)"down", (Object)class_2741.field_12546);
        map.put((Object)"north", (Object)class_2741.field_12489);
        map.put((Object)"east", (Object)class_2741.field_12487);
        map.put((Object)"south", (Object)class_2741.field_12540);
        map.put((Object)"west", (Object)class_2741.field_12527);
        map.put((Object)"facing", (Object)class_2741.field_12525);
        map.put((Object)"facing_hopper", (Object)class_2741.field_12545);
        map.put((Object)"horizontal_facing", (Object)class_2741.field_12481);
        map.put((Object)"flower_amount", (Object)class_2741.field_42835);
        map.put((Object)"orientation", (Object)class_2741.field_23333);
        map.put((Object)"attach_face", (Object)class_2741.field_12555);
        map.put((Object)"bell_attachment", (Object)class_2741.field_17104);
        map.put((Object)"east_wall", (Object)class_2741.field_22174);
        map.put((Object)"north_wall", (Object)class_2741.field_22175);
        map.put((Object)"south_wall", (Object)class_2741.field_22176);
        map.put((Object)"west_wall", (Object)class_2741.field_22177);
        map.put((Object)"east_redstone", (Object)class_2741.field_12523);
        map.put((Object)"north_redstone", (Object)class_2741.field_12495);
        map.put((Object)"south_redstone", (Object)class_2741.field_12551);
        map.put((Object)"west_redstone", (Object)class_2741.field_12504);
        map.put((Object)"double_block_half", (Object)class_2741.field_12533);
        map.put((Object)"half", (Object)class_2741.field_12518);
        map.put((Object)"rail_shape", (Object)class_2741.field_12507);
        map.put((Object)"rail_shape_straight", (Object)class_2741.field_12542);
        map.put((Object)"age_1", (Object)class_2741.field_12521);
        map.put((Object)"age_2", (Object)class_2741.field_12556);
        map.put((Object)"age_3", (Object)class_2741.field_12497);
        map.put((Object)"age_4", (Object)class_2741.field_37654);
        map.put((Object)"age_5", (Object)class_2741.field_12482);
        map.put((Object)"age_7", (Object)class_2741.field_12550);
        map.put((Object)"age_15", (Object)class_2741.field_12498);
        map.put((Object)"age_25", (Object)class_2741.field_12517);
        map.put((Object)"bites", (Object)class_2741.field_12505);
        map.put((Object)"candles", (Object)class_2741.field_27220);
        map.put((Object)"delay", (Object)class_2741.field_12494);
        map.put((Object)"distance", (Object)class_2741.field_12541);
        map.put((Object)"eggs", (Object)class_2741.field_12509);
        map.put((Object)"hatch", (Object)class_2741.field_12530);
        map.put((Object)"layers", (Object)class_2741.field_12536);
        map.put((Object)"level_cauldron", (Object)class_2741.field_12513);
        map.put((Object)"level_composter", (Object)class_2741.field_17586);
        map.put((Object)"level_flowing", (Object)class_2741.field_12490);
        map.put((Object)"level_honey", (Object)class_2741.field_20432);
        map.put((Object)"level", (Object)class_2741.field_12538);
        map.put((Object)"moisture", (Object)class_2741.field_12510);
        map.put((Object)"note", (Object)class_2741.field_12524);
        map.put((Object)"pickles", (Object)class_2741.field_12543);
        map.put((Object)"power", (Object)class_2741.field_12511);
        map.put((Object)"stage", (Object)class_2741.field_12549);
        map.put((Object)"stability_distance", (Object)class_2741.field_16503);
        map.put((Object)"rotation_16", (Object)class_2741.field_12532);
        map.put((Object)"bed_part", (Object)class_2741.field_12483);
        map.put((Object)"chest_type", (Object)class_2741.field_12506);
        map.put((Object)"mode_comparator", (Object)class_2741.field_12534);
        map.put((Object)"door_hinge", (Object)class_2741.field_12520);
        map.put((Object)"piston_type", (Object)class_2741.field_12492);
        map.put((Object)"slab_type", (Object)class_2741.field_12485);
        map.put((Object)"stairs_shape", (Object)class_2741.field_12503);
        map.put((Object)"bamboo_leaves", (Object)class_2741.field_12516);
        map.put((Object)"tilt", (Object)class_2741.field_28717);
        map.put((Object)"vertical_direction", (Object)class_2741.field_28062);
        map.put((Object)"dripstone_thickness", (Object)class_2741.field_28063);
        map.put((Object)"sculk_sensor_phase", (Object)class_2741.field_28120);
        map.put((Object)"dusted", (Object)class_2741.field_42836);
        map.put((Object)"cracked", (Object)class_2741.field_43307);
        return map.build();
    }

    public static <T extends class_2769<?>> T internProperty(T property) {
        return (T)((class_2769)PROPERTY_INTERNER.intern(property));
    }

    public static class_2769<?> getProperty(class_2680 blockState, String key) {
        class_2769 property = blockState.method_26204().method_9595().method_11663(key);
        if (property == null) {
            throw new IllegalStateException("Property %s not found".formatted(key));
        }
        return property;
    }

    public static <T extends Comparable<T>> String getValueString(class_2680 blockState, String key) {
        class_2769 property = blockState.method_26204().method_9595().method_11663(key);
        if (property == null) {
            throw new IllegalStateException("Property %s not found".formatted(key));
        }
        return property.method_11901(blockState.method_11654(property));
    }

    public static <T extends Comparable<T>> class_2680 setValueByString(class_2680 blockState, String key, String value) {
        class_2769 property = blockState.method_26204().method_9595().method_11663(key);
        if (property == null) {
            throw new IllegalStateException("Property %s not found".formatted(key));
        }
        return (class_2680)blockState.method_11657(property, (Comparable)property.method_11900(value).orElseThrow());
    }

    public static <T extends Comparable<T>> String getNameByValue(class_2769<T> property, Object value) {
        return property.method_11901((Comparable)value);
    }

    @Nullable
    default public class_2680 componentsUpdateShape(class_2680 pState, class_2350 pDirection, class_2680 pNeighborState, class_1936 pLevel, class_2338 pPos, class_2338 pNeighborPos) {
        KBlockSettings settings = KBlockSettings.of(this);
        if (settings == null) {
            return pState;
        }
        return settings.updateShape(pState, pDirection, pNeighborState, pLevel, pPos, pNeighborPos);
    }

    @Nullable
    default public class_2680 componentsGetStateForPlacement(class_2680 pState, class_1750 pContext) {
        KBlockSettings settings = KBlockSettings.of(this);
        if (settings == null) {
            return pState;
        }
        return settings.getStateForPlacement(pState, pContext);
    }
}

