/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_7157;
import snownee.kiwi.Kiwi;
import snownee.kiwi.config.KiwiConfigManager;
import snownee.kiwi.loader.Platform;
import snownee.kiwi.shadowed.com.ezylang.evalex.Expression;
import snownee.kiwi.shadowed.com.ezylang.evalex.data.EvaluationValue;
import snownee.kiwi.util.KEval;

public class KiwiCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment) {
        LiteralArgumentBuilder builder = class_2170.method_9247((String)"kiwi");
        builder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"debugLevelRules").requires(ctx -> ctx.method_9259(2))).executes(ctx -> KiwiCommand.cleanLevel((class_2168)ctx.getSource())));
        builder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reload").requires(ctx -> ctx.method_9259(2))).then(class_2170.method_9244((String)"configFile", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            String fileName = StringArgumentType.getString((CommandContext)ctx, (String)"configFile");
            if (KiwiConfigManager.refresh(fileName)) {
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)"commands.kiwi.reload.success", (Object[])new Object[]{fileName}), true);
                return 1;
            }
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43469((String)"commands.kiwi.reload.failed", (Object[])new Object[]{fileName}));
            return 0;
        })));
        builder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"eval").requires(ctx -> ctx.method_9259(2))).then(class_2170.method_9244((String)"expression", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> KiwiCommand.eval((class_2168)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"expression")))));
        dispatcher.register(builder);
    }

    private static int cleanLevel(class_2168 commandSourceStack) {
        class_2170 commands = commandSourceStack.method_9211().method_3734();
        List<String> rules = List.of("gamerule doDaylightCycle false", "gamerule doWeatherCycle false", "gamerule doMobLoot false", "gamerule doMobSpawning false", "gamerule keepInventory true", "gamerule doTraderSpawning false", "gamerule doInsomnia false", "difficulty peaceful", "kill @e[type=!minecraft:player]", "time set day", "weather clear", "gamerule doMobLoot true");
        for (String rule : rules) {
            commands.method_44252(commandSourceStack, rule);
        }
        return 1;
    }

    private static int eval(class_2168 source, String expString) {
        try {
            EvaluationValue value = new Expression(expString, KEval.config()).evaluate();
            String s = value.isNumberValue() ? value.getNumberValue().toPlainString() : Objects.toString(value.getValue());
            source.method_9226(() -> class_2561.method_43470((String)s), false);
            return value.isNullValue() ? 0 : value.getNumberValue().intValue();
        }
        catch (Throwable e) {
            if (!Platform.isProduction()) {
                Kiwi.LOGGER.error(expString, e);
            }
            source.method_9213((class_2561)class_2561.method_43470((String)e.getLocalizedMessage()));
            return 0;
        }
    }
}

