/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.iceberg.util;

import net.minecraft.class_5251;

public final class Easing {
    public static float Ease(float a, float b, float t) {
        return Easing.Ease(a, b, t, EasingType.Quad);
    }

    public static float Ease(float a, float b, float t, EasingType type) {
        return Easing.Ease(a, b, t, type, EasingDirection.InOut);
    }

    public static class_5251 Ease(class_5251 a, class_5251 b, float t, EasingType type) {
        int aV = a.method_27716();
        int bV = b.method_27716();
        int aA = aV >> 24 & 0xFF;
        int aR = aV >> 16 & 0xFF;
        int aG = aV >> 8 & 0xFF;
        int aB = aV >> 0 & 0xFF;
        int bA = bV >> 24 & 0xFF;
        int bR = bV >> 16 & 0xFF;
        int bG = bV >> 8 & 0xFF;
        int bB = bV >> 0 & 0xFF;
        return class_5251.method_27717((int)((int)Easing.Ease(aA, bA, t, type) << 24 | (int)Easing.Ease(aR, bR, t, type) << 16 | (int)Easing.Ease(aG, bG, t, type) << 8 | (int)Easing.Ease(aB, bB, t, type) << 0));
    }

    public static float Ease(float a, float b, float t, EasingType type, EasingDirection direction) {
        switch (type) {
            default: {
                return Easing.None(a, b, t);
            }
            case Linear: {
                return Easing.Linear(a, b, t);
            }
            case Quad: {
                return Easing.Quad(a, b, t, direction);
            }
            case Cubic: 
        }
        return Easing.Cubic(a, b, t, direction);
    }

    private static float None(float a, float b, float t) {
        if (t < 0.5f) {
            return a;
        }
        return b;
    }

    private static float Linear(float a, float b, float t) {
        return a + (b - a) * t;
    }

    private static float Quad(float a, float b, float t, EasingDirection direction) {
        switch (direction) {
            case In: {
                return a + (b - a) * t * t;
            }
            case Out: {
                return a + (b - a) * (1.0f - (1.0f - t) * (1.0f - t));
            }
        }
        t *= 2.0f;
        if (t < 1.0f) {
            return a + (b - a) * 0.5f * t * t;
        }
        return a + (a - b) * 0.5f * ((t -= 2.0f) * t - 2.0f);
    }

    private static float Cubic(float a, float b, float t, EasingDirection direction) {
        switch (direction) {
            case In: {
                return a + (b - a) * t * t * t;
            }
            case Out: {
                return a + (b - a) * (1.0f - (1.0f - t) * (1.0f - t) * (1.0f - t));
            }
        }
        t *= 2.0f;
        if (t < 1.0f) {
            return a + (b - a) * 0.5f * t * t * t;
        }
        return a + (b - a) * 0.5f * ((t -= 2.0f) * t * t + 2.0f);
    }

    public static enum EasingType {
        None,
        Linear,
        Quad,
        Cubic;

    }

    public static enum EasingDirection {
        In,
        Out,
        InOut;

    }
}

