/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.render.entity.layer;

import com.iafenvoy.iceandfire.data.DragonType;
import com.iafenvoy.iceandfire.entity.EntityDragonBase;
import com.iafenvoy.iceandfire.entity.EntityDreadQueen;
import com.iafenvoy.uranus.client.model.AdvancedModelBox;
import com.iafenvoy.uranus.client.model.TabulaModel;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_1297;
import net.minecraft.class_148;
import net.minecraft.class_2338;
import net.minecraft.class_310;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_549;
import net.minecraft.class_572;
import net.minecraft.class_583;
import net.minecraft.class_597;
import net.minecraft.class_7833;
import net.minecraft.class_897;
import net.minecraft.class_898;
import net.minecraft.class_927;

public class LayerDragonRider
extends class_3887<EntityDragonBase, TabulaModel<EntityDragonBase>> {
    public static final List<class_1297> renderingRiders = new ArrayList<class_1297>();
    private final class_927<EntityDragonBase, TabulaModel<EntityDragonBase>> render;
    private final boolean excludeDreadQueenMob;

    public LayerDragonRider(class_927<EntityDragonBase, TabulaModel<EntityDragonBase>> renderIn, boolean excludeDreadQueenMob) {
        super(renderIn);
        this.render = renderIn;
        this.excludeDreadQueenMob = excludeDreadQueenMob;
    }

    public void render(class_4587 matrixStackIn, class_4597 bufferIn, int packedLightIn, EntityDragonBase dragon, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        matrixStackIn.method_22903();
        if (!dragon.method_5685().isEmpty()) {
            float dragonScale = dragon.getRenderSize() / 3.0f;
            for (class_1297 passenger : dragon.method_5685()) {
                boolean prey;
                boolean bl = prey = dragon.method_5642() == null || dragon.method_5642().method_5628() != passenger.method_5628();
                if (this.excludeDreadQueenMob && passenger instanceof EntityDreadQueen) {
                    prey = false;
                }
                float riderRot = passenger.field_5982 + (passenger.method_36454() - passenger.field_5982) * partialTicks;
                int animationTicks = 0;
                if (dragon.getAnimation() == EntityDragonBase.ANIMATION_SHAKEPREY) {
                    animationTicks = dragon.getAnimationTick();
                }
                if (animationTicks == 0 || animationTicks >= 15) {
                    this.translateToBody(matrixStackIn);
                }
                if (prey) {
                    if (animationTicks == 0 || animationTicks >= 15 || dragon.isFlying()) {
                        this.translateToHead(matrixStackIn);
                        this.offsetPerDragonType(dragon.dragonType, matrixStackIn);
                        class_897 render = class_310.method_1551().method_1561().method_3953(passenger);
                        class_583 modelBase = null;
                        if (render instanceof class_927) {
                            class_927 mobEntityRenderer = (class_927)render;
                            modelBase = mobEntityRenderer.method_4038();
                        }
                        if ((passenger.method_17682() > passenger.method_17681() || modelBase instanceof class_572) && !(modelBase instanceof class_597) && !(modelBase instanceof class_549)) {
                            matrixStackIn.method_46416(-0.15f * passenger.method_17682(), 0.1f * dragonScale - 0.1f * passenger.method_17682(), -0.1f * dragonScale - 0.1f * passenger.method_17681());
                            matrixStackIn.method_22907(class_7833.field_40718.rotationDegrees(90.0f));
                            matrixStackIn.method_22907(class_7833.field_40716.rotationDegrees(45.0f));
                        } else {
                            boolean horse = modelBase instanceof class_549;
                            matrixStackIn.method_46416((horse ? -0.08f : -0.15f) * passenger.method_17681(), 0.1f * dragonScale - 0.15f * passenger.method_17681(), -0.1f * dragonScale - 0.1f * passenger.method_17681());
                            matrixStackIn.method_22907(class_7833.field_40713.rotationDegrees(90.0f));
                        }
                    } else {
                        matrixStackIn.method_46416(0.0f, 0.555f * dragonScale, -0.5f * dragonScale);
                    }
                } else {
                    matrixStackIn.method_46416(0.0f, -0.01f * dragonScale, -0.035f * dragonScale);
                }
                matrixStackIn.method_22903();
                matrixStackIn.method_22907(class_7833.field_40718.rotationDegrees(180.0f));
                matrixStackIn.method_22907(class_7833.field_40716.rotationDegrees(riderRot + 180.0f));
                matrixStackIn.method_22905(1.0f / dragonScale, 1.0f / dragonScale, 1.0f / dragonScale);
                matrixStackIn.method_46416(0.0f, -0.25f, 0.0f);
                renderingRiders.add(passenger);
                this.renderEntity(passenger, 0, 0, 0, 0.0f, partialTicks, matrixStackIn, bufferIn, packedLightIn);
                renderingRiders.remove(passenger);
                matrixStackIn.method_22909();
            }
        }
        matrixStackIn.method_22909();
    }

    protected void translateToBody(class_4587 stack) {
        this.postRender(((TabulaModel)this.render.method_4038()).getCube("BodyUpper"), stack);
        this.postRender(((TabulaModel)this.render.method_4038()).getCube("Neck1"), stack);
    }

    protected void translateToHead(class_4587 stack) {
        this.postRender(((TabulaModel)this.render.method_4038()).getCube("Neck2"), stack);
        this.postRender(((TabulaModel)this.render.method_4038()).getCube("Neck3"), stack);
        this.postRender(((TabulaModel)this.render.method_4038()).getCube("Head"), stack);
    }

    protected void postRender(AdvancedModelBox renderer, class_4587 matrixStackIn) {
        if (renderer.rotateAngleX == 0.0f && renderer.rotateAngleY == 0.0f && renderer.rotateAngleZ == 0.0f) {
            if (renderer.rotationPointX != 0.0f || renderer.rotationPointY != 0.0f || renderer.rotationPointZ != 0.0f) {
                matrixStackIn.method_46416(renderer.rotationPointX * 0.0625f, renderer.rotationPointY * 0.0625f, renderer.rotationPointZ * 0.0625f);
            }
        } else {
            matrixStackIn.method_46416(renderer.rotationPointX * 0.0625f, renderer.rotationPointY * 0.0625f, renderer.rotationPointZ * 0.0625f);
            if (renderer.rotateAngleZ != 0.0f) {
                matrixStackIn.method_22907(class_7833.field_40718.rotation(renderer.rotateAngleZ));
            }
            if (renderer.rotateAngleY != 0.0f) {
                matrixStackIn.method_22907(class_7833.field_40716.rotation(renderer.rotateAngleY));
            }
            if (renderer.rotateAngleX != 0.0f) {
                matrixStackIn.method_22907(class_7833.field_40714.rotation(renderer.rotateAngleX));
            }
        }
    }

    private void offsetPerDragonType(DragonType dragonType, class_4587 stackIn) {
        if (dragonType == DragonType.LIGHTNING) {
            stackIn.method_46416(0.1f, -0.2f, -0.1f);
        }
    }

    public <E extends class_1297> void renderEntity(E entityIn, int x, int y, int z, float yaw, float partialTicks, class_4587 matrixStack, class_4597 bufferIn, int packedLight) {
        block4: {
            class_897 render = null;
            class_898 manager = class_310.method_1551().method_1561();
            try {
                render = manager.method_3953(entityIn);
                if (render == null) break block4;
                try {
                    render.method_3936(entityIn, 0.0f, partialTicks, matrixStack, bufferIn, packedLight);
                }
                catch (Throwable throwable1) {
                    throw new class_148(class_128.method_560((Throwable)throwable1, (String)"Rendering entity in world"));
                }
            }
            catch (Throwable throwable3) {
                class_128 crashreport = class_128.method_560((Throwable)throwable3, (String)"Rendering entity in world");
                class_129 crashreportcategory = crashreport.method_562("Entity being rendered");
                entityIn.method_5819(crashreportcategory);
                class_129 crashreportcategory1 = crashreport.method_562("Renderer details");
                crashreportcategory1.method_578("Assigned renderer", (Object)render);
                crashreportcategory1.method_578("Location", (Object)new class_2338(x, y, z));
                crashreportcategory1.method_578("Rotation", (Object)Float.valueOf(yaw));
                crashreportcategory1.method_578("Delta", (Object)Float.valueOf(partialTicks));
                throw new class_148(crashreport);
            }
        }
    }
}

