/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity.util;

import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.entity.EntityStymphalianBird;
import com.iafenvoy.iceandfire.entity.ai.StymphalianBirdAIAirTarget;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_5819;

public class StymphalianBirdFlock {
    private final int distance = 15;
    private EntityStymphalianBird leader;
    private ArrayList<EntityStymphalianBird> members = new ArrayList();
    private class_2338 leaderTarget;
    private class_5819 random;

    private StymphalianBirdFlock() {
    }

    public static StymphalianBirdFlock createFlock(EntityStymphalianBird bird) {
        StymphalianBirdFlock flock = new StymphalianBirdFlock();
        flock.leader = bird;
        flock.members = new ArrayList();
        flock.members.add(bird);
        flock.leaderTarget = bird.airTarget;
        flock.random = bird.method_6051();
        return flock;
    }

    public static StymphalianBirdFlock getNearbyFlock(EntityStymphalianBird bird) {
        float d0 = ((Integer)IafCommonConfig.INSTANCE.stymphalianBird.flockLength.getValue()).intValue();
        List list = bird.method_37908().method_8333((class_1297)bird, new class_238(bird.method_23317(), bird.method_23318(), bird.method_23321(), bird.method_23317() + 1.0, bird.method_23318() + 1.0, bird.method_23321() + 1.0).method_1009((double)d0, 10.0, (double)d0), EntityStymphalianBird.STYMPHALIAN_PREDICATE);
        if (!list.isEmpty()) {
            for (class_1297 entity : list) {
                if (!(entity instanceof EntityStymphalianBird)) continue;
                EntityStymphalianBird other = (EntityStymphalianBird)entity;
                if (other.flock == null) continue;
                return other.flock;
            }
        }
        return null;
    }

    public boolean isLeader(EntityStymphalianBird bird) {
        return this.leader != null && this.leader == bird;
    }

    public void addToFlock(EntityStymphalianBird bird) {
        this.members.add(bird);
    }

    public void update() {
        if (!(this.members.isEmpty() || this.leader != null && this.leader.method_5805())) {
            this.leader = this.members.get(this.random.method_43048(this.members.size()));
        }
        if (this.leader != null && this.leader.method_5805()) {
            class_2338 prevLeaderTarget = this.leaderTarget;
            this.leaderTarget = this.leader.airTarget;
        }
    }

    public void onLeaderAttack(class_1309 attackTarget) {
        for (EntityStymphalianBird bird : this.members) {
            if (bird.method_5968() != null || this.isLeader(bird)) continue;
            bird.method_5980(attackTarget);
        }
    }

    public EntityStymphalianBird getLeader() {
        return this.leader;
    }

    public void setTarget(class_2338 target) {
        this.leaderTarget = target;
        for (EntityStymphalianBird bird : this.members) {
            if (this.isLeader(bird)) continue;
            bird.airTarget = StymphalianBirdAIAirTarget.getNearbyAirTarget(bird);
        }
    }

    public void setFlying(boolean flying) {
        for (EntityStymphalianBird bird : this.members) {
            if (this.isLeader(bird)) continue;
            bird.setFlying(flying);
        }
    }

    public void setFearTarget(class_1309 living) {
        for (EntityStymphalianBird bird : this.members) {
            bird.setVictor(living);
        }
    }
}

