/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity;

import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.entity.EntityStymphalianFeather;
import com.iafenvoy.iceandfire.entity.ai.StymphalianBirdAIAirTarget;
import com.iafenvoy.iceandfire.entity.ai.StymphalianBirdAIFlee;
import com.iafenvoy.iceandfire.entity.ai.StymphalianBirdAITarget;
import com.iafenvoy.iceandfire.entity.util.IAnimalFear;
import com.iafenvoy.iceandfire.entity.util.IVillagerFear;
import com.iafenvoy.iceandfire.entity.util.StymphalianBirdFlock;
import com.iafenvoy.iceandfire.registry.IafEntities;
import com.iafenvoy.iceandfire.registry.IafSounds;
import com.iafenvoy.uranus.animation.Animation;
import com.iafenvoy.uranus.animation.AnimationHandler;
import com.iafenvoy.uranus.animation.IAnimatedEntity;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.class_1266;
import net.minecraft.class_1267;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1399;
import net.minecraft.class_1569;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3321;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_3959;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.server.MinecraftServer;

public class EntityStymphalianBird
extends class_1588
implements IAnimatedEntity,
class_1569,
IVillagerFear,
IAnimalFear {
    public static final Predicate<class_1297> STYMPHALIAN_PREDICATE = entity -> entity instanceof EntityStymphalianBird;
    public static final Animation ANIMATION_PECK = Animation.create((int)20);
    public static final Animation ANIMATION_SHOOT_ARROWS = Animation.create((int)30);
    public static final Animation ANIMATION_SPEAK = Animation.create((int)10);
    private static final int FLIGHT_CHANCE_PER_TICK = 100;
    private static final class_2940<Optional<UUID>> VICTOR_ENTITY = class_2945.method_12791(EntityStymphalianBird.class, (class_2941)class_2943.field_13313);
    private static final class_2940<Boolean> FLYING = class_2945.method_12791(EntityStymphalianBird.class, (class_2941)class_2943.field_13323);
    public float flyProgress;
    public class_2338 airTarget;
    public StymphalianBirdFlock flock;
    private int animationTick;
    private Animation currentAnimation;
    private boolean isFlying;
    private int flyTicks;
    private int launchTicks;
    private boolean aiFlightLaunch = false;
    private int airBorneCounter;

    public EntityStymphalianBird(class_1299<? extends class_1588> t, class_1937 worldIn) {
        super(t, worldIn);
    }

    public static class_5132.class_5133 bakeAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 24.0).method_26868(class_5134.field_23719, 0.3).method_26868(class_5134.field_23721, (Double)IafCommonConfig.INSTANCE.myrmex.baseAttackDamage.getValue() * 2.0).method_26868(class_5134.field_23717, (double)Math.min(2048, (Integer)IafCommonConfig.INSTANCE.stymphalianBird.targetSearchLength.getValue())).method_26868(class_5134.field_23724, 4.0);
    }

    protected void method_5623(double y, boolean onGroundIn, class_2680 state, class_2338 pos) {
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(2, (class_1352)new StymphalianBirdAIFlee(this, 10.0f));
        this.field_6201.method_6277(3, (class_1352)new class_1366((class_1314)this, 1.5, false));
        this.field_6201.method_6277(5, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6201.method_6277(6, (class_1352)new StymphalianBirdAIAirTarget(this));
        this.field_6201.method_6277(7, (class_1352)new class_1361((class_1308)this, class_1309.class, 6.0f));
        this.field_6201.method_6277(8, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new class_1399((class_1314)this, new Class[0]));
        this.field_6185.method_6277(2, (class_1352)new StymphalianBirdAITarget(this, class_1309.class, true));
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(VICTOR_ENTITY, Optional.empty());
        this.field_6011.method_12784(FLYING, (Object)Boolean.FALSE);
    }

    public int method_6110() {
        return 10;
    }

    public void method_5773() {
        super.method_5773();
        if (!this.method_37908().field_9236 && this.method_37908().method_8407() == class_1267.field_5801) {
            this.method_5650(class_1297.class_5529.field_26999);
        }
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        if (this.getVictorId() != null) {
            tag.method_25927("VictorUUID", this.getVictorId());
        }
        tag.method_10556("Flying", this.isFlying());
    }

    public void method_5749(class_2487 tag) {
        UUID s;
        super.method_5749(tag);
        if (tag.method_25928("VictorUUID")) {
            s = tag.method_25926("VictorUUID");
        } else {
            String s1 = tag.method_10558("VictorUUID");
            s = class_3321.method_14546((MinecraftServer)this.method_5682(), (String)s1);
        }
        if (s != null) {
            try {
                this.setVictorId(s);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.setFlying(tag.method_10577("Flying"));
    }

    public boolean isFlying() {
        if (this.method_37908().field_9236) {
            this.isFlying = (Boolean)this.field_6011.method_12789(FLYING);
            return this.isFlying;
        }
        return this.isFlying;
    }

    public void setFlying(boolean flying) {
        this.field_6011.method_12778(FLYING, (Object)flying);
        if (!this.method_37908().field_9236) {
            this.isFlying = flying;
        }
    }

    public void method_6078(class_1282 cause) {
        if (cause.method_5529() != null && cause.method_5529() instanceof class_1309 && !this.method_37908().field_9236) {
            this.setVictorId(cause.method_5529().method_5667());
            if (this.flock != null) {
                this.flock.setFearTarget((class_1309)cause.method_5529());
            }
        }
        super.method_6078(cause);
    }

    public UUID getVictorId() {
        return ((Optional)this.field_6011.method_12789(VICTOR_ENTITY)).orElse(null);
    }

    public void setVictorId(UUID uuid) {
        this.field_6011.method_12778(VICTOR_ENTITY, Optional.ofNullable(uuid));
    }

    public class_1309 getVictor() {
        try {
            UUID uuid = this.getVictorId();
            return uuid == null ? null : this.method_37908().method_18470(uuid);
        }
        catch (IllegalArgumentException var2) {
            return null;
        }
    }

    public void setVictor(class_1309 player) {
        this.setVictorId(player.method_5667());
    }

    public boolean isVictor(class_1309 entityIn) {
        return entityIn == this.getVictor();
    }

    public boolean isTargetBlocked(class_243 target) {
        return this.method_37908().method_17742(new class_3959(target, this.method_5836(1.0f), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this)).method_17783() == class_239.class_240.field_1333;
    }

    public boolean method_6121(class_1297 entityIn) {
        if (this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(ANIMATION_PECK);
        }
        return true;
    }

    public void method_6007() {
        boolean flying;
        super.method_6007();
        if (this.method_37908().method_8407() == class_1267.field_5801 && this.method_5968() instanceof class_1657) {
            this.method_5980(null);
        }
        if (this.method_5968() != null && (this.method_5968() instanceof class_1657 && ((class_1657)this.method_5968()).method_7337() || this.getVictor() != null && this.isVictor(this.method_5968()))) {
            this.method_5980(null);
        }
        if (this.flock == null) {
            StymphalianBirdFlock otherFlock = StymphalianBirdFlock.getNearbyFlock(this);
            if (otherFlock == null) {
                this.flock = StymphalianBirdFlock.createFlock(this);
            } else {
                this.flock = otherFlock;
                this.flock.addToFlock(this);
            }
        } else {
            if (!this.flock.isLeader(this)) {
                double dist = this.method_5858((class_1297)this.flock.getLeader());
                if (dist > 360.0) {
                    this.setFlying(true);
                    this.field_6189.method_6340();
                    this.airTarget = StymphalianBirdAIAirTarget.getNearbyAirTarget(this.flock.getLeader());
                    this.aiFlightLaunch = false;
                } else if (!this.flock.getLeader().isFlying()) {
                    this.setFlying(false);
                    this.airTarget = null;
                    this.aiFlightLaunch = false;
                }
                if (this.method_24828() && dist < 40.0 && this.getAnimation() != ANIMATION_SHOOT_ARROWS) {
                    this.setFlying(false);
                }
            }
            this.flock.update();
        }
        if (!this.method_37908().field_9236 && this.method_5968() != null && this.method_5968().method_5805()) {
            double dist = this.method_5858((class_1297)this.method_5968());
            if (this.getAnimation() == ANIMATION_PECK && this.getAnimationTick() == 7) {
                if (dist < 1.5) {
                    this.method_5968().method_5643(this.method_37908().method_48963().method_48812((class_1309)this), (float)((int)this.method_5996(class_5134.field_23721).method_6194()));
                }
                if (this.method_24828()) {
                    this.setFlying(false);
                }
            }
            if (this.getAnimation() != ANIMATION_PECK && this.getAnimation() != ANIMATION_SHOOT_ARROWS && dist > 3.0 && dist < 225.0) {
                this.setAnimation(ANIMATION_SHOOT_ARROWS);
            }
            if (this.getAnimation() == ANIMATION_SHOOT_ARROWS) {
                class_1309 target = this.method_5968();
                this.method_5951((class_1297)target, 360.0f, 360.0f);
                if (this.isFlying()) {
                    this.method_36456(this.field_6283);
                    if ((this.getAnimationTick() == 7 || this.getAnimationTick() == 14) && this.isDirectPathBetweenPoints((class_1297)this, this.method_19538(), target.method_19538())) {
                        this.method_5783((class_3414)IafSounds.STYMPHALIAN_BIRD_ATTACK.get(), 1.0f, 1.0f);
                        for (int i = 0; i < 4; ++i) {
                            float wingX = (float)(this.method_23317() + (double)(0.9f * class_3532.method_15362((float)((float)((double)(this.method_36454() + (float)(180 * (i % 2))) * Math.PI / 180.0)))));
                            float wingZ = (float)(this.method_23321() + (double)(0.9f * class_3532.method_15374((float)((float)((double)(this.method_36454() + (float)(180 * (i % 2))) * Math.PI / 180.0)))));
                            float wingY = (float)(this.method_23318() + 1.0);
                            double d0 = target.method_23317() - (double)wingX;
                            double d1 = target.method_5829().field_1322 - (double)wingY;
                            double d2 = target.method_23321() - (double)wingZ;
                            double d3 = Math.sqrt(d0 * d0 + d2 * d2);
                            EntityStymphalianFeather entityarrow = new EntityStymphalianFeather((class_1299<? extends class_1665>)((class_1299)IafEntities.STYMPHALIAN_FEATHER.get()), this.method_37908(), (class_1309)this);
                            entityarrow.method_5814(wingX, wingY, wingZ);
                            entityarrow.method_7485(d0, d1 + d3 * 0.10000000298023223, d2, 1.6f, 14 - this.method_37908().method_8407().method_5461() * 4);
                            this.method_5783(class_3417.field_14633, 1.0f, 1.0f / (this.method_6051().method_43057() * 0.4f + 0.8f));
                            this.method_37908().method_8649((class_1297)entityarrow);
                        }
                    }
                } else {
                    this.setFlying(true);
                }
            }
        }
        boolean bl = flying = this.isFlying() && !this.method_24828() || this.airBorneCounter > 10 || this.getAnimation() == ANIMATION_SHOOT_ARROWS;
        if (flying && this.flyProgress < 20.0f) {
            this.flyProgress += 1.0f;
        } else if (!flying && this.flyProgress > 0.0f) {
            this.flyProgress -= 1.0f;
        }
        if (!this.isFlying() && this.airTarget != null && this.method_24828() && !this.method_37908().field_9236) {
            this.airTarget = null;
        }
        if (this.isFlying() && this.method_5968() == null) {
            this.flyAround();
        } else if (this.method_5968() != null) {
            this.flyTowardsTarget();
        }
        if (!this.method_37908().field_9236 && this.doesWantToLand() && !this.aiFlightLaunch && this.getAnimation() != ANIMATION_SHOOT_ARROWS) {
            this.setFlying(false);
            this.airTarget = null;
        }
        if (!this.method_37908().field_9236 && this.method_5654(0.0, 0.0, 0.0) && !this.isFlying()) {
            this.setFlying(true);
            this.launchTicks = 0;
            this.flyTicks = 0;
            this.aiFlightLaunch = true;
        }
        if (!this.method_37908().field_9236 && this.method_24828() && this.isFlying() && !this.aiFlightLaunch && this.getAnimation() != ANIMATION_SHOOT_ARROWS) {
            this.setFlying(false);
            this.airTarget = null;
        }
        if (!this.method_37908().field_9236 && (this.flock == null || this.flock.isLeader(this)) && this.method_6051().method_43048(100) == 0 && !this.isFlying() && this.method_5685().isEmpty() && !this.method_6109() && this.method_24828()) {
            this.setFlying(true);
            this.launchTicks = 0;
            this.flyTicks = 0;
            this.aiFlightLaunch = true;
        }
        if (!this.method_37908().field_9236) {
            if (this.aiFlightLaunch && this.launchTicks < 40) {
                ++this.launchTicks;
            } else {
                this.launchTicks = 0;
                this.aiFlightLaunch = false;
            }
            this.flyTicks = this.isFlying() ? ++this.flyTicks : 0;
        }
        this.airBorneCounter = !this.method_24828() ? ++this.airBorneCounter : 0;
        if (this.getAnimation() == ANIMATION_SHOOT_ARROWS && !this.isFlying() && !this.method_37908().field_9236) {
            this.setFlying(true);
            this.aiFlightLaunch = true;
        }
        AnimationHandler.INSTANCE.updateAnimations((class_1297)this);
    }

    public boolean isDirectPathBetweenPoints(class_1297 entity, class_243 vec1, class_243 vec2) {
        return this.method_37908().method_17742(new class_3959(vec1, vec2, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this)).method_17783() == class_239.class_240.field_1333;
    }

    public void flyAround() {
        if (this.airTarget != null && this.isFlying()) {
            if (!this.isTargetInAir() || this.flyTicks > 6000 || !this.isFlying()) {
                this.airTarget = null;
            }
            this.flyTowardsTarget();
        }
    }

    /*
     * Unable to fully structure code
     */
    public void flyTowardsTarget() {
        if (this.airTarget == null || !this.isTargetInAir() || !this.isFlying()) ** GOTO lbl-1000
        v0 = new class_243((double)this.airTarget.method_10263(), this.method_23318(), (double)this.airTarget.method_10260());
        if (this.getDistanceSquared(v0) > 3.0f) {
            targetX = (double)this.airTarget.method_10263() + 0.5 - this.method_23317();
            targetY = (double)Math.min(this.airTarget.method_10264(), 256) + 1.0 - this.method_23318();
            targetZ = (double)this.airTarget.method_10260() + 0.5 - this.method_23321();
            motionX = (Math.signum(targetX) * 0.5 - this.method_18798().field_1352) * 0.100000000372529 * (double)this.getFlySpeed(false);
            motionY = (Math.signum(targetY) * 0.5 - this.method_18798().field_1351) * 0.100000000372529 * (double)this.getFlySpeed(true);
            motionZ = (Math.signum(targetZ) * 0.5 - this.method_18798().field_1350) * 0.100000000372529 * (double)this.getFlySpeed(false);
            this.method_18799(this.method_18798().method_1031(motionX, motionY, motionZ));
            angle = (float)(Math.atan2(this.method_18798().field_1350, this.method_18798().field_1352) * 180.0 / 3.141592653589793) - 90.0f;
            rotation = class_3532.method_15393((float)(angle - this.method_36454()));
            this.field_6250 = 0.5f;
            this.field_5982 = this.method_36454();
            this.method_36456(this.method_36454() + rotation);
            if (!this.isFlying()) {
                this.setFlying(true);
            }
        } else lbl-1000:
        // 2 sources

        {
            this.airTarget = null;
        }
        if (this.airTarget != null && this.isTargetInAir() && this.isFlying()) {
            v1 = new class_243((double)this.airTarget.method_10263(), this.method_23318(), (double)this.airTarget.method_10260());
            if (this.getDistanceSquared(v1) < 3.0f && this.doesWantToLand()) {
                this.setFlying(false);
            }
        }
    }

    private float getFlySpeed(boolean y) {
        float speed = 2.0f;
        if (this.flock != null && !this.flock.isLeader(this) && this.method_5858((class_1297)this.flock.getLeader()) > 10.0) {
            speed = 4.0f;
        }
        if (this.getAnimation() == ANIMATION_SHOOT_ARROWS && !y) {
            speed *= 0.05f;
        }
        return speed;
    }

    public void method_5966() {
        if (this.getAnimation() == IAnimatedEntity.NO_ANIMATION) {
            this.setAnimation(ANIMATION_SPEAK);
        }
        super.method_5966();
    }

    protected void method_6013(class_1282 source) {
        if (this.getAnimation() == IAnimatedEntity.NO_ANIMATION) {
            this.setAnimation(ANIMATION_SPEAK);
        }
        super.method_6013(source);
    }

    protected class_3414 method_5994() {
        return (class_3414)IafSounds.STYMPHALIAN_BIRD_IDLE.get();
    }

    protected class_3414 method_6011(class_1282 source) {
        return (class_3414)IafSounds.STYMPHALIAN_BIRD_HURT.get();
    }

    protected class_3414 method_6002() {
        return (class_3414)IafSounds.STYMPHALIAN_BIRD_DIE.get();
    }

    public class_1315 method_5943(class_5425 worldIn, class_1266 difficultyIn, class_3730 reason, class_1315 spawnDataIn, class_2487 dataTag) {
        spawnDataIn = super.method_5943(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.method_5996(class_5134.field_23717).method_6192((double)((Integer)IafCommonConfig.INSTANCE.stymphalianBird.targetSearchLength.getValue()).intValue());
        return spawnDataIn;
    }

    public void method_5980(class_1309 entity) {
        if (this.isVictor(entity) && entity != null) {
            return;
        }
        super.method_5980(entity);
        if (this.flock != null && this.flock.isLeader(this) && entity != null) {
            this.flock.onLeaderAttack(entity);
        }
    }

    public float getDistanceSquared(class_243 Vector3d) {
        float f = (float)(this.method_23317() - Vector3d.field_1352);
        float f1 = (float)(this.method_23318() - Vector3d.field_1351);
        float f2 = (float)(this.method_23321() - Vector3d.field_1350);
        return f * f + f1 * f1 + f2 * f2;
    }

    protected boolean isTargetInAir() {
        return this.airTarget != null && (this.method_37908().method_8320(this.airTarget).method_26215() || this.method_37908().method_8320(this.airTarget).method_26215());
    }

    public boolean doesWantToLand() {
        if (this.flock != null && !this.flock.isLeader(this) && this.flock.getLeader() != null) {
            return this.flock.getLeader().doesWantToLand();
        }
        return this.flyTicks > 500 || this.flyTicks > 40 && this.flyProgress == 0.0f;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{NO_ANIMATION, ANIMATION_PECK, ANIMATION_SHOOT_ARROWS, ANIMATION_SPEAK};
    }

    @Override
    public boolean shouldAnimalsFear(class_1297 entity) {
        return (Boolean)IafCommonConfig.INSTANCE.stymphalianBird.attackAnimals.getValue();
    }

    public boolean method_5947() {
        return true;
    }

    public boolean method_5974(double distanceToClosestPlayer) {
        return false;
    }
}

