/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity;

import com.iafenvoy.iceandfire.api.IafEvents;
import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.data.DragonType;
import com.iafenvoy.iceandfire.entity.EntityDragonBase;
import com.iafenvoy.iceandfire.entity.EntityDragonIceCharge;
import com.iafenvoy.iceandfire.entity.util.dragon.DragonUtils;
import com.iafenvoy.iceandfire.entity.util.dragon.IafDragonAttacks;
import com.iafenvoy.iceandfire.entity.util.dragon.IafDragonDestructionManager;
import com.iafenvoy.iceandfire.particle.DragonFrostParticleType;
import com.iafenvoy.iceandfire.registry.IafEntities;
import com.iafenvoy.iceandfire.registry.IafItems;
import com.iafenvoy.iceandfire.registry.IafSounds;
import com.iafenvoy.iceandfire.registry.tag.IafEntityTags;
import com.iafenvoy.uranus.animation.Animation;
import com.iafenvoy.uranus.animation.IAnimatedEntity;
import java.util.Objects;
import java.util.Random;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1480;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3855;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_5134;

public class EntityIceDragon
extends EntityDragonBase {
    public static final class_2960 FEMALE_LOOT = class_2960.method_43902((String)"iceandfire", (String)"entities/dragon/ice_dragon_female");
    public static final class_2960 MALE_LOOT = class_2960.method_43902((String)"iceandfire", (String)"entities/dragon/ice_dragon_male");
    public static final class_2960 SKELETON_LOOT = class_2960.method_43902((String)"iceandfire", (String)"entities/dragon/ice_dragon_skeleton");

    public EntityIceDragon(class_1299<? extends EntityIceDragon> t, class_1937 worldIn) {
        super(t, worldIn, DragonType.ICE, 1.0, 1 + (Integer)IafCommonConfig.INSTANCE.dragon.attackDamage.getValue(), (Double)IafCommonConfig.INSTANCE.dragon.maxHealth.getValue() * 0.04, (Double)IafCommonConfig.INSTANCE.dragon.maxHealth.getValue(), 0.15f, 0.4f);
        ANIMATION_SPEAK = Animation.create((int)20);
        ANIMATION_BITE = Animation.create((int)35);
        ANIMATION_SHAKEPREY = Animation.create((int)65);
        ANIMATION_TAILWHACK = Animation.create((int)40);
        ANIMATION_FIRECHARGE = Animation.create((int)25);
        ANIMATION_WINGBLAST = Animation.create((int)50);
        ANIMATION_ROAR = Animation.create((int)40);
        ANIMATION_EPIC_ROAR = Animation.create((int)60);
    }

    @Override
    protected boolean shouldTarget(class_1297 entity) {
        if (entity instanceof EntityDragonBase && !this.method_6181()) {
            return entity.method_5864() != this.method_5864() && this.method_17681() >= entity.method_17681() && !((EntityDragonBase)entity).isMobDead();
        }
        return entity instanceof class_1657 || DragonUtils.isDragonTargetable(entity, IafEntityTags.ICE_DRAGON_TARGETS) || entity instanceof class_1480 || !this.method_6181() && DragonUtils.isVillager(entity);
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(SWIMMING, (Object)Boolean.FALSE);
    }

    @Override
    public String getVariantName(int variant) {
        return switch (variant) {
            case 1 -> "white_";
            case 2 -> "sapphire_";
            case 3 -> "silver_";
            default -> "blue_";
        };
    }

    public boolean method_6094() {
        return true;
    }

    public boolean method_5675() {
        return false;
    }

    @Override
    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10556("Swimming", this.method_5681());
        compound.method_10569("SwimmingTicks", this.ticksSwiming);
    }

    @Override
    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.method_5796(compound.method_10577("Swimming"));
        this.ticksSwiming = compound.method_10550("SwimmingTicks");
    }

    @Override
    public boolean method_6121(class_1297 entityIn) {
        this.method_5988().method_6226(entityIn, 30.0f, 30.0f);
        if (!this.isPlayingAttackAnimation()) {
            switch (this.groundAttack) {
                case BITE: {
                    this.setAnimation(ANIMATION_BITE);
                    break;
                }
                case TAIL_WHIP: {
                    this.setAnimation(ANIMATION_TAILWHACK);
                    break;
                }
                case SHAKE_PREY: {
                    boolean flag = false;
                    if (new Random().nextInt(2) == 0 && this.isDirectPathBetweenPoints((class_1297)this, this.method_19538().method_1031(0.0, (double)(this.method_17682() / 2.0f), 0.0), entityIn.method_19538().method_1031(0.0, (double)(entityIn.method_17682() / 2.0f), 0.0)) && entityIn.method_17681() < this.method_17681() * 0.5f && this.method_5642() == null && this.getDragonStage() > 1 && !(entityIn instanceof EntityDragonBase) && !DragonUtils.isAnimaniaMob(entityIn)) {
                        this.setAnimation(ANIMATION_SHAKEPREY);
                        flag = true;
                        entityIn.method_5804((class_1297)this);
                    }
                    if (flag) break;
                    this.groundAttack = IafDragonAttacks.Ground.BITE;
                    this.setAnimation(ANIMATION_BITE);
                    break;
                }
                case WING_BLAST: {
                    this.setAnimation(ANIMATION_WINGBLAST);
                }
            }
        }
        return false;
    }

    @Override
    public void method_6007() {
        super.method_6007();
        class_1309 attackTarget = this.method_5968();
        if (!this.method_37908().field_9236 && this.method_5771() && this.isAllowedToTriggerFlight() && !this.isModelDead()) {
            this.setHovering(true);
            this.method_6179(false);
            this.method_24346(false);
            this.flyHovering = 0;
            this.flyTicks = 0;
        }
        if (!this.method_37908().field_9236 && attackTarget != null) {
            if (this.method_5829().method_1009((double)(0.0f + this.getRenderSize() * 0.33f), (double)(0.0f + this.getRenderSize() * 0.33f), (double)(0.0f + this.getRenderSize() * 0.33f)).method_994(attackTarget.method_5829())) {
                this.method_6121((class_1297)attackTarget);
            }
            if (this.groundAttack == IafDragonAttacks.Ground.FIRE && (this.usingGroundAttack || this.method_24828())) {
                this.shootIceAtMob(attackTarget);
            }
            if (this.airAttack == IafDragonAttacks.Air.TACKLE && !this.usingGroundAttack && this.method_5858((class_1297)attackTarget) < 100.0) {
                double difX = attackTarget.method_23317() - this.method_23317();
                double difY = attackTarget.method_23318() + (double)attackTarget.method_17682() - this.method_23318();
                double difZ = attackTarget.method_23321() - this.method_23321();
                this.method_18799(this.method_18798().method_1031(difX * 0.1, difY * 0.1, difZ * 0.1));
                if (this.method_5829().method_1009((double)(1.0f + this.getRenderSize() * 0.5f), (double)(1.0f + this.getRenderSize() * 0.5f), (double)(1.0f + this.getRenderSize() * 0.5f)).method_994(attackTarget.method_5829())) {
                    this.method_6121((class_1297)attackTarget);
                    this.usingGroundAttack = true;
                    this.randomizeAttacks();
                    this.setFlying(false);
                    this.setHovering(false);
                }
            }
        }
        boolean swimming = this.method_5799();
        this.prevSwimProgress = this.swimProgress;
        if (swimming && this.swimProgress < 20.0f) {
            this.swimProgress += 0.5f;
        } else if (!swimming && this.swimProgress > 0.0f) {
            this.swimProgress -= 0.5f;
        }
        if (this.method_5799() && !this.method_5681() && (!this.isFlying() && !this.isHovering() || this.flyTicks > 100)) {
            this.method_5796(true);
            this.setHovering(false);
            this.setFlying(false);
            this.flyTicks = 0;
            this.ticksSwiming = 0;
        }
        if ((!this.method_5799() || this.isHovering() || this.isFlying()) && this.method_5681()) {
            this.method_5796(false);
            this.ticksSwiming = 0;
        }
        if (this.method_5681() && !this.isModelDead()) {
            ++this.ticksSwiming;
            if (this.method_5799() && (this.ticksSwiming > 4000 || this.method_5968() != null && this.method_5799() != this.method_5968().method_5799()) && !this.method_6109() && !this.isHovering() && !this.isFlying()) {
                this.setHovering(true);
                this.method_6043();
                this.method_18799(this.method_18798().method_1031(0.0, 0.8, 0.0));
                this.method_5796(false);
            }
        }
        if (!this.method_37908().field_9236 && this.method_5642() == null && this.isHovering() && !this.isFlying() && this.method_5799()) {
            this.method_18799(this.method_18798().method_1031(0.0, 0.2, 0.0));
        }
        this.swimCycle = this.swimCycle < 48 ? (this.swimCycle += 2) : 0;
        if (this.isModelDead() && this.swimCycle != 0) {
            this.swimCycle = 0;
        }
    }

    @Override
    public void riderShootFire(class_1297 controller) {
        if (this.method_6051().method_43048(5) == 0 && !this.method_6109()) {
            if (this.getAnimation() != ANIMATION_FIRECHARGE) {
                this.setAnimation(ANIMATION_FIRECHARGE);
            } else if (this.getAnimationTick() == 15) {
                this.method_36456(this.field_6283);
                class_243 headVec = this.getHeadPosition();
                this.method_5783((class_3414)IafSounds.ICEDRAGON_BREATH.get(), 4.0f, 1.0f);
                double d2 = controller.method_5720().field_1352;
                double d3 = controller.method_5720().field_1351;
                double d4 = controller.method_5720().field_1350;
                float inaccuracy = 1.0f;
                EntityDragonIceCharge entitylargefireball = new EntityDragonIceCharge((class_1299<? extends class_3855>)((class_1299)IafEntities.ICE_DRAGON_CHARGE.get()), this.method_37908(), this, d2 += this.field_5974.method_43059() * (double)0.0075f * (double)inaccuracy, d3 += this.field_5974.method_43059() * (double)0.0075f * (double)inaccuracy, d4 += this.field_5974.method_43059() * (double)0.0075f * (double)inaccuracy);
                float size = this.method_6109() ? 0.4f : (this.method_27071() ? 1.3f : 0.8f);
                entitylargefireball.method_5814(headVec.field_1352, headVec.field_1351, headVec.field_1350);
                if (!this.method_37908().field_9236) {
                    this.method_37908().method_8649((class_1297)entitylargefireball);
                }
            }
        } else if (this.isBreathingFire()) {
            if (this.isActuallyBreathingFire()) {
                class_239 mop;
                this.method_36456(this.field_6283);
                if (this.field_6012 % 5 == 0) {
                    this.method_5783((class_3414)IafSounds.ICEDRAGON_BREATH.get(), 4.0f, 1.0f);
                }
                if ((mop = this.rayTraceRider(controller, 10 * this.getDragonStage(), 1.0f)) != null) {
                    this.stimulateFire(mop.method_17784().field_1352, mop.method_17784().field_1351, mop.method_17784().field_1350, 1);
                }
            }
        } else {
            this.setBreathingFire(true);
        }
    }

    public boolean method_5957(class_4538 worldIn) {
        return worldIn.method_8606((class_1297)this);
    }

    public void method_5764(boolean pDownwards) {
        if (this.getDragonStage() < 2) {
            super.method_5764(pDownwards);
        }
    }

    public void method_5700(boolean pDownwards) {
        if (this.getDragonStage() < 2) {
            super.method_5700(pDownwards);
        }
    }

    @Override
    public void method_6091(class_243 pTravelVector) {
        if (this.method_5799()) {
            if (this.method_6034() && this.method_5642() == null) {
                this.method_5724(this.method_6029(), pTravelVector);
                this.method_5784(class_1313.field_6308, this.method_18798());
                this.method_18799(this.method_18798().method_1021(0.9));
                this.method_5968();
            } else {
                Objects.requireNonNull(this);
                if (this.method_5642() != null && !this.isHovering() && !this.isFlying()) {
                    class_1309 rider = this.method_5642();
                    float speed = (float)this.method_26825(class_5134.field_23719);
                    float waterSpeedMod = (float)((double)0.42f + 0.1 * class_3532.method_33722((double)speed, (double)this.minimumSpeed, (double)this.maximumSpeed, (double)0.0, (double)1.5));
                    speed *= waterSpeedMod;
                    speed *= rider.method_5624() ? 1.5f : 1.0f;
                    float vertical = 0.0f;
                    if (this.isGoingUp() && !this.isGoingDown()) {
                        vertical = 1.0f;
                    } else if (this.isGoingDown() && !this.isGoingUp()) {
                        vertical = -1.0f;
                    } else if (this.isGoingUp() && this.isGoingDown() && this.method_5787()) {
                        this.method_18799(this.method_18798().method_18805(1.0, 0.5, 1.0));
                    }
                    class_243 travelVector = new class_243((double)rider.field_6212, (double)vertical, (double)rider.field_6250);
                    if (this.method_5787()) {
                        this.method_6125(speed);
                        this.method_5724(this.method_6029(), travelVector);
                        this.method_5784(class_1313.field_6308, this.method_18798());
                        class_243 currentMotion = this.method_18798();
                        if (this.field_5976) {
                            currentMotion = new class_243(currentMotion.field_1352, 0.2, currentMotion.field_1350);
                        }
                        this.method_18799(currentMotion.method_1021(0.9));
                        this.method_29242(false);
                    } else {
                        this.method_18799(class_243.field_1353);
                    }
                    this.method_36974();
                } else {
                    super.method_6091(pTravelVector);
                }
            }
        } else {
            Objects.requireNonNull(this);
            if (this.method_5642() != null && !this.isHovering() && !this.isFlying() && this.method_37908().method_8320(this.method_23314()).method_26227().method_15767(class_3486.field_15517)) {
                class_1309 rider = this.method_5642();
                double forward = rider.field_6250;
                double strafing = rider.field_6212;
                double vertical = pTravelVector.field_1351;
                float speed = (float)this.method_26825(class_5134.field_23719);
                float groundSpeedModifier = (float)((double)1.8f * this.getFlightSpeedModifier());
                speed *= groundSpeedModifier;
                forward *= rider.method_5624() ? (double)1.2f : 1.0;
                forward *= rider.field_6250 > 0.0f ? 1.0 : (double)0.2f;
                strafing *= (double)0.05f;
                if (this.method_5787()) {
                    this.method_6125(speed);
                    super.method_6091(new class_243(strafing, vertical, forward));
                    class_243 currentMotion = this.method_18798();
                    if (this.field_5976) {
                        currentMotion = new class_243(currentMotion.field_1352, 0.2, currentMotion.field_1350);
                    }
                    this.method_18799(currentMotion.method_1021(1.0));
                } else {
                    this.method_18799(class_243.field_1353);
                }
                this.method_36974();
            } else {
                super.method_6091(pTravelVector);
            }
        }
    }

    @Override
    public class_2960 getDeadLootTable() {
        if (this.getDeathStage() >= this.getAgeInDays() / 5 / 2) {
            return SKELETON_LOOT;
        }
        return this.isMale() ? MALE_LOOT : FEMALE_LOOT;
    }

    private void shootIceAtMob(class_1309 entity) {
        if (this.usingGroundAttack && this.groundAttack == IafDragonAttacks.Ground.FIRE || !this.usingGroundAttack && (this.airAttack == IafDragonAttacks.Air.SCORCH_STREAM || this.airAttack == IafDragonAttacks.Air.HOVER_BLAST)) {
            if (this.usingGroundAttack && this.method_6051().method_43048(5) == 0 || !this.usingGroundAttack && this.airAttack == IafDragonAttacks.Air.HOVER_BLAST) {
                if (this.getAnimation() != ANIMATION_FIRECHARGE) {
                    this.setAnimation(ANIMATION_FIRECHARGE);
                } else if (this.getAnimationTick() == 15) {
                    this.method_36456(this.field_6283);
                    class_243 headVec = this.getHeadPosition();
                    double d2 = entity.method_23317() - headVec.field_1352;
                    double d3 = entity.method_23318() - headVec.field_1351;
                    double d4 = entity.method_23321() - headVec.field_1350;
                    float inaccuracy = 1.0f;
                    this.method_5783((class_3414)IafSounds.ICEDRAGON_BREATH.get(), 4.0f, 1.0f);
                    EntityDragonIceCharge entitylargefireball = new EntityDragonIceCharge((class_1299<? extends class_3855>)((class_1299)IafEntities.ICE_DRAGON_CHARGE.get()), this.method_37908(), this, d2 += this.field_5974.method_43059() * (double)0.0075f * (double)inaccuracy, d3 += this.field_5974.method_43059() * (double)0.0075f * (double)inaccuracy, d4 += this.field_5974.method_43059() * (double)0.0075f * (double)inaccuracy);
                    float size = this.method_6109() ? 0.4f : (this.method_27071() ? 1.3f : 0.8f);
                    entitylargefireball.method_5814(headVec.field_1352, headVec.field_1351, headVec.field_1350);
                    if (!this.method_37908().field_9236) {
                        this.method_37908().method_8649((class_1297)entitylargefireball);
                    }
                    if (!entity.method_5805()) {
                        this.setBreathingFire(false);
                        this.usingGroundAttack = true;
                    }
                }
            } else if (this.isBreathingFire()) {
                if (this.isActuallyBreathingFire()) {
                    this.method_36456(this.field_6283);
                    if (this.field_6012 % 5 == 0) {
                        this.method_5783((class_3414)IafSounds.ICEDRAGON_BREATH.get(), 4.0f, 1.0f);
                    }
                    this.stimulateFire(entity.method_23317(), entity.method_23318(), entity.method_23321(), 1);
                    if (!entity.method_5805()) {
                        this.setBreathingFire(false);
                        this.usingGroundAttack = true;
                    }
                }
            } else {
                this.setBreathingFire(true);
            }
        }
        this.method_5951((class_1297)entity, 360.0f, 360.0f);
    }

    @Override
    public void stimulateFire(double burnX, double burnY, double burnZ, int syncType) {
        if (((IafEvents.DragonFire)IafEvents.ON_DRAGON_FIRE_BLOCK.invoker()).onFireBlock(this, burnX, burnY, burnZ)) {
            return;
        }
        if (syncType > 2 && syncType < 6) {
            if (this.getAnimation() != ANIMATION_FIRECHARGE) {
                this.setAnimation(ANIMATION_FIRECHARGE);
            } else if (this.getAnimationTick() == 20) {
                this.method_36456(this.field_6283);
                class_243 headVec = this.getHeadPosition();
                double d2 = burnX - headVec.field_1352;
                double d3 = burnY - headVec.field_1351;
                double d4 = burnZ - headVec.field_1350;
                float inaccuracy = 1.0f;
                this.method_5783((class_3414)IafSounds.FIREDRAGON_BREATH.get(), 4.0f, 1.0f);
                EntityDragonIceCharge entitylargefireball = new EntityDragonIceCharge((class_1299<? extends class_3855>)((class_1299)IafEntities.ICE_DRAGON_CHARGE.get()), this.method_37908(), this, d2 += this.field_5974.method_43059() * (double)0.0075f * (double)inaccuracy, d3 += this.field_5974.method_43059() * (double)0.0075f * (double)inaccuracy, d4 += this.field_5974.method_43059() * (double)0.0075f * (double)inaccuracy);
                entitylargefireball.method_5814(headVec.field_1352, headVec.field_1351, headVec.field_1350);
                if (!this.method_37908().field_9236) {
                    this.method_37908().method_8649((class_1297)entitylargefireball);
                }
            }
            return;
        }
        this.method_5942().method_6340();
        this.burnParticleX = burnX;
        this.burnParticleY = burnY;
        this.burnParticleZ = burnZ;
        class_243 headPos = this.getHeadPosition();
        double d2 = burnX - headPos.field_1352;
        double d3 = burnY - headPos.field_1351;
        double d4 = burnZ - headPos.field_1350;
        double distance = Math.max(2.5 * Math.sqrt(this.method_5649(burnX, burnY, burnZ)), 0.0);
        double conqueredDistance = (double)this.burnProgress / 40.0 * distance;
        int increment = (int)Math.ceil(conqueredDistance / 100.0);
        int particleCount = this.getDragonStage() <= 3 ? 6 : 3;
        int i = 0;
        while ((double)i < conqueredDistance) {
            double progressX = headPos.field_1352 + d2 * (double)((float)i / (float)distance);
            double progressY = headPos.field_1351 + d3 * (double)((float)i / (float)distance);
            double progressZ = headPos.field_1350 + d4 * (double)((float)i / (float)distance);
            if (this.canPositionBeSeen(progressX, progressY, progressZ)) {
                if (this.field_5974.method_43048(particleCount) == 0) {
                    class_243 velocity = new class_243(progressX, progressY, progressZ).method_1020(headPos);
                    class_1937 class_19372 = this.method_37908();
                    if (class_19372 instanceof class_3218) {
                        class_3218 serverWorld = (class_3218)class_19372;
                        serverWorld.method_14199((class_2394)new DragonFrostParticleType(this.method_17825()), headPos.field_1352, headPos.field_1351, headPos.field_1350, 0, velocity.field_1352, velocity.field_1351, velocity.field_1350, 1.0);
                    }
                }
            } else if (!this.method_37908().field_9236) {
                class_3965 result = this.method_37908().method_17742(new class_3959(new class_243(this.method_23317(), this.method_23318() + (double)this.method_5751(), this.method_23321()), new class_243(progressX, progressY, progressZ), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this));
                class_243 vec3 = result.method_17784();
                class_2338 pos = class_2338.method_49638((class_2374)vec3);
                IafDragonDestructionManager.destroyAreaBreath(this.method_37908(), pos, this);
            }
            i += increment;
        }
        if ((double)this.burnProgress >= 40.0 && this.canPositionBeSeen(burnX, burnY, burnZ)) {
            double spawnX = burnX + (double)this.field_5974.method_43057() * 3.0 - 1.5;
            double spawnY = burnY + (double)this.field_5974.method_43057() * 3.0 - 1.5;
            double spawnZ = burnZ + (double)this.field_5974.method_43057() * 3.0 - 1.5;
            if (!this.method_37908().field_9236) {
                IafDragonDestructionManager.destroyAreaBreath(this.method_37908(), class_2338.method_49637((double)spawnX, (double)spawnY, (double)spawnZ), this);
            }
        }
    }

    public boolean method_5681() {
        if (this.method_37908().field_9236) {
            boolean swimming;
            this.isSwimming = swimming = ((Boolean)this.field_6011.method_12789(SWIMMING)).booleanValue();
            return swimming;
        }
        return this.isSwimming;
    }

    public void method_5796(boolean swimming) {
        this.field_6011.method_12778(SWIMMING, (Object)swimming);
        if (!this.method_37908().field_9236) {
            this.isSwimming = swimming;
        }
    }

    protected class_3414 method_5994() {
        return this.isTeen() ? (class_3414)IafSounds.ICEDRAGON_TEEN_IDLE.get() : (this.method_27071() ? (class_3414)IafSounds.ICEDRAGON_ADULT_IDLE.get() : (class_3414)IafSounds.ICEDRAGON_CHILD_IDLE.get());
    }

    protected class_3414 method_6011(class_1282 damageSourceIn) {
        return this.isTeen() ? (class_3414)IafSounds.ICEDRAGON_TEEN_HURT.get() : (this.method_27071() ? (class_3414)IafSounds.ICEDRAGON_ADULT_HURT.get() : (class_3414)IafSounds.ICEDRAGON_CHILD_HURT.get());
    }

    protected class_3414 method_6002() {
        return this.isTeen() ? (class_3414)IafSounds.ICEDRAGON_TEEN_DEATH.get() : (this.method_27071() ? (class_3414)IafSounds.ICEDRAGON_ADULT_DEATH.get() : (class_3414)IafSounds.ICEDRAGON_CHILD_DEATH.get());
    }

    @Override
    public class_3414 getRoarSound() {
        return this.isTeen() ? (class_3414)IafSounds.ICEDRAGON_TEEN_ROAR.get() : (this.method_27071() ? (class_3414)IafSounds.ICEDRAGON_ADULT_ROAR.get() : (class_3414)IafSounds.ICEDRAGON_CHILD_ROAR.get());
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{IAnimatedEntity.NO_ANIMATION, ANIMATION_EAT, ANIMATION_SPEAK, ANIMATION_BITE, ANIMATION_SHAKEPREY, ANIMATION_TAILWHACK, ANIMATION_FIRECHARGE, ANIMATION_WINGBLAST, ANIMATION_ROAR};
    }

    public boolean method_6481(class_1799 stack) {
        return !stack.method_7960() && stack.method_7909() != null && stack.method_7909() == IafItems.FROST_STEW.get();
    }

    @Override
    protected void breathFireAtPos(class_2338 burningTarget) {
        if (this.isBreathingFire()) {
            if (this.isActuallyBreathingFire()) {
                this.method_36456(this.field_6283);
                if (this.field_6012 % 5 == 0) {
                    this.method_5783((class_3414)IafSounds.ICEDRAGON_BREATH.get(), 4.0f, 1.0f);
                }
                this.stimulateFire((float)burningTarget.method_10263() + 0.5f, (float)burningTarget.method_10264() + 0.5f, (float)burningTarget.method_10260() + 0.5f, 1);
            }
        } else {
            this.setBreathingFire(true);
        }
    }

    @Override
    public double getFlightSpeedModifier() {
        return super.getFlightSpeedModifier() * (double)(this.method_5799() ? 0.3f : 1.0f);
    }

    @Override
    public boolean isAllowedToTriggerFlight() {
        return super.isAllowedToTriggerFlight() && !this.method_5799();
    }

    @Override
    public void spawnBabyParticles() {
        if (this.method_37908().field_9236) {
            for (int i = 0; i < 5; ++i) {
                float radiusAdd = (float)i * 0.15f;
                float headPosX = (float)(this.method_23317() + (double)(1.8f * this.getRenderSize() * (0.3f + radiusAdd) * class_3532.method_15362((float)((float)((double)(this.method_36454() + 90.0f) * Math.PI / 180.0)))));
                float headPosZ = (float)(this.method_23321() + (double)(1.8f * this.getRenderSize() * (0.3f + radiusAdd) * class_3532.method_15374((float)((float)((double)(this.method_36454() + 90.0f) * Math.PI / 180.0)))));
                float headPosY = (float)(this.method_23318() + 0.5 * (double)this.getRenderSize() * (double)0.3f);
                this.method_37908().method_8406((class_2394)new DragonFrostParticleType(this.method_17825()), (double)headPosX, (double)headPosY, (double)headPosZ, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public int getStartMetaForType() {
        return 4;
    }

    @Override
    public class_3414 getBabyFireSound() {
        return class_3417.field_15029;
    }

    @Override
    public class_1799 getSkull() {
        return new class_1799((class_1935)IafItems.DRAGON_SKULL_ICE.get());
    }

    @Override
    public boolean useFlyingPathFinder() {
        return (this.isFlying() || this.method_5799()) && this.method_5642() == null;
    }

    @Override
    public class_1792 getBloodItem() {
        return (class_1792)IafItems.ICE_DRAGON_BLOOD.get();
    }

    @Override
    public class_1792 getFleshItem() {
        return (class_1792)IafItems.ICE_DRAGON_FLESH.get();
    }

    @Override
    public class_1935 getHeartItem() {
        return (class_1935)IafItems.ICE_DRAGON_HEART.get();
    }
}

