/*
 * Decompiled with CFR 0.152.
 */
package dev.hybridlabs.aquatic;

import dev.hybridlabs.aquatic.block.HybridAquaticBlocks;
import dev.hybridlabs.aquatic.block.PlushieBlock;
import dev.hybridlabs.aquatic.block.SeaMessage;
import dev.hybridlabs.aquatic.config.EntitySpawnConfig;
import dev.hybridlabs.aquatic.config.HybridAquaticConfig;
import dev.hybridlabs.aquatic.config.HybridAquaticConfigHandler;
import dev.hybridlabs.aquatic.entity.SpawnRestrictionRegistry;
import dev.hybridlabs.aquatic.loot.LootTableModifications;
import dev.hybridlabs.aquatic.network.HybridAquaticNetworking;
import dev.hybridlabs.aquatic.registry.HybridAquaticRegistryKeys;
import dev.hybridlabs.aquatic.utils.HybridAquaticCustomTrades;
import dev.hybridlabs.aquatic.world.gen.feature.FeatureBiomeModifications;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectors;
import net.fabricmc.fabric.api.event.registry.DynamicRegistries;
import net.fabricmc.fabric.api.object.builder.v1.trade.TradeOfferHelper;
import net.fabricmc.fabric.api.registry.FlammableBlockRegistry;
import net.fabricmc.fabric.api.registry.StrippableBlockRegistry;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1311;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_3853;
import net.minecraft.class_7922;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u000f\u0010\u0006\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0003J\u000f\u0010\u0007\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0007\u0010\u0003J\u000f\u0010\b\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\b\u0010\u0003J\u0017\u0010\u000b\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\r\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\r\u0010\u0003J\u0017\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0013\u001a\u00020\u00128\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00128\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0014R\u0014\u0010\u0017\u001a\u00020\u00168\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018R\u0017\u0010\u001a\u001a\u00020\u00198\u0006\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u001c\u0010\u001dR\u0017\u0010\u001f\u001a\u00020\u001e8\u0006\u00a2\u0006\f\n\u0004\b\u001f\u0010 \u001a\u0004\b!\u0010\"\u00a8\u0006#"}, d2={"Ldev/hybridlabs/aquatic/HybridAquatic;", "Lnet/fabricmc/api/ModInitializer;", "<init>", "()V", "", "onInitialize", "initializeConfig", "registerDynamicRegistries", "registerWanderingTraderTrades", "Lnet/fabricmc/fabric/api/registry/FlammableBlockRegistry;", "registry", "registerFlammables", "(Lnet/fabricmc/fabric/api/registry/FlammableBlockRegistry;)V", "registerStrippables", "Ldev/hybridlabs/aquatic/config/HybridAquaticConfig;", "config", "registerBiomeModifications", "(Ldev/hybridlabs/aquatic/config/HybridAquaticConfig;)V", "", "MOD_ID", "Ljava/lang/String;", "MOD_NAME", "Lorg/slf4j/Logger;", "logger", "Lorg/slf4j/Logger;", "Ljava/nio/file/Path;", "configFile", "Ljava/nio/file/Path;", "getConfigFile", "()Ljava/nio/file/Path;", "Ldev/hybridlabs/aquatic/config/HybridAquaticConfigHandler;", "configHandler", "Ldev/hybridlabs/aquatic/config/HybridAquaticConfigHandler;", "getConfigHandler", "()Ldev/hybridlabs/aquatic/config/HybridAquaticConfigHandler;", "hybrid-aquatic"})
@SourceDebugExtension(value={"SMAP\nHybridAquatic.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HybridAquatic.kt\ndev/hybridlabs/aquatic/HybridAquatic\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,154:1\n774#2:155\n865#2,2:156\n1869#2,2:158\n1869#2,2:160\n*S KotlinDebug\n*F\n+ 1 HybridAquatic.kt\ndev/hybridlabs/aquatic/HybridAquatic\n*L\n122#1:155\n122#1:156,2\n123#1:158,2\n149#1:160,2\n*E\n"})
public final class HybridAquatic
implements ModInitializer {
    @NotNull
    public static final HybridAquatic INSTANCE = new HybridAquatic();
    @NotNull
    public static final String MOD_ID = "hybrid-aquatic";
    @NotNull
    public static final String MOD_NAME = "Hybrid Aquatic";
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final Path configFile;
    @NotNull
    private static final HybridAquaticConfigHandler configHandler;

    private HybridAquatic() {
    }

    @NotNull
    public final Path getConfigFile() {
        return configFile;
    }

    @NotNull
    public final HybridAquaticConfigHandler getConfigHandler() {
        return configHandler;
    }

    public void onInitialize() {
        logger.info("Initializing Hybrid Aquatic");
        HybridAquaticNetworking.INSTANCE.registerNetworking();
        LootTableModifications.INSTANCE.registerLootModifications();
        FeatureBiomeModifications.INSTANCE.registerBiomeModifications();
        SpawnRestrictionRegistry.INSTANCE.registerSpawnRestrictions();
        this.initializeConfig();
        this.registerDynamicRegistries();
        this.registerWanderingTraderTrades();
        HybridAquaticCustomTrades.registerCustomTrades();
        FlammableBlockRegistry flammableBlockRegistry = FlammableBlockRegistry.getDefaultInstance();
        Intrinsics.checkNotNullExpressionValue((Object)flammableBlockRegistry, (String)"getDefaultInstance(...)");
        this.registerFlammables(flammableBlockRegistry);
        this.registerStrippables();
        this.registerBiomeModifications(configHandler.getConfig());
    }

    private final void initializeConfig() {
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.notExists(configFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            logger.info("Hybrid Aquatic config file did not exist, creating one");
            configHandler.save();
        } else {
            logger.info("Loading Hybrid Aquatic config file");
            configHandler.load();
            HybridAquaticConfig defaultConfig = configHandler.getDefaultConfig();
            HybridAquaticConfig config = configHandler.getConfig();
            if (config.getDataVersion() < defaultConfig.getDataVersion()) {
                logger.info("Old Hybrid Aquatic config file found, upgrading");
                configHandler.backup();
                configHandler.setConfig(defaultConfig);
                configHandler.save();
                logger.info("Hybrid Aquatic config reset, the old config has been backed up to \"" + configHandler.getBackupFile() + "\"");
            }
        }
    }

    private final void registerDynamicRegistries() {
        DynamicRegistries.registerSynced(HybridAquaticRegistryKeys.INSTANCE.getSEA_MESSAGE(), SeaMessage.Companion.getCODEC(), (DynamicRegistries.SyncOption[])new DynamicRegistries.SyncOption[0]);
    }

    /*
     * WARNING - void declaration
     */
    private final void registerWanderingTraderTrades() {
        void $this$filterTo$iv$iv;
        class_7922 class_79222 = class_7923.field_41178;
        Intrinsics.checkNotNullExpressionValue((Object)class_79222, (String)"ITEM");
        Iterable $this$filter$iv = (Iterable)class_79222;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            class_1792 it = (class_1792)element$iv$iv;
            boolean bl = false;
            if (!(it instanceof class_1747 && ((class_1747)it).method_7711() instanceof PlushieBlock)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            class_1792 block = (class_1792)element$iv;
            boolean bl = false;
            TradeOfferHelper.registerWanderingTraderOffers((int)2, arg_0 -> HybridAquatic.registerWanderingTraderTrades$lambda$2$lambda$1(block, arg_0));
        }
    }

    private final void registerFlammables(FlammableBlockRegistry registry) {
        registry.add(HybridAquaticBlocks.INSTANCE.getDRIFTWOOD_LOG(), 5, 5);
        registry.add(HybridAquaticBlocks.INSTANCE.getSTRIPPED_DRIFTWOOD_LOG(), 5, 5);
        registry.add(HybridAquaticBlocks.INSTANCE.getDRIFTWOOD_WOOD(), 5, 5);
        registry.add(HybridAquaticBlocks.INSTANCE.getSTRIPPED_DRIFTWOOD_WOOD(), 5, 5);
        registry.add(HybridAquaticBlocks.INSTANCE.getDRIFTWOOD_PLANKS(), 5, 20);
        registry.add(HybridAquaticBlocks.INSTANCE.getDRIFTWOOD_SLAB(), 5, 20);
        registry.add(HybridAquaticBlocks.INSTANCE.getDRIFTWOOD_FENCE(), 5, 20);
        registry.add(HybridAquaticBlocks.INSTANCE.getDRIFTWOOD_FENCE_GATE(), 5, 20);
        registry.add(HybridAquaticBlocks.INSTANCE.getSTRIPPED_DRIFTWOOD_WOOD(), 5, 5);
    }

    private final void registerStrippables() {
        StrippableBlockRegistry.register((class_2248)HybridAquaticBlocks.INSTANCE.getDRIFTWOOD_LOG(), (class_2248)HybridAquaticBlocks.INSTANCE.getSTRIPPED_DRIFTWOOD_LOG());
        StrippableBlockRegistry.register((class_2248)HybridAquaticBlocks.INSTANCE.getDRIFTWOOD_WOOD(), (class_2248)HybridAquaticBlocks.INSTANCE.getSTRIPPED_DRIFTWOOD_WOOD());
    }

    private final void registerBiomeModifications(HybridAquaticConfig config) {
        Iterable $this$forEach$iv = config.getEntitySpawnConfig();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EntitySpawnConfig config2 = (EntitySpawnConfig)element$iv;
            boolean bl = false;
            BiomeModifications.addSpawn((Predicate)BiomeSelectors.tag(config2.getBiomes()), (class_1311)config2.getGroup(), config2.getType(), (int)config2.getWeight(), (int)config2.getMinGroupSize(), (int)config2.getMaxGroupSize());
        }
    }

    private static final void registerWanderingTraderTrades$lambda$2$lambda$1(class_1792 $block, List list) {
        list.add(new class_3853.class_4165($block, 8, 1, 2, 2));
    }

    static {
        Logger logger = LoggerFactory.getLogger((String)MOD_NAME);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        HybridAquatic.logger = logger;
        Path path = FabricLoader.getInstance().getConfigDir().resolve("hybrid-aquatic.json");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        configFile = path;
        File file = configFile.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        configHandler = new HybridAquaticConfigHandler(file, null, 2, null);
    }
}

