/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.recipe;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2444;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import slimeknights.mantle.recipe.helper.LoggingRecipeSerializer;
import slimeknights.mantle.recipe.ingredient.SizedIngredient;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.recipe.ITinkerableContainer;
import slimeknights.tconstruct.library.recipe.RecipeResult;
import slimeknights.tconstruct.library.recipe.modifiers.adding.ModifierRecipe;
import slimeknights.tconstruct.library.recipe.worktable.AbstractSizedIngredientRecipeBuilder;
import slimeknights.tconstruct.library.recipe.worktable.AbstractWorktableRecipe;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class ModifierSortingRecipe
extends AbstractWorktableRecipe {
    private static final class_2561 TITLE = TConstruct.makeTranslation("recipe", "modifier_sorting.title");
    private static final class_2561 DESCRIPTION = TConstruct.makeTranslation("recipe", "modifier_sorting.description");
    private static final class_2561 NOT_ENOUGH_MODIFIERS = TConstruct.makeTranslation("recipe", "modifier_sorting.not_enough_modifiers");

    public ModifierSortingRecipe(class_2960 id, List<SizedIngredient> inputs) {
        super(id, inputs);
    }

    @Override
    public boolean matches(ITinkerableContainer inv, class_1937 world) {
        if (!inv.getTinkerableStack().method_31573(TinkerTags.Items.MODIFIABLE)) {
            return false;
        }
        return ModifierRecipe.checkMatch(inv, this.inputs);
    }

    @Override
    public class_2561 getTitle() {
        return TITLE;
    }

    @Override
    public class_2561 getDescription(@Nullable ITinkerableContainer inv) {
        if (inv != null && inv.getTinkerable().getUpgrades().getModifiers().size() < 2) {
            return NOT_ENOUGH_MODIFIERS;
        }
        return DESCRIPTION;
    }

    @Override
    public RecipeResult<ToolStack> getResult(ITinkerableContainer inv, ModifierEntry modifier) {
        ToolStack tool = inv.getTinkerable();
        List<ModifierEntry> upgrades = tool.getUpgrades().getModifiers();
        int toMove = IntStream.range(0, upgrades.size()).filter(i -> ((ModifierEntry)upgrades.get(i)).matches(modifier.getId())).findFirst().orElse(-1);
        if (toMove == -1) {
            return RecipeResult.pass();
        }
        tool = tool.copy();
        ArrayList<ModifierEntry> newUpgrades = new ArrayList<ModifierEntry>(upgrades);
        Collections.swap(newUpgrades, toMove, toMove == upgrades.size() - 1 ? 0 : toMove + 1);
        tool.setUpgrades(new ModifierNBT(newUpgrades));
        return RecipeResult.success(tool);
    }

    @Override
    public int toolResultSize() {
        return 64;
    }

    @Override
    public void updateInputs(IToolStackView result, ITinkerableContainer.Mutable inv, boolean isServer) {
    }

    public class_1865<?> method_8119() {
        return (class_1865)TinkerModifiers.modifierSortingSerializer.get();
    }

    public static class Builder
    extends AbstractSizedIngredientRecipeBuilder<Builder> {
        public void save(Consumer<class_2444> consumer) {
            this.save(consumer, class_7923.field_41178.method_10221((Object)((class_1799)((SizedIngredient)this.inputs.get(0)).getMatchingStacks().get(0)).method_7909()));
        }

        public void save(Consumer<class_2444> consumer, class_2960 id) {
            if (this.inputs.isEmpty()) {
                throw new IllegalStateException("Must have at least one ingredient");
            }
            class_2960 advancementId = this.buildOptionalAdvancement(id, "modifiers");
            consumer.accept((class_2444)new Finished(id, advancementId));
        }

        private Builder() {
        }

        public static Builder sorting() {
            return new Builder();
        }

        private class Finished
        extends AbstractSizedIngredientRecipeBuilder.SizedFinishedRecipe {
            public Finished(@Nullable class_2960 ID, class_2960 advancementID) {
                super(ID, advancementID);
            }

            public class_1865<?> method_17800() {
                return (class_1865)TinkerModifiers.modifierSortingSerializer.get();
            }
        }
    }

    public static class Serializer
    extends LoggingRecipeSerializer<ModifierSortingRecipe> {
        public ModifierSortingRecipe fromJson(class_2960 id, JsonObject json) {
            List ingredients = JsonHelper.parseList((JsonObject)json, (String)"inputs", SizedIngredient::deserialize);
            return new ModifierSortingRecipe(id, ingredients);
        }

        @Nullable
        public ModifierSortingRecipe fromNetworkSafe(class_2960 id, class_2540 buffer) {
            int size = buffer.method_10816();
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int i = 0; i < size; ++i) {
                builder.add((Object)SizedIngredient.read((class_2540)buffer));
            }
            return new ModifierSortingRecipe(id, (List<SizedIngredient>)builder.build());
        }

        public void toNetworkSafe(class_2540 buffer, ModifierSortingRecipe recipe) {
            buffer.method_10804(recipe.inputs.size());
            for (SizedIngredient ingredient : recipe.inputs) {
                ingredient.write(buffer);
            }
        }
    }
}

