/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.recipe;

import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_5455;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.recipe.modifiers.adding.IModifierRecipe;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationContainer;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationRecipe;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.item.CreativeSlotItem;
import slimeknights.tconstruct.tools.modifiers.slotless.CreativeSlotModifier;

public class CreativeSlotRecipe
implements ITinkerStationRecipe,
IModifierRecipe {
    private final class_2960 id;

    @Nullable
    private SlotType findSlotType(ITinkerStationContainer inv, boolean stopAfterFirst) {
        SlotType type = null;
        for (int i = 0; i < inv.getInputCount(); ++i) {
            class_1799 stack = inv.getInput(i);
            if (stack.method_7960()) continue;
            if (type != null || stack.method_7909() != TinkerModifiers.creativeSlotItem.get()) {
                return null;
            }
            type = CreativeSlotItem.getSlot(stack);
            if (type == null) {
                return null;
            }
            if (!stopAfterFirst) continue;
            return type;
        }
        return type;
    }

    @Override
    public boolean matches(ITinkerStationContainer inv, class_1937 world) {
        if (!inv.getTinkerableStack().method_31573(TinkerTags.Items.MODIFIABLE)) {
            return false;
        }
        return this.findSlotType(inv, false) != null;
    }

    @Override
    public int shrinkToolSlotBy() {
        return 64;
    }

    @Override
    public class_1799 assemble(ITinkerStationContainer inv, class_5455 registryAccess) {
        ModifierId creative;
        class_2487 slots;
        class_1799 tinkerable = inv.getTinkerableStack();
        ToolStack toolStack = ToolStack.copyFrom(tinkerable);
        ModDataNBT persistentData = toolStack.getPersistentData();
        if (persistentData.contains(CreativeSlotModifier.KEY_SLOTS, 10)) {
            slots = persistentData.getCompound(CreativeSlotModifier.KEY_SLOTS);
        } else {
            slots = new class_2487();
            persistentData.put(CreativeSlotModifier.KEY_SLOTS, (class_2520)slots);
        }
        SlotType slotType = this.findSlotType(inv, true);
        if (slotType != null) {
            String name = slotType.getName();
            slots.method_10569(name, slots.method_10550(name) + 1);
        }
        if (toolStack.getModifierLevel(creative = TinkerModifiers.creativeSlot.getId()) == 0) {
            toolStack.addModifier(creative, 1);
        } else {
            toolStack.rebuildStats();
        }
        return toolStack.createStack(tinkerable.method_7947());
    }

    @Override
    public Modifier getModifier() {
        return TinkerModifiers.creativeSlot.get();
    }

    @Deprecated
    public class_1799 method_8110(class_5455 registryAccess) {
        return class_1799.field_8037;
    }

    public class_1865<?> method_8119() {
        return (class_1865)TinkerModifiers.creativeSlotSerializer.get();
    }

    public CreativeSlotRecipe(class_2960 id) {
        this.id = id;
    }

    public class_2960 method_8114() {
        return this.id;
    }
}

