/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.upgrades.general;

import io.github.fabricators_of_create.porting_lib.entity.events.LivingDeathEvent;
import io.github.fabricators_of_create.porting_lib.entity.events.LivingEntityEvents;
import io.github.fabricators_of_create.porting_lib.event.common.BlockEvents;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.tools.capability.EntityModifierCapability;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.helper.ModifierLootingHandler;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public class ExperiencedModifier
extends Modifier {
    private static final TinkerDataCapability.TinkerDataKey<Integer> EXPERIENCED = TConstruct.createKey("experienced");

    public ExperiencedModifier() {
        LivingEntityEvents.EXPERIENCE_DROP.register(this::onExperienceDrop);
        LivingDeathEvent.DEATH.register(this::onEntityKilled);
        BlockEvents.BLOCK_BREAK.register(this::beforeBlockBreak);
    }

    private static int boost(int original, int level) {
        return (int)((double)original * (1.0 + 0.5 * (double)level));
    }

    private void beforeBlockBreak(BlockEvents.BreakEvent event) {
        int level = 0;
        ToolStack tool = ExperiencedModifier.getHeldTool((class_1309)event.getPlayer(), class_1268.field_5808);
        if (tool != null) {
            level = tool.getModifierLevel(this);
        }
        if ((tool = ExperiencedModifier.getHeldTool((class_1309)event.getPlayer(), class_1304.field_6172)) != null) {
            level += tool.getModifierLevel(this);
        }
        if (level > 0) {
            event.setExpToDrop(ExperiencedModifier.boost(event.getExpToDrop(), level));
        }
    }

    private void onEntityKilled(LivingDeathEvent event) {
        class_1676 projectile;
        ModifierNBT modifiers;
        class_1297 class_12972;
        class_1282 source = event.getSource();
        if (source != null && (class_12972 = source.method_5526()) instanceof class_1676 && !(modifiers = EntityModifierCapability.getOrEmpty((class_1297)(projectile = (class_1676)class_12972))).isEmpty()) {
            TinkerDataCapability.CAPABILITY.maybeGet((Object)event.getEntity()).ifPresent(data -> data.put(EXPERIENCED, modifiers.getLevel(this.getId())));
        }
    }

    private int onExperienceDrop(int amount, class_1657 player, class_1309 entity) {
        int experienced = TinkerDataCapability.CAPABILITY.maybeGet((Object)entity).map(data -> data.get(EXPERIENCED)).orElse(-1);
        if (experienced > 0) {
            return ExperiencedModifier.boost(amount, experienced);
        }
        if (experienced != 0 && player != null) {
            int level = 0;
            ToolStack tool = ExperiencedModifier.getHeldTool((class_1309)player, ModifierLootingHandler.getLootingSlot((class_1309)player));
            if (tool != null) {
                level = tool.getModifierLevel(this);
            }
            if ((tool = ExperiencedModifier.getHeldTool((class_1309)player, class_1304.field_6172)) != null) {
                level += tool.getModifierLevel(this);
            }
            if (level > 0) {
                return ExperiencedModifier.boost(amount, level);
            }
        }
        return amount;
    }
}

