/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.traits.skull;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_5134;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.impl.NoLevelsModifier;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.context.EquipmentChangeContext;
import slimeknights.tconstruct.library.tools.item.ModifiableArmorItem;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.utils.TooltipKey;
import slimeknights.tconstruct.library.utils.Util;
import slimeknights.tconstruct.tools.modifiers.traits.skull.ChrysophiliteModifier;

public class GoldGuardModifier
extends NoLevelsModifier {
    private static final UUID GOLD_GUARD_UUID = UUID.fromString("fbae11f1-b547-47e8-ae0c-f2cf24a46d93");
    private static final TinkerDataCapability.ComputableDataKey<GoldGuardGold> TOTAL_GOLD = TConstruct.createKey("gold_guard", GoldGuardGold::new);

    @Override
    public void onEquip(IToolStackView tool, int level, EquipmentChangeContext context) {
        if (context.getChangedSlot() == class_1304.field_6169) {
            context.getTinkerData().ifPresent(data -> {
                GoldGuardGold gold = data.get(TOTAL_GOLD);
                if (gold == null) {
                    ((GoldGuardGold)data.computeIfAbsent(TOTAL_GOLD)).initialize(context);
                } else {
                    gold.setGold(class_1304.field_6169, tool.getVolatileData().getBoolean(ModifiableArmorItem.PIGLIN_NEUTRAL), context.getEntity());
                }
            });
        }
    }

    @Override
    public void onUnequip(IToolStackView tool, int level, EquipmentChangeContext context) {
        IToolStackView newTool;
        if (context.getChangedSlot() == class_1304.field_6169 && ((newTool = context.getReplacementTool()) == null || newTool.getModifierLevel(this) == 0)) {
            context.getTinkerData().ifPresent(data -> data.remove(TOTAL_GOLD));
            class_1324 instance = context.getEntity().method_5996(class_5134.field_23716);
            if (instance != null) {
                instance.method_6200(GOLD_GUARD_UUID);
            }
        }
    }

    @Override
    public void onEquipmentChange(IToolStackView tool, int level, EquipmentChangeContext context, class_1304 slotType) {
        class_1304 changed = context.getChangedSlot();
        if (slotType == class_1304.field_6169 && changed.method_5925() == class_1304.class_1305.field_6178) {
            class_1309 living = context.getEntity();
            boolean hasGold = ChrysophiliteModifier.hasGold(context, changed);
            context.getTinkerData().ifPresent(data -> ((GoldGuardGold)data.computeIfAbsent(TOTAL_GOLD)).setGold(changed, hasGold, living));
        }
    }

    @Override
    public void addInformation(IToolStackView tool, int level, @Nullable class_1657 player, List<class_2561> tooltip, TooltipKey tooltipKey, class_1836 tooltipFlag) {
        class_1322 modifier;
        class_1324 instance;
        if (player != null && tooltipKey == TooltipKey.SHIFT && (instance = player.method_5996(class_5134.field_23716)) != null && (modifier = instance.method_6199(GOLD_GUARD_UUID)) != null) {
            tooltip.add((class_2561)this.applyStyle(class_2561.method_43470((String)(Util.BONUS_FORMAT.format(modifier.method_6186()) + " ")).method_10852((class_2561)class_2561.method_43471((String)(this.getTranslationKey() + ".health")))));
        }
    }

    private static class GoldGuardGold
    extends ChrysophiliteModifier.TotalGold {
        private GoldGuardGold() {
        }

        private void updateAttribute(class_1309 living) {
            class_1324 instance = living.method_5996(class_5134.field_23716);
            if (instance != null) {
                if (instance.method_6199(GOLD_GUARD_UUID) != null) {
                    instance.method_6200(GOLD_GUARD_UUID);
                }
                instance.method_26835(new class_1322(GOLD_GUARD_UUID, "tconstruct.gold_guard", (double)(this.getTotalGold() * 4), class_1322.class_1323.field_6328));
            }
        }

        public void setGold(class_1304 slotType, boolean value, class_1309 living) {
            if (this.setGold(slotType, value)) {
                this.updateAttribute(living);
            }
        }

        @Override
        public void initialize(EquipmentChangeContext context) {
            super.initialize(context);
            this.updateAttribute(context.getEntity());
        }
    }
}

