/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.ability.armor;

import io.github.fabricators_of_create.porting_lib.entity.events.PlayerTickEvents;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1839;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.KeybindInteractModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.GeneralInteractionModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InteractionSource;
import slimeknights.tconstruct.library.modifiers.impl.TankModifier;
import slimeknights.tconstruct.library.modifiers.spilling.SpillingFluid;
import slimeknights.tconstruct.library.modifiers.spilling.SpillingFluidManager;
import slimeknights.tconstruct.library.modifiers.util.ModifierHookMap;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.shared.particle.FluidParticleData;

public class SlurpingModifier
extends TankModifier
implements KeybindInteractModifierHook,
GeneralInteractionModifierHook {
    private static final float DEGREE_TO_RADIANS = (float)Math.PI / 180;
    private static final TinkerDataCapability.TinkerDataKey<SlurpingInfo> SLURP_FINISH_TIME = TConstruct.createKey("slurping_finish");

    public SlurpingModifier() {
        super(81000L);
        PlayerTickEvents.END.register(this::playerTick);
    }

    @Override
    public boolean startInteract(IToolStackView tool, ModifierEntry modifier, class_1657 player, class_1304 slot, TooltipKey keyModifier) {
        FluidStack fluid;
        if (!player.method_5715() && !(fluid = this.getFluid(tool)).isEmpty() && SpillingFluidManager.INSTANCE.contains(fluid.getFluid())) {
            TinkerDataCapability.CAPABILITY.maybeGet((Object)player).ifPresent(data -> data.put(SLURP_FINISH_TIME, new SlurpingInfo(fluid, player.field_6012 + 20)));
            return true;
        }
        return false;
    }

    private static void addFluidParticles(class_1657 player, FluidStack fluid, int count) {
        for (int i = 0; i < count; ++i) {
            class_243 motion = new class_243(((double)RANDOM.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
            motion = motion.method_1037(-player.method_36455() * ((float)Math.PI / 180));
            motion = motion.method_1024(-player.method_36454() * ((float)Math.PI / 180));
            class_243 position = new class_243(((double)RANDOM.nextFloat() - 0.5) * 0.3, (double)(-RANDOM.nextFloat()) * 0.6 - 0.3, 0.6);
            position = position.method_1037(-player.method_36455() * ((float)Math.PI / 180));
            position = position.method_1024(-player.method_36454() * ((float)Math.PI / 180));
            position = position.method_1031(player.method_23317(), player.method_23320(), player.method_23321());
            FluidParticleData data = new FluidParticleData((class_2396<FluidParticleData>)((class_2396)TinkerCommons.fluidParticle.get()), fluid);
            if (player.method_37908() instanceof class_3218) {
                ((class_3218)player.method_37908()).method_14199((class_2394)data, position.field_1352, position.field_1351, position.field_1350, 1, motion.field_1352, motion.field_1351 + 0.05, motion.field_1350, 0.0);
                continue;
            }
            player.method_37908().method_8406((class_2394)data, position.field_1352, position.field_1351, position.field_1350, motion.field_1352, motion.field_1351 + 0.05, motion.field_1350);
        }
    }

    private void finishDrinking(IToolStackView tool, class_1657 player, class_1268 hand) {
        SpillingFluid recipe;
        FluidStack fluid;
        if (!player.method_37908().field_9236 && !(fluid = this.getFluid(tool)).isEmpty() && (recipe = SpillingFluidManager.INSTANCE.find(fluid.getFluid())).hasEffects()) {
            ToolAttackContext context = new ToolAttackContext((class_1309)player, player, hand, (class_1297)player, (class_1309)player, false, 1.0f, false);
            FluidStack remaining = recipe.applyEffects(fluid, tool.getModifierLevel(this), context);
            if (!player.method_7337()) {
                this.setFluid(tool, remaining);
            }
        }
    }

    private void playerTick(class_1657 player) {
        if (player.method_7325()) {
            return;
        }
        TinkerDataCapability.CAPABILITY.maybeGet((Object)player).ifPresent(data -> {
            SlurpingInfo info = data.get(SLURP_FINISH_TIME);
            if (info != null) {
                int timeLeft = info.finishTime - player.field_6012;
                if (timeLeft < 0) {
                    player.method_5783(class_3417.field_20613, 0.5f, RANDOM.nextFloat() * 0.1f + 0.9f);
                    SlurpingModifier.addFluidParticles(player, info.fluid, 16);
                    ToolStack tool = ToolStack.from(player.method_6118(class_1304.field_6169));
                    this.finishDrinking(tool, player, class_1268.field_5808);
                    data.remove(SLURP_FINISH_TIME);
                } else if (timeLeft % 4 == 0) {
                    player.method_5783(class_3417.field_20613, 0.5f, RANDOM.nextFloat() * 0.1f + 0.9f);
                    SlurpingModifier.addFluidParticles(player, info.fluid, 5);
                }
            }
        });
    }

    @Override
    public void stopInteract(IToolStackView tool, ModifierEntry modifier, class_1657 player, class_1304 slot) {
        TinkerDataCapability.CAPABILITY.maybeGet((Object)player).ifPresent(data -> data.remove(SLURP_FINISH_TIME));
    }

    @Override
    public class_1269 onToolUse(IToolStackView tool, ModifierEntry modifier, class_1657 player, class_1268 hand, InteractionSource source) {
        FluidStack fluid;
        if (source == InteractionSource.RIGHT_CLICK && !(fluid = this.getFluid(tool)).isEmpty() && SpillingFluidManager.INSTANCE.contains(fluid.getFluid())) {
            ModifierUtil.startUsingItem(tool, modifier.getId(), (class_1309)player, hand);
            return class_1269.field_21466;
        }
        return class_1269.field_5811;
    }

    @Override
    public int getUseDuration(IToolStackView tool, ModifierEntry modifier) {
        return 21;
    }

    @Override
    public class_1839 getUseAction(IToolStackView tool, ModifierEntry modifier) {
        return class_1839.field_8946;
    }

    @Override
    public void onUsingTick(IToolStackView tool, ModifierEntry modifier, class_1309 entity, int timeLeft) {
        if (timeLeft % 4 == 0 && entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            FluidStack fluidStack = this.getFluid(tool);
            if (!fluidStack.isEmpty()) {
                SlurpingModifier.addFluidParticles(player, fluidStack, 5);
            }
        }
    }

    @Override
    public boolean onFinishUsing(IToolStackView tool, ModifierEntry modifier, class_1309 entity) {
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            this.finishDrinking(tool, player, entity.method_6058());
        }
        return true;
    }

    @Override
    protected void registerHooks(ModifierHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addHook(this, TinkerHooks.ARMOR_INTERACT, TinkerHooks.CHARGEABLE_INTERACT);
    }

    private record SlurpingInfo(FluidStack fluid, int finishTime) {
    }
}

