/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.client.inventory;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1723;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.client.modifiers.ModifierIconManager;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.ModifierManager;
import slimeknights.tconstruct.library.recipe.partbuilder.Pattern;
import slimeknights.tconstruct.library.recipe.worktable.IModifierWorktableRecipe;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.tables.block.entity.table.ModifierWorktableBlockEntity;
import slimeknights.tconstruct.tables.client.inventory.BaseTabbedScreen;
import slimeknights.tconstruct.tables.client.inventory.TinkerStationScreen;
import slimeknights.tconstruct.tables.client.inventory.module.InfoPanelScreen;
import slimeknights.tconstruct.tables.menu.ModifierWorktableContainerMenu;
import slimeknights.tconstruct.tools.item.ModifierCrystalItem;

public class ModifierWorktableScreen
extends BaseTabbedScreen<ModifierWorktableBlockEntity, ModifierWorktableContainerMenu> {
    protected static final class_2561 TITLE = TConstruct.makeTranslation("gui", "modifier_worktable.title");
    protected static final class_2561 TABLE_INFO = TConstruct.makeTranslation("gui", "modifier_worktable.info");
    private static final class_2960 BACKGROUND = TConstruct.getResource("textures/gui/modifier_worktable.png");
    private static final Pattern[] INPUT_PATTERNS = new Pattern[]{new Pattern("tconstruct", "pickaxe"), new Pattern("tconstruct", "ingot"), new Pattern("tconstruct", "quartz")};
    protected InfoPanelScreen tinkerInfo;
    protected InfoPanelScreen modifierInfo;
    private float sliderProgress = 0.0f;
    private boolean clickedOnScrollBar;
    private int modifierIndexOffset = 0;

    public ModifierWorktableScreen(ModifierWorktableContainerMenu container, class_1661 playerInventory, class_2561 title) {
        super(container, playerInventory, title);
        this.tinkerInfo = new InfoPanelScreen(this, (class_1703)container, playerInventory, title);
        this.tinkerInfo.setTextScale(0.8888889f);
        this.addModule(this.tinkerInfo);
        this.modifierInfo = new InfoPanelScreen(this, (class_1703)container, playerInventory, title);
        this.modifierInfo.setTextScale(0.7777778f);
        this.addModule(this.modifierInfo);
        this.tinkerInfo.yOffset = 0;
        this.modifierInfo.yOffset = this.tinkerInfo.field_2779 + 4;
        this.addChestSideInventory(playerInventory);
    }

    protected void method_2389(class_332 graphics, float partialTicks, int mouseX, int mouseY) {
        this.drawBackground(graphics, BACKGROUND);
        graphics.method_25302(BACKGROUND, this.cornerX + 103, this.cornerY + 15 + (int)(41.0f * this.sliderProgress), 176 + (this.canScroll() ? 0 : 12), 0, 12, 15);
        this.drawModifierBackgrounds(graphics, BACKGROUND, mouseX, mouseY, this.cornerX + 28, this.cornerY + 15);
        List<class_1735> slots = ((ModifierWorktableContainerMenu)this.getMenu()).getInputSlots();
        int max = Math.min(slots.size(), INPUT_PATTERNS.length);
        RenderSystem.setShaderTexture((int)0, (class_2960)class_1723.field_21668);
        for (int i = 0; i < max; ++i) {
            this.drawIconEmpty(graphics, slots.get(i), INPUT_PATTERNS[i]);
        }
        this.drawModifierIcons(graphics, this.cornerX + 28, this.cornerY + 15);
        super.method_2389(graphics, partialTicks, mouseX, mouseY);
    }

    private int getButtonAt(int mouseX, int mouseY) {
        List<ModifierEntry> buttons;
        if (this.tile != null && !(buttons = ((ModifierWorktableBlockEntity)this.tile).getCurrentButtons()).isEmpty()) {
            int x = this.cornerX + 28;
            int y = this.cornerY + 15;
            int maxIndex = Math.min(this.modifierIndexOffset + 12, buttons.size());
            for (int l = this.modifierIndexOffset; l < maxIndex; ++l) {
                int relative = l - this.modifierIndexOffset;
                double buttonX = (double)mouseX - (double)(x + relative % 4 * 18);
                double buttonY = (double)mouseY - (double)(y + relative / 4 * 18);
                if (!(buttonX >= 0.0) || !(buttonY >= 0.0) || !(buttonX < 18.0) || !(buttonY < 18.0)) continue;
                return l;
            }
        }
        return -1;
    }

    protected void method_2380(class_332 graphics, int mouseX, int mouseY) {
        int index;
        List<ModifierEntry> buttons;
        super.method_2380(graphics, mouseX, mouseY);
        if (this.tile != null && !(buttons = ((ModifierWorktableBlockEntity)this.tile).getCurrentButtons()).isEmpty() && (index = this.getButtonAt(mouseX, mouseY)) >= 0) {
            ModifierEntry modifier = buttons.get(index);
            graphics.method_51438(this.field_22793, modifier.getModifier().getDisplayName(modifier.getLevel()), mouseX, mouseY);
        }
    }

    private void drawModifierBackgrounds(class_332 graphics, class_2960 texture, int mouseX, int mouseY, int left, int top) {
        if (this.tile != null) {
            int selectedIndex = ((ModifierWorktableBlockEntity)this.tile).getSelectedIndex();
            int max = Math.min(this.modifierIndexOffset + 12, this.getPartRecipeCount());
            for (int i = this.modifierIndexOffset; i < max; ++i) {
                int relative = i - this.modifierIndexOffset;
                int x = left + relative % 4 * 18;
                int y = top + relative / 4 * 18;
                int u = this.field_2779;
                if (i == selectedIndex) {
                    u += 18;
                } else if (mouseX >= x && mouseY >= y && mouseX < x + 18 && mouseY < y + 18) {
                    u += 36;
                }
                graphics.method_25302(texture, x, y, 0, u, 18, 18);
            }
        }
    }

    private void drawModifierIcons(class_332 graphics, int left, int top) {
        if (this.tile != null) {
            assert (this.field_22787 != null);
            RenderSystem.setShaderTexture((int)0, (class_2960)class_1723.field_21668);
            List<ModifierEntry> list = ((ModifierWorktableBlockEntity)this.tile).getCurrentButtons();
            int max = Math.min(this.modifierIndexOffset + 12, this.getPartRecipeCount());
            for (int i = this.modifierIndexOffset; i < max; ++i) {
                int relative = i - this.modifierIndexOffset;
                int x = left + relative % 4 * 18 + 1;
                int y = top + relative / 4 * 18 + 1;
                ModifierIconManager.renderIcon(graphics, list.get(i).getModifier(), x, y, 100, 16);
            }
        }
    }

    @Override
    public void updateDisplay() {
        if (!this.canScroll()) {
            this.sliderProgress = 0.0f;
            this.modifierIndexOffset = 0;
        }
        if (this.tile != null) {
            class_2561 message = ((ModifierWorktableBlockEntity)this.tile).getCurrentMessage();
            if (!message.getString().isEmpty()) {
                this.message(message);
                return;
            }
            ToolStack result = ((ModifierWorktableBlockEntity)this.tile).getResult();
            if (result == null) {
                this.message(TABLE_INFO);
                return;
            }
            class_1799 resultStack = ((ModifierWorktableContainerMenu)this.getMenu()).getOutputSlot().method_7677();
            TinkerStationScreen.updateToolPanel(this.tinkerInfo, result, resultStack);
            this.modifierInfo.setCaption((class_2561)class_2561.method_43473());
            this.modifierInfo.setText(new class_2561[]{class_2561.method_43473()});
            if (result.hasTag(TinkerTags.Items.MODIFIABLE)) {
                TinkerStationScreen.updateModifierPanel(this.modifierInfo, result);
            } else {
                ModifierId modifierId = ModifierCrystalItem.getModifier(resultStack);
                if (modifierId != null) {
                    Modifier modifier = ModifierManager.getValue(modifierId);
                    this.modifierInfo.setCaption((class_2561)TConstruct.makeTranslation("gui", "tinker_station.modifiers"));
                    this.modifierInfo.setText(Collections.singletonList(modifier.getDisplayName()), Collections.singletonList(modifier.getDescription()));
                }
            }
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int mouseButton) {
        this.clickedOnScrollBar = false;
        if (this.tinkerInfo.handleMouseClicked(mouseX, mouseY, mouseButton) || this.modifierInfo.handleMouseClicked(mouseX, mouseY, mouseButton)) {
            return false;
        }
        if (this.tile != null && !((ModifierWorktableBlockEntity)this.tile).getCurrentButtons().isEmpty()) {
            int index = this.getButtonAt((int)mouseX, (int)mouseY);
            assert (this.field_22787 != null && this.field_22787.field_1724 != null);
            if (index >= 0 && ((ModifierWorktableContainerMenu)this.getMenu()).method_7604((class_1657)this.field_22787.field_1724, index)) {
                this.field_22787.method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_17711, (float)1.0f));
                assert (this.field_22787.field_1761 != null);
                this.field_22787.field_1761.method_2900(((ModifierWorktableContainerMenu)this.getMenu()).field_7763, index);
                return true;
            }
            int x = this.cornerX + 103;
            int y = this.cornerY + 15;
            if (mouseX >= (double)x && mouseX < (double)(x + 12) && mouseY >= (double)y && mouseY < (double)(y + 54)) {
                this.clickedOnScrollBar = true;
            }
        }
        return super.method_25402(mouseX, mouseY, mouseButton);
    }

    public boolean method_25403(double mouseX, double mouseY, int clickedMouseButton, double timeSinceLastClick, double unknown) {
        if (this.tinkerInfo.handleMouseClickMove(mouseX, mouseY, clickedMouseButton, timeSinceLastClick) || this.modifierInfo.handleMouseClickMove(mouseX, mouseY, clickedMouseButton, timeSinceLastClick)) {
            return false;
        }
        if (this.clickedOnScrollBar && this.canScroll()) {
            int i = this.cornerY + 14;
            int j = i + 54;
            this.sliderProgress = ((float)mouseY - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
            this.sliderProgress = class_3532.method_15363((float)this.sliderProgress, (float)0.0f, (float)1.0f);
            this.modifierIndexOffset = (int)((double)(this.sliderProgress * (float)this.getHiddenRows()) + 0.5) * 4;
            return true;
        }
        return super.method_25403(mouseX, mouseY, clickedMouseButton, timeSinceLastClick, unknown);
    }

    public boolean method_25401(double mouseX, double mouseY, double delta) {
        if (this.tinkerInfo.handleMouseScrolled(mouseX, mouseY, delta) || this.modifierInfo.handleMouseScrolled(mouseX, mouseY, delta)) {
            return false;
        }
        if (super.method_25401(mouseX, mouseY, delta)) {
            return true;
        }
        if (this.canScroll()) {
            int i = this.getHiddenRows();
            this.sliderProgress = class_3532.method_15363((float)((float)((double)this.sliderProgress - delta / (double)i)), (float)0.0f, (float)1.0f);
            this.modifierIndexOffset = (int)(this.sliderProgress * (float)i + 0.5f) * 4;
            return true;
        }
        return false;
    }

    public boolean method_25406(double mouseX, double mouseY, int state) {
        if (this.tinkerInfo.handleMouseReleased(mouseX, mouseY, state) || this.modifierInfo.handleMouseReleased(mouseX, mouseY, state)) {
            return false;
        }
        return super.method_25406(mouseX, mouseY, state);
    }

    @Override
    public void error(class_2561 message) {
        this.tinkerInfo.setCaption(COMPONENT_ERROR);
        this.tinkerInfo.setText(message);
        this.modifierInfo.setCaption((class_2561)class_2561.method_43473());
        this.modifierInfo.setText(new class_2561[]{class_2561.method_43473()});
    }

    @Override
    public void warning(class_2561 message) {
        this.tinkerInfo.setCaption(COMPONENT_WARNING);
        this.tinkerInfo.setText(message);
        this.modifierInfo.setCaption((class_2561)class_2561.method_43473());
        this.modifierInfo.setText(new class_2561[]{class_2561.method_43473()});
    }

    private class_2561 getInfoTitle() {
        IModifierWorktableRecipe recipe;
        if (this.tile != null && (recipe = ((ModifierWorktableBlockEntity)this.tile).getCurrentRecipe()) != null) {
            return recipe.getTitle();
        }
        return TITLE;
    }

    public void message(class_2561 message) {
        this.tinkerInfo.setCaption(this.getInfoTitle());
        this.tinkerInfo.setText(message);
        this.modifierInfo.setCaption((class_2561)class_2561.method_43473());
        this.modifierInfo.setText(new class_2561[]{class_2561.method_43473()});
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (TinkerStationScreen.needsDisplayUpdate(keyCode)) {
            this.updateDisplay();
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        if (TinkerStationScreen.needsDisplayUpdate(keyCode)) {
            this.updateDisplay();
        }
        return super.method_16803(keyCode, scanCode, modifiers);
    }

    private int getPartRecipeCount() {
        return this.tile == null ? 0 : ((ModifierWorktableBlockEntity)this.tile).getCurrentButtons().size();
    }

    private boolean canScroll() {
        return this.getPartRecipeCount() > 12;
    }

    private int getHiddenRows() {
        return (this.getPartRecipeCount() + 4 - 1) / 4 - 3;
    }
}

