/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.item;

import io.github.fabricators_of_create.porting_lib.transfer.fluid.FluidTank;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1799;
import slimeknights.tconstruct.smeltery.block.entity.component.TankBlockEntity;
import slimeknights.tconstruct.smeltery.item.TankItem;

public class TankItemFluidHandler
implements SingleSlotStorage<FluidVariant> {
    private final ContainerItemContext container;

    private FluidTank getTank() {
        return TankItem.getFluidTank(this.container.getItemVariant().toStack());
    }

    private void updateContainer(FluidTank tank, TransactionContext tx) {
        class_1799 newStack = this.container.getItemVariant().toStack();
        TankItem.setTank(newStack, tank);
        this.container.exchange(ItemVariant.of((class_1799)newStack), 1L, tx);
    }

    public long getCapacity() {
        return TankBlockEntity.getCapacity(this.container.getItemVariant().getItem());
    }

    public long insert(FluidVariant resource, long maxAmount, TransactionContext transaction) {
        FluidTank tank = this.getTank();
        long didFill = tank.insert(resource, maxAmount, transaction);
        if (didFill > 0L) {
            this.updateContainer(tank, transaction);
        }
        return didFill;
    }

    public long extract(FluidVariant resource, long maxAmount, TransactionContext transaction) {
        FluidTank tank = this.getTank();
        long didDrain = tank.extract(resource, maxAmount, transaction);
        if (didDrain > 0L) {
            this.updateContainer(tank, transaction);
        }
        return didDrain;
    }

    public boolean isResourceBlank() {
        return this.getResource().isBlank();
    }

    public FluidVariant getResource() {
        return (FluidVariant)this.getTank().getResource();
    }

    public long getAmount() {
        return this.getTank().getAmount();
    }

    public TankItemFluidHandler(ContainerItemContext container) {
        this.container = container;
    }

    public ContainerItemContext getContainer() {
        return this.container;
    }
}

