/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.client.screen;

import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.SlottedStorage;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_465;
import slimeknights.mantle.client.screen.ElementScreen;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.GuiUtil;
import slimeknights.tconstruct.library.client.RenderUtils;
import slimeknights.tconstruct.smeltery.block.entity.controller.AlloyerBlockEntity;
import slimeknights.tconstruct.smeltery.block.entity.module.FuelModule;
import slimeknights.tconstruct.smeltery.block.entity.module.alloying.MixerAlloyTank;
import slimeknights.tconstruct.smeltery.client.screen.IScreenWithFluidTank;
import slimeknights.tconstruct.smeltery.client.screen.module.GuiFuelModule;
import slimeknights.tconstruct.smeltery.client.screen.module.GuiTankModule;
import slimeknights.tconstruct.smeltery.menu.AlloyerContainerMenu;

public class AlloyerScreen
extends class_465<AlloyerContainerMenu>
implements IScreenWithFluidTank {
    private static final int[] INPUT_TANK_START_X = new int[]{54, 22, 38, 70, 6};
    private static final class_2960 BACKGROUND = TConstruct.getResource("textures/gui/alloyer.png");
    private static final ElementScreen SCALA = new ElementScreen(176, 0, 34, 52, 256, 256);
    private static final ElementScreen FUEL_SLOT = new ElementScreen(176, 52, 18, 36, 256, 256);
    private static final ElementScreen FUEL_TANK = new ElementScreen(194, 52, 14, 38, 256, 256);
    private static final ElementScreen INPUT_TANK = new ElementScreen(208, 52, 16, 54, 256, 256);
    private final GuiFuelModule fuel;
    private final GuiTankModule outputTank;
    private GuiTankModule[] inputTanks = new GuiTankModule[0];

    public AlloyerScreen(AlloyerContainerMenu container, class_1661 inv, class_2561 name) {
        super((class_1703)container, inv, name);
        AlloyerBlockEntity te = (AlloyerBlockEntity)container.getTile();
        if (te != null) {
            FuelModule fuelModule = te.getFuelModule();
            this.fuel = new GuiFuelModule(this, fuelModule, 153, 32, 12, 36, 152, 15, container.isHasFuelSlot());
            this.outputTank = new GuiTankModule(this, (SlottedStorage<FluidVariant>)te.getTank(), 114, 16, 34, 52, AlloyerContainerMenu.TOOLTIP_FORMAT);
            this.updateTanks();
        } else {
            this.fuel = null;
            this.outputTank = null;
        }
    }

    private void updateTanks() {
        AlloyerBlockEntity te = (AlloyerBlockEntity)((AlloyerContainerMenu)this.field_2797).getTile();
        if (te != null) {
            MixerAlloyTank alloyTank = te.getAlloyTank();
            int numTanks = alloyTank.getTanks();
            GuiTankModule[] tanks = new GuiTankModule[numTanks];
            int max = Math.min(numTanks, 5);
            for (int i = 0; i < max; ++i) {
                tanks[i] = new GuiTankModule(this, alloyTank.getFluidHandler(i), INPUT_TANK_START_X[i], 16, 14, 52, AlloyerContainerMenu.TOOLTIP_FORMAT);
            }
            this.inputTanks = tanks;
        }
    }

    protected void method_37432() {
        super.method_37432();
        AlloyerBlockEntity te = (AlloyerBlockEntity)((AlloyerContainerMenu)this.field_2797).getTile();
        if (te != null && te.getAlloyTank().getTanks() != this.inputTanks.length) {
            this.updateTanks();
        }
    }

    public void method_25394(class_332 graphics, int x, int y, float partialTicks) {
        this.method_25420(graphics);
        super.method_25394(graphics, x, y, partialTicks);
        this.method_2380(graphics, x, y);
    }

    protected void method_2389(class_332 graphics, float partialTicks, int mouseX, int mouseY) {
        GuiUtil.drawBackground(graphics, this, BACKGROUND);
        if (this.outputTank != null) {
            this.outputTank.draw(graphics);
        }
        RenderUtils.setup(BACKGROUND);
        for (GuiTankModule tankModule : this.inputTanks) {
            INPUT_TANK.draw(graphics, BACKGROUND, tankModule.getX() - 1 + this.field_2776, tankModule.getY() - 1 + this.field_2800);
        }
        if (this.fuel != null) {
            if (((AlloyerContainerMenu)this.field_2797).isHasFuelSlot()) {
                FUEL_SLOT.draw(graphics, BACKGROUND, this.field_2776 + 150, this.field_2800 + 31);
            } else {
                FUEL_TANK.draw(graphics, BACKGROUND, this.field_2776 + 152, this.field_2800 + 31);
            }
            this.fuel.draw(graphics, BACKGROUND);
        }
        for (GuiTankModule tankModule : this.inputTanks) {
            tankModule.draw(graphics);
        }
    }

    protected void method_2388(class_332 graphics, int mouseX, int mouseY) {
        GuiUtil.drawContainerNames(graphics, this, this.field_22793, this.field_29347);
        int checkX = mouseX - this.field_2776;
        int checkY = mouseY - this.field_2800;
        if (this.outputTank != null) {
            this.outputTank.highlightHoveredFluid(graphics, checkX, checkY);
        }
        for (GuiTankModule tankModule : this.inputTanks) {
            tankModule.highlightHoveredFluid(graphics, checkX, checkY);
        }
        if (this.fuel != null) {
            this.fuel.renderHighlight(graphics, checkX, checkY);
        }
        assert (this.field_22787 != null);
        RenderUtils.setup(BACKGROUND);
        SCALA.draw(graphics, BACKGROUND, 114, 16);
    }

    protected void method_2380(class_332 graphics, int mouseX, int mouseY) {
        super.method_2380(graphics, mouseX, mouseY);
        if (this.outputTank != null) {
            this.outputTank.renderTooltip(graphics, mouseX, mouseY);
        }
        for (GuiTankModule tankModule : this.inputTanks) {
            tankModule.renderTooltip(graphics, mouseX, mouseY);
        }
        if (this.fuel != null) {
            this.fuel.addTooltip(graphics, mouseX, mouseY, true);
        }
    }

    @Override
    @Nullable
    public Object getIngredientUnderMouse(double mouseX, double mouseY) {
        FluidStack ingredient = null;
        int checkX = (int)mouseX - this.field_2776;
        int checkY = (int)mouseY - this.field_2800;
        if (this.fuel != null) {
            ingredient = this.fuel.getIngredient(checkX, checkY);
        }
        if (this.outputTank != null && ingredient == null) {
            ingredient = this.outputTank.getIngreientUnderMouse(checkX, checkY);
        }
        if (ingredient == null) {
            for (GuiTankModule tankModule : this.inputTanks) {
                ingredient = tankModule.getIngreientUnderMouse(checkX, checkY);
                if (ingredient == null) continue;
                return ingredient;
            }
        }
        return ingredient;
    }
}

