/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.block.entity.module.alloying;

import io.github.fabricators_of_create.porting_lib.common.util.NonNullConsumer;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.SlottedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import slimeknights.mantle.block.entity.MantleBlockEntity;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.recipe.alloying.IMutableAlloyTank;
import slimeknights.tconstruct.smeltery.block.entity.tank.EmptyFluidStorage;

public class MixerAlloyTank
implements IMutableAlloyTank {
    private final MantleBlockEntity parent;
    private final SlottedStorage<FluidVariant> outputTank;
    private int temperature = 0;
    private final Map<class_2350, SlottedStorage<FluidVariant>> inputs = new EnumMap<class_2350, SlottedStorage<FluidVariant>>(class_2350.class);
    private final Map<class_2350, NonNullConsumer<SlottedStorage<FluidVariant>>> listeners = new EnumMap<class_2350, NonNullConsumer<SlottedStorage<FluidVariant>>>(class_2350.class);
    @Nullable
    private SlottedStorage<FluidVariant>[] indexedList = null;
    private boolean needsRefresh = true;
    private int currentTanks = 0;

    @Override
    public int getTanks() {
        this.checkTanks();
        return this.currentTanks;
    }

    private SlottedStorage<FluidVariant>[] indexTanks() {
        if (this.indexedList == null) {
            this.indexedList = new SlottedStorage[this.currentTanks];
            if (this.currentTanks > 0) {
                int nextTank = 0;
                for (class_2350 direction : class_2350.values()) {
                    SlottedStorage handler;
                    if (direction == class_2350.field_11033 || (handler = (SlottedStorage)this.inputs.getOrDefault(direction, null)) == null) continue;
                    this.indexedList[nextTank] = handler;
                    ++nextTank;
                }
            }
        }
        return this.indexedList;
    }

    public SlottedStorage<FluidVariant> getFluidHandler(int tank) {
        this.checkTanks();
        if (tank >= this.currentTanks || tank < 0) {
            return EmptyFluidStorage.INSTANCE;
        }
        return this.indexTanks()[tank];
    }

    @Override
    public FluidStack getFluidInTank(int tank) {
        this.checkTanks();
        if (tank >= this.currentTanks || tank < 0) {
            return FluidStack.EMPTY;
        }
        return new FluidStack((StorageView)this.indexTanks()[tank].getSlot(0));
    }

    @Override
    public FluidStack drain(int tank, FluidStack fluidStack) {
        this.checkTanks();
        if (tank >= this.currentTanks || tank < 0) {
            return FluidStack.EMPTY;
        }
        return new FluidStack(fluidStack.getType(), TransferUtil.extractFluid(this.indexTanks()[tank], (FluidStack)fluidStack));
    }

    @Override
    public boolean canFit(FluidStack fluid, int removed) {
        this.checkTanks();
        return StorageUtil.simulateInsert(this.outputTank, (Object)fluid.getType(), (long)fluid.getAmount(), null) == fluid.getAmount();
    }

    @Override
    public long fill(FluidStack fluidStack) {
        return TransferUtil.insertFluid(this.outputTank, (FluidStack)fluidStack);
    }

    private void checkTanks() {
        class_1937 world = this.parent.method_10997();
        if (world == null) {
            return;
        }
        if (this.needsRefresh) {
            for (class_2350 direction : class_2350.values()) {
                class_2338 target;
                if (direction == class_2350.field_11033 || this.inputs.containsKey(direction) || !world.method_8320(target = this.parent.method_11016().method_10093(direction)).method_26164(TinkerTags.Blocks.ALLOYER_TANKS)) continue;
                Storage capability = (Storage)FluidStorage.SIDED.find(world, target, (Object)direction.method_10153());
                if (capability != null && capability instanceof SlottedStorage) {
                    SlottedStorage storage = (SlottedStorage)capability;
                    this.inputs.put(direction, (SlottedStorage<FluidVariant>)storage);
                    ++this.currentTanks;
                    continue;
                }
                this.inputs.put(direction, null);
            }
            this.needsRefresh = false;
        }
    }

    public void refresh(class_2350 direction, boolean checkInput) {
        if (direction == class_2350.field_11033) {
            return;
        }
        if (!checkInput || this.inputs.containsKey(direction) && this.inputs.get(direction) != null) {
            --this.currentTanks;
        }
        this.inputs.remove(direction);
        this.needsRefresh = true;
        this.indexedList = null;
    }

    public MixerAlloyTank(MantleBlockEntity parent, SlottedStorage<FluidVariant> outputTank) {
        this.parent = parent;
        this.outputTank = outputTank;
    }

    @Override
    public int getTemperature() {
        return this.temperature;
    }

    public void setTemperature(int temperature) {
        this.temperature = temperature;
    }
}

