/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.block.entity.controller;

import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import slimeknights.mantle.block.entity.MantleBlockEntity;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.block.controller.ControllerBlock;
import slimeknights.tconstruct.smeltery.block.entity.controller.HeatingStructureBlockEntity;
import slimeknights.tconstruct.smeltery.block.entity.module.MeltingModuleInventory;
import slimeknights.tconstruct.smeltery.block.entity.module.alloying.MultiAlloyingModule;
import slimeknights.tconstruct.smeltery.block.entity.module.alloying.SmelteryAlloyTank;
import slimeknights.tconstruct.smeltery.block.entity.multiblock.HeatingStructureMultiblock;
import slimeknights.tconstruct.smeltery.block.entity.multiblock.SmelteryMultiblock;
import slimeknights.tconstruct.smeltery.block.entity.tank.ISmelteryTankHandler;

public class SmelteryBlockEntity
extends HeatingStructureBlockEntity {
    private static final long CAPACITY_PER_BLOCK = 108000L;
    private static final int BLOCKS_PER_FUEL = 15;
    private static final class_2561 NAME = TConstruct.makeTranslation("gui", "smeltery");
    private final SmelteryAlloyTank alloyTank;
    private final MultiAlloyingModule alloyingModule;

    public SmelteryBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591<? extends HeatingStructureBlockEntity>)((class_2591)TinkerSmeltery.smeltery.get()), pos, state, NAME);
        this.alloyTank = new SmelteryAlloyTank(this.tank);
        this.alloyingModule = new MultiAlloyingModule((MantleBlockEntity)this, this.alloyTank);
    }

    @Override
    protected HeatingStructureMultiblock<?> createMultiblock() {
        return new SmelteryMultiblock(this);
    }

    @Override
    protected MeltingModuleInventory createMeltingInventory() {
        return new MeltingModuleInventory((MantleBlockEntity)this, this.tank, Config.COMMON.smelteryOreRate);
    }

    @Override
    protected boolean isDebugItem(class_1799 stack) {
        return stack.method_31573(TinkerTags.Items.SMELTERY_DEBUG);
    }

    @Override
    protected void heat() {
        if (this.structure == null || this.field_11863 == null) {
            return;
        }
        if (this.structure.hasTanks()) {
            boolean entityMelted = false;
            if (this.tick == 12) {
                entityMelted = this.entityModule.interactWithEntities();
            }
            switch (this.tick % 4) {
                case 0: {
                    if (this.fuelModule.hasFuel()) break;
                    if (entityMelted) {
                        this.fuelModule.findFuel(true);
                        break;
                    }
                    int possibleTemp = this.fuelModule.findFuel(false);
                    this.alloyTank.setTemperature(possibleTemp);
                    if (!this.meltingInventory.canHeat(possibleTemp) && !this.alloyingModule.canAlloy()) break;
                    this.fuelModule.findFuel(true);
                    break;
                }
                case 1: {
                    if (this.fuelModule.hasFuel()) {
                        this.meltingInventory.heatItems(this.fuelModule.getTemperature());
                        break;
                    }
                    this.meltingInventory.coolItems();
                    break;
                }
                case 2: {
                    if (!this.fuelModule.hasFuel()) break;
                    this.alloyTank.setTemperature(this.fuelModule.getTemperature());
                    this.alloyingModule.doAlloy();
                    break;
                }
                case 3: {
                    boolean hasFuel = this.fuelModule.hasFuel();
                    class_2680 state = this.method_11010();
                    if ((Boolean)state.method_11654((class_2769)ControllerBlock.ACTIVE) != hasFuel) {
                        this.field_11863.method_8501(this.field_11867, (class_2680)state.method_11657((class_2769)ControllerBlock.ACTIVE, (Comparable)Boolean.valueOf(hasFuel)));
                    }
                    this.fuelModule.decreaseFuel(this.fuelRate);
                    break;
                }
            }
        }
    }

    @Override
    protected void setStructure(@Nullable HeatingStructureMultiblock.StructureData structure) {
        super.setStructure(structure);
        if (structure != null) {
            int dx = structure.getInnerX();
            int dy = structure.getInnerY();
            int dz = structure.getInnerZ();
            int size = dx * dy * dz;
            this.tank.setCapacity(108000L * (long)size);
            this.meltingInventory.resize(size, this.dropItem);
            this.fuelRate = (1 + (2 * (dx * dy) + 2 * (dy * dz) + dx * dz) / 15) * 810;
        }
    }

    @Override
    public void notifyFluidsChanged(ISmelteryTankHandler.FluidChange type, FluidStack fluid) {
        super.notifyFluidsChanged(type, fluid);
        if (type == ISmelteryTankHandler.FluidChange.ADDED) {
            this.alloyingModule.clearCachedRecipes();
        }
    }

    public MultiAlloyingModule getAlloyingModule() {
        return this.alloyingModule;
    }
}

