/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.rei.entity;

import dev.architectury.fluid.FluidStack;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.awt.Color;
import java.util.Collection;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.entry.renderer.EntryRenderer;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.util.ClientEntryStacks;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.EntryType;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.class_124;
import net.minecraft.class_1299;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import slimeknights.mantle.fluid.tooltip.FluidTooltipHandler;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.plugin.jei.melting.MeltingFuelHandler;
import slimeknights.tconstruct.plugin.rei.IRecipeTooltipReplacement;
import slimeknights.tconstruct.plugin.rei.TConstructREIConstants;
import slimeknights.tconstruct.plugin.rei.TinkersCategory;
import slimeknights.tconstruct.plugin.rei.entity.EntityEntryDefinition;
import slimeknights.tconstruct.plugin.rei.entity.EntityEntryRenderer;
import slimeknights.tconstruct.plugin.rei.entity.EntityMeltingRecipeDisplay;
import slimeknights.tconstruct.plugin.rei.widgets.ArrowWidget;
import slimeknights.tconstruct.plugin.rei.widgets.WidgetHolder;

public class EntityMeltingRecipeCategory
implements TinkersCategory<EntityMeltingRecipeDisplay> {
    public static final class_2960 BACKGROUND_LOC = TConstruct.getResource("textures/gui/jei/melting.png");
    private static final class_2561 TITLE = TConstruct.makeTranslation("jei", "entity_melting.title");
    private static final String KEY_PER_HEARTS = TConstruct.makeTranslationKey("jei", "entity_melting.per_hearts");
    private static final class_2561 TOOLTIP_PER_HEART = class_2561.method_43471((String)TConstruct.makeTranslationKey("jei", "entity_melting.per_heart")).method_27692(class_124.field_1080);
    private static final Int2ObjectMap<IRecipeTooltipReplacement> TOOLTIP_MAP = new Int2ObjectOpenHashMap();
    private final EntityEntryRenderer entityRenderer = new EntityEntryRenderer(32);
    private final WidgetHolder background = new WidgetHolder(BACKGROUND_LOC, 0, 41, 150, 62);
    private final WidgetHolder icon = new WidgetHolder(BACKGROUND_LOC, 174, 41, 16, 16);
    private final WidgetHolder tank = new WidgetHolder(BACKGROUND_LOC, 150, 74, 16, 16);

    public Renderer getIcon() {
        return new Renderer(){

            public void render(class_332 graphics, Rectangle bounds, int mouseX, int mouseY, float delta) {
                EntityMeltingRecipeCategory.this.icon.build(0, 0, bounds.getLocation()).render(graphics, bounds, mouseX, mouseY, delta);
            }
        };
    }

    public CategoryIdentifier<EntityMeltingRecipeDisplay> getCategoryIdentifier() {
        return TConstructREIConstants.ENTITY_MELTING;
    }

    public class_2561 getTitle() {
        return TITLE;
    }

    @Override
    public void draw(EntityMeltingRecipeDisplay display, class_332 graphics, double mouseX, double mouseY) {
        String damage = Float.toString((float)display.getDamage() / 2.0f);
        class_327 fontRenderer = class_310.method_1551().field_1772;
        int x = 84 - fontRenderer.method_1727(damage);
        graphics.method_51433(fontRenderer, damage, x, 8, Color.RED.getRGB(), false);
    }

    @Override
    public void addWidgets(EntityMeltingRecipeDisplay display, List<Widget> ingredients, Point origin, Rectangle bounds) {
        List<class_1299> displayTypes = EntityEntryDefinition.applyFocus(display.getRecipe().getEntityInputs());
        Slot input = this.slot(19, 11, origin).markInput().entries((Collection)EntryIngredients.of(TConstructREIConstants.ENTITY_TYPE, displayTypes));
        input.getBounds().setSize(34, 34);
        ClientEntryStacks.setRenderer((EntryStack)input.getCurrentEntry(), (EntryRenderer)this.entityRenderer);
        ingredients.add((Widget)input);
        Slot output = this.slot(115, 11, origin).markOutput().entries((Collection)display.getOutputEntries().get(0));
        output.getBounds().setSize(18, 34);
        output.getEntries().forEach(entryStack -> ClientEntryStacks.setFluidRenderRatio((EntryStack)entryStack.cast(), (float)((float)((FluidStack)entryStack.castValue()).getAmount() / 9000.0f * 2.0f)));
        TinkersCategory.setEntryTooltip(output, (IRecipeTooltipReplacement)TOOLTIP_MAP.computeIfAbsent(display.getDamage(), FluidTooltip::new));
        ingredients.add((Widget)output);
        Slot catalyst = this.slot(75, 43, origin).entries((Collection)EntryIngredients.of((EntryType)VanillaEntryTypes.FLUID, TinkersCategory.toREIFluids(MeltingFuelHandler.getUsableFuels(1))));
        catalyst.getBounds().setSize(18, 18);
        TinkersCategory.setEntryTooltip(catalyst, IRecipeTooltipReplacement.EMPTY);
        ingredients.add((Widget)catalyst);
        ingredients.add(this.tank.build(75, 43, origin));
        ingredients.add((Widget)new ArrowWidget(this.point(71, 21, origin), BACKGROUND_LOC, 150, 41).animationDurationTicks(200.0));
    }

    @Override
    public WidgetHolder getBackground() {
        return this.background;
    }

    private record FluidTooltip(int damage) implements IRecipeTooltipReplacement
    {
        @Override
        public void addMiddleLines(Slot recipeSlotView, List<class_2561> list) {
            if (recipeSlotView.getCurrentEntry().getType() == VanillaEntryTypes.FLUID) {
                FluidTooltipHandler.appendMaterial((io.github.fabricators_of_create.porting_lib.fluids.FluidStack)TinkersCategory.fromREIFluid((FluidStack)recipeSlotView.getCurrentEntry().castValue()), list);
            }
            if (this.damage == 2) {
                list.add(TOOLTIP_PER_HEART);
            } else {
                list.add((class_2561)class_2561.method_43469((String)KEY_PER_HEARTS, (Object[])new Object[]{Float.valueOf((float)this.damage / 2.0f)}).method_27692(class_124.field_1080));
            }
        }
    }
}

