/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.rei.casting;

import java.util.Collections;
import java.util.List;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.type.EntryType;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.class_1799;
import slimeknights.tconstruct.library.recipe.casting.IDisplayableCastingRecipe;
import slimeknights.tconstruct.plugin.rei.TinkersCategory;

public class CastingDisplay
implements Display {
    private final CategoryIdentifier<CastingDisplay> id;
    private final List<EntryIngredient> input;
    private final List<EntryIngredient> output;
    private final IDisplayableCastingRecipe recipe;

    public CastingDisplay(CategoryIdentifier<CastingDisplay> id, IDisplayableCastingRecipe recipe) {
        this.id = id;
        this.recipe = recipe;
        this.input = List.of(EntryIngredients.of((EntryType)VanillaEntryTypes.FLUID, TinkersCategory.toREIFluids(recipe.getFluids())), EntryIngredients.ofItemStacks(recipe.getCastItems()));
        this.output = Collections.singletonList(EntryIngredients.of((class_1799)recipe.getOutput()));
    }

    public List<EntryIngredient> getInputEntries() {
        return this.input;
    }

    public List<EntryIngredient> getOutputEntries() {
        return this.output;
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return this.id;
    }

    public IDisplayableCastingRecipe getRecipe() {
        return this.recipe;
    }

    public boolean hasCast() {
        return this.recipe.hasCast();
    }

    public boolean isConsumed() {
        return this.recipe.isConsumed();
    }
}

