/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.jei;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import io.github.fabricators_of_create.porting_lib.mixin.accessors.common.accessor.RecipeManagerAccessor;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IJeiRuntime;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1263;
import net.minecraft.class_1293;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_1935;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3611;
import net.minecraft.class_3956;
import net.minecraft.class_465;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import slimeknights.mantle.item.RetexturedBlockItem;
import slimeknights.mantle.recipe.helper.RecipeHelper;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.common.registration.CastItemObject;
import slimeknights.tconstruct.fluids.TinkerFluids;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.recipe.TinkerRecipeTypes;
import slimeknights.tconstruct.library.recipe.alloying.AlloyRecipe;
import slimeknights.tconstruct.library.recipe.casting.IDisplayableCastingRecipe;
import slimeknights.tconstruct.library.recipe.entitymelting.EntityMeltingRecipe;
import slimeknights.tconstruct.library.recipe.fuel.MeltingFuel;
import slimeknights.tconstruct.library.recipe.material.MaterialRecipe;
import slimeknights.tconstruct.library.recipe.melting.MeltingRecipe;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierRecipeLookup;
import slimeknights.tconstruct.library.recipe.modifiers.adding.IDisplayModifierRecipe;
import slimeknights.tconstruct.library.recipe.modifiers.severing.SeveringRecipe;
import slimeknights.tconstruct.library.recipe.molding.MoldingRecipe;
import slimeknights.tconstruct.library.recipe.partbuilder.IDisplayPartBuilderRecipe;
import slimeknights.tconstruct.library.recipe.worktable.IModifierWorktableRecipe;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.item.IModifiableDisplay;
import slimeknights.tconstruct.library.tools.nbt.MaterialIdNBT;
import slimeknights.tconstruct.library.tools.part.IMaterialItem;
import slimeknights.tconstruct.plugin.jei.AlloyRecipeCategory;
import slimeknights.tconstruct.plugin.jei.MoldingRecipeCategory;
import slimeknights.tconstruct.plugin.jei.TConstructJEIConstants;
import slimeknights.tconstruct.plugin.jei.casting.CastingBasinCategory;
import slimeknights.tconstruct.plugin.jei.casting.CastingTableCategory;
import slimeknights.tconstruct.plugin.jei.entity.DefaultEntityMeltingRecipe;
import slimeknights.tconstruct.plugin.jei.entity.EntityIngredientHelper;
import slimeknights.tconstruct.plugin.jei.entity.EntityIngredientRenderer;
import slimeknights.tconstruct.plugin.jei.entity.EntityMeltingRecipeCategory;
import slimeknights.tconstruct.plugin.jei.entity.SeveringCategory;
import slimeknights.tconstruct.plugin.jei.fabric.FluidStackIngredientHelper;
import slimeknights.tconstruct.plugin.jei.fabric.FluidStackRenderer;
import slimeknights.tconstruct.plugin.jei.fabric.JEITypes;
import slimeknights.tconstruct.plugin.jei.melting.FoundryCategory;
import slimeknights.tconstruct.plugin.jei.melting.MeltingCategory;
import slimeknights.tconstruct.plugin.jei.melting.MeltingFuelHandler;
import slimeknights.tconstruct.plugin.jei.modifiers.ModifierBookmarkIngredientRenderer;
import slimeknights.tconstruct.plugin.jei.modifiers.ModifierIngredientHelper;
import slimeknights.tconstruct.plugin.jei.modifiers.ModifierRecipeCategory;
import slimeknights.tconstruct.plugin.jei.modifiers.ModifierWorktableCategory;
import slimeknights.tconstruct.plugin.jei.partbuilder.MaterialItemList;
import slimeknights.tconstruct.plugin.jei.partbuilder.PartBuilderCategory;
import slimeknights.tconstruct.plugin.jei.partbuilder.PatternIngredientHelper;
import slimeknights.tconstruct.plugin.jei.partbuilder.PatternIngredientRenderer;
import slimeknights.tconstruct.plugin.jei.transfer.CraftingStationTransferInfo;
import slimeknights.tconstruct.plugin.jei.transfer.TinkerStationTransferInfo;
import slimeknights.tconstruct.shared.TinkerMaterials;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.client.screen.HeatingStructureScreen;
import slimeknights.tconstruct.smeltery.client.screen.IScreenWithFluidTank;
import slimeknights.tconstruct.smeltery.client.screen.MelterScreen;
import slimeknights.tconstruct.smeltery.data.SmelteryCompat;
import slimeknights.tconstruct.smeltery.item.CopperCanItem;
import slimeknights.tconstruct.tables.TinkerTables;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.item.ArmorSlotType;
import slimeknights.tconstruct.tools.item.CreativeSlotItem;
import slimeknights.tconstruct.tools.item.ModifierCrystalItem;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    public static IModIdHelper modIdHelper;

    public class_2960 getPluginUid() {
        return TConstructJEIConstants.PLUGIN;
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        IGuiHelper guiHelper = registry.getJeiHelpers().getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new CastingBasinCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new CastingTableCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new MoldingRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new MeltingCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new AlloyRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new EntityMeltingRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new FoundryCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new ModifierRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new SeveringCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new PartBuilderCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new ModifierWorktableCategory(guiHelper)});
    }

    public void registerIngredients(IModIngredientRegistration registration) {
        assert (class_310.method_1551().field_1687 != null);
        class_1863 manager = class_310.method_1551().field_1687.method_8433();
        List<Object> modifiers = Collections.emptyList();
        if (((Boolean)Config.CLIENT.showModifiersInJEI.get()).booleanValue()) {
            modifiers = ModifierRecipeLookup.getRecipeModifierList();
        }
        registration.register(TConstructJEIConstants.ENTITY_TYPE, Collections.emptyList(), (IIngredientHelper)new EntityIngredientHelper(), (IIngredientRenderer)new EntityIngredientRenderer(16));
        registration.register(TConstructJEIConstants.MODIFIER_TYPE, modifiers, (IIngredientHelper)new ModifierIngredientHelper(), (IIngredientRenderer)ModifierBookmarkIngredientRenderer.INSTANCE);
        registration.register(TConstructJEIConstants.PATTERN_TYPE, Collections.emptyList(), (IIngredientHelper)new PatternIngredientHelper(), (IIngredientRenderer)PatternIngredientRenderer.INSTANCE);
        registration.register(JEITypes.FLUID_STACK, Collections.emptyList(), (IIngredientHelper)new FluidStackIngredientHelper(), (IIngredientRenderer)new FluidStackRenderer());
    }

    public void registerRecipes(IRecipeRegistration register) {
        assert (class_310.method_1551().field_1687 != null);
        class_1863 manager = class_310.method_1551().field_1687.method_8433();
        List castingBasinRecipes = RecipeHelper.getJEIRecipes((class_1863)manager, (class_3956)((class_3956)TinkerRecipeTypes.CASTING_BASIN.get()), IDisplayableCastingRecipe.class);
        register.addRecipes(TConstructJEIConstants.CASTING_BASIN, castingBasinRecipes);
        List castingTableRecipes = RecipeHelper.getJEIRecipes((class_1863)manager, (class_3956)((class_3956)TinkerRecipeTypes.CASTING_TABLE.get()), IDisplayableCastingRecipe.class);
        register.addRecipes(TConstructJEIConstants.CASTING_TABLE, castingTableRecipes);
        List meltingRecipes = RecipeHelper.getJEIRecipes((class_1863)manager, (class_3956)((class_3956)TinkerRecipeTypes.MELTING.get()), MeltingRecipe.class);
        register.addRecipes(TConstructJEIConstants.MELTING, meltingRecipes);
        register.addRecipes(TConstructJEIConstants.FOUNDRY, meltingRecipes);
        MeltingFuelHandler.setMeltngFuels(RecipeHelper.getRecipes((class_1863)manager, (class_3956)((class_3956)TinkerRecipeTypes.FUEL.get()), MeltingFuel.class));
        List entityMeltingRecipes = RecipeHelper.getJEIRecipes((class_1863)manager, (class_3956)((class_3956)TinkerRecipeTypes.ENTITY_MELTING.get()), EntityMeltingRecipe.class);
        entityMeltingRecipes.add(new DefaultEntityMeltingRecipe(entityMeltingRecipes));
        register.addRecipes(TConstructJEIConstants.ENTITY_MELTING, entityMeltingRecipes);
        List alloyRecipes = RecipeHelper.getJEIRecipes((class_1863)manager, (class_3956)((class_3956)TinkerRecipeTypes.ALLOYING.get()), AlloyRecipe.class);
        register.addRecipes(TConstructJEIConstants.ALLOY, alloyRecipes);
        ImmutableList moldingRecipes = ImmutableList.builder().addAll((Iterable)RecipeHelper.getJEIRecipes((class_1863)manager, (class_3956)((class_3956)TinkerRecipeTypes.MOLDING_TABLE.get()), MoldingRecipe.class)).addAll((Iterable)RecipeHelper.getJEIRecipes((class_1863)manager, (class_3956)((class_3956)TinkerRecipeTypes.MOLDING_BASIN.get()), MoldingRecipe.class)).build();
        register.addRecipes(TConstructJEIConstants.MOLDING, (List)moldingRecipes);
        List modifierRecipes = RecipeHelper.getJEIRecipes((class_1863)manager, (class_3956)((class_3956)TinkerRecipeTypes.TINKER_STATION.get()), IDisplayModifierRecipe.class).stream().sorted((r1, r2) -> {
            SlotType t1 = r1.getSlotType();
            SlotType t2 = r2.getSlotType();
            String n1 = t1 == null ? "zzzzzzzzzz" : t1.getName();
            String n2 = t2 == null ? "zzzzzzzzzz" : t2.getName();
            return n1.compareTo(n2);
        }).collect(Collectors.toList());
        register.addRecipes(TConstructJEIConstants.MODIFIERS, modifierRecipes);
        List severingRecipes = RecipeHelper.getJEIRecipes((class_1863)manager, (class_3956)((class_3956)TinkerRecipeTypes.SEVERING.get()), SeveringRecipe.class);
        register.addRecipes(TConstructJEIConstants.SEVERING, severingRecipes);
        MaterialItemList.setRecipes(RecipeHelper.getRecipes((class_1863)manager, (class_3956)((class_3956)TinkerRecipeTypes.MATERIAL.get()), MaterialRecipe.class));
        register.addRecipes(TConstructJEIConstants.PART_BUILDER, RecipeHelper.getJEIRecipes((class_1863)manager, (class_3956)((class_3956)TinkerRecipeTypes.PART_BUILDER.get()), IDisplayPartBuilderRecipe.class));
        register.addRecipes(TConstructJEIConstants.MODIFIER_WORKTABLE, RecipeHelper.getJEIRecipes((class_1863)manager, (class_3956)((class_3956)TinkerRecipeTypes.MODIFIER_WORKTABLE.get()), IModifierWorktableRecipe.class));
    }

    private static <T extends class_1860<C>, C extends class_1263> void addCastingCatalyst(IRecipeCatalystRegistration registry, class_1935 item, RecipeType<IDisplayableCastingRecipe> ownCategory, class_3956<MoldingRecipe> type) {
        class_1799 stack = new class_1799(item);
        registry.addRecipeCatalyst(stack, new RecipeType[]{ownCategory});
        assert (class_310.method_1551().field_1687 != null);
        if (!((RecipeManagerAccessor)class_310.method_1551().field_1687.method_8433()).port_lib$byType(type).isEmpty()) {
            registry.addRecipeCatalyst(stack, new RecipeType[]{TConstructJEIConstants.MOLDING});
        }
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registry) {
        registry.addRecipeCatalyst(new class_1799(TinkerTables.partBuilder), new RecipeType[]{TConstructJEIConstants.PART_BUILDER});
        registry.addRecipeCatalyst(new class_1799(TinkerTables.tinkerStation), new RecipeType[]{TConstructJEIConstants.MODIFIERS});
        registry.addRecipeCatalyst(new class_1799(TinkerTables.tinkersAnvil), new RecipeType[]{TConstructJEIConstants.MODIFIERS});
        registry.addRecipeCatalyst(new class_1799(TinkerTables.scorchedAnvil), new RecipeType[]{TConstructJEIConstants.MODIFIERS});
        registry.addRecipeCatalyst(new class_1799(TinkerTables.modifierWorktable), new RecipeType[]{TConstructJEIConstants.MODIFIER_WORKTABLE});
        registry.addRecipeCatalyst(new class_1799(TinkerSmeltery.searedMelter), new RecipeType[]{TConstructJEIConstants.MELTING});
        registry.addRecipeCatalyst(new class_1799(TinkerSmeltery.searedHeater), new RecipeType[]{RecipeTypes.FUELING});
        JEIPlugin.addCastingCatalyst(registry, TinkerSmeltery.searedTable, TConstructJEIConstants.CASTING_TABLE, (class_3956<MoldingRecipe>)((class_3956)TinkerRecipeTypes.MOLDING_TABLE.get()));
        JEIPlugin.addCastingCatalyst(registry, TinkerSmeltery.searedBasin, TConstructJEIConstants.CASTING_BASIN, (class_3956<MoldingRecipe>)((class_3956)TinkerRecipeTypes.MOLDING_BASIN.get()));
        registry.addRecipeCatalyst(new class_1799(TinkerSmeltery.smelteryController), new RecipeType[]{TConstructJEIConstants.MELTING, TConstructJEIConstants.ALLOY, TConstructJEIConstants.ENTITY_MELTING});
        registry.addRecipeCatalyst(new class_1799(TinkerSmeltery.scorchedAlloyer), new RecipeType[]{TConstructJEIConstants.ALLOY});
        JEIPlugin.addCastingCatalyst(registry, TinkerSmeltery.scorchedTable, TConstructJEIConstants.CASTING_TABLE, (class_3956<MoldingRecipe>)((class_3956)TinkerRecipeTypes.MOLDING_TABLE.get()));
        JEIPlugin.addCastingCatalyst(registry, TinkerSmeltery.scorchedBasin, TConstructJEIConstants.CASTING_BASIN, (class_3956<MoldingRecipe>)((class_3956)TinkerRecipeTypes.MOLDING_BASIN.get()));
        registry.addRecipeCatalyst(new class_1799(TinkerSmeltery.foundryController), new RecipeType[]{TConstructJEIConstants.FOUNDRY});
        for (class_6880 item : Objects.requireNonNull(class_7923.field_41178.method_40286(TinkerTags.Items.MELEE))) {
            IModifiable modifiable;
            if (!(item instanceof IModifiable) || !(modifiable = (IModifiable)item).getToolDefinition().getData().getTraits().stream().anyMatch(entry -> entry.matches(TinkerModifiers.severing.getId()))) continue;
            registry.addRecipeCatalyst(IModifiableDisplay.getDisplayStack((class_1792)item.comp_349()), new RecipeType[]{TConstructJEIConstants.SEVERING});
        }
        registry.addRecipeCatalyst(TConstructJEIConstants.MODIFIER_TYPE, (Object)new ModifierEntry(TinkerModifiers.severing, 1), new RecipeType[]{TConstructJEIConstants.SEVERING});
        registry.addRecipeCatalyst(TConstructJEIConstants.MODIFIER_TYPE, (Object)new ModifierEntry(TinkerModifiers.melting, 1), new RecipeType[]{TConstructJEIConstants.MELTING, TConstructJEIConstants.ENTITY_MELTING});
    }

    public void registerItemSubtypes(ISubtypeRegistration registry) {
        IIngredientSubtypeInterpreter tables = (stack, context) -> {
            if (context == UidContext.Ingredient) {
                return RetexturedBlockItem.getTextureName((class_1799)stack);
            }
            return "";
        };
        registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)TinkerTables.craftingStation.method_8389(), tables);
        registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)TinkerTables.partBuilder.method_8389(), tables);
        registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)TinkerTables.tinkerStation.method_8389(), tables);
        registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)TinkerTables.tinkersAnvil.method_8389(), tables);
        registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)TinkerTables.modifierWorktable.method_8389(), tables);
        registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)TinkerTables.scorchedAnvil.method_8389(), tables);
        registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)TinkerSmeltery.smelteryController.method_8389(), tables);
        registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)TinkerSmeltery.searedDrain.method_8389(), tables);
        registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)TinkerSmeltery.searedDuct.method_8389(), tables);
        registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)TinkerSmeltery.searedChute.method_8389(), tables);
        registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)TinkerSmeltery.foundryController.method_8389(), tables);
        registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)TinkerSmeltery.scorchedDrain.method_8389(), tables);
        registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)TinkerSmeltery.scorchedDuct.method_8389(), tables);
        registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)TinkerSmeltery.scorchedChute.method_8389(), tables);
        registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)TinkerFluids.potionBucket.method_8389(), (stack, context) -> {
            if (!stack.method_7985()) {
                return "";
            }
            class_1842 potionType = class_1844.method_8063((class_1799)stack);
            String potionTypeString = potionType.method_8051("");
            StringBuilder stringBuilder = new StringBuilder(potionTypeString);
            List effects = class_1844.method_8067((class_1799)stack);
            for (class_1293 effect : effects) {
                stringBuilder.append(";").append(effect);
            }
            return stringBuilder.toString();
        });
        IIngredientSubtypeInterpreter toolPartInterpreter = (stack, context) -> {
            MaterialVariantId materialId = IMaterialItem.getMaterialFromStack(stack);
            if (materialId.equals(IMaterial.UNKNOWN_ID)) {
                return "";
            }
            if (context == UidContext.Ingredient) {
                return materialId.toString();
            }
            return materialId.getId().toString();
        };
        for (class_6880<class_1792> item : JEIPlugin.getTag(TinkerTags.Items.TOOL_PARTS)) {
            registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((class_1792)item.comp_349()), toolPartInterpreter);
        }
        class_1792 slimeskull = (class_1792)TinkerTools.slimesuit.get((Enum)ArmorSlotType.HELMET);
        registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)slimeskull, (IIngredientSubtypeInterpreter)ToolSubtypeInterpreter.ALWAYS);
        for (class_6880<class_1792> item : JEIPlugin.getTag(TinkerTags.Items.MULTIPART_TOOL)) {
            if (item == slimeskull) continue;
            registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((class_1792)item.comp_349()), (IIngredientSubtypeInterpreter)ToolSubtypeInterpreter.INGREDIENT);
        }
        registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((class_1792)TinkerSmeltery.copperCan.get()), (stack, context) -> CopperCanItem.getSubtype(stack));
        registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((class_1792)TinkerModifiers.creativeSlotItem.get()), (stack, context) -> {
            SlotType slotType = CreativeSlotItem.getSlot(stack);
            return slotType != null ? slotType.getName() : "";
        });
        registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((class_1792)TinkerModifiers.modifierCrystal.get()), (stack, context) -> {
            ModifierId id = ModifierCrystalItem.getModifier(stack);
            return id == null ? "" : id.toString();
        });
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGenericGuiContainerHandler(MelterScreen.class, new GuiContainerTankHandler());
        registration.addGenericGuiContainerHandler(HeatingStructureScreen.class, new GuiContainerTankHandler());
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler((IRecipeTransferInfo)new CraftingStationTransferInfo());
        registration.addRecipeTransferHandler((IRecipeTransferInfo)new TinkerStationTransferInfo());
    }

    private static void removeFluid(IIngredientManager manager, class_3611 fluid, class_1792 bucket) {
        manager.removeIngredientsAtRuntime(JEITypes.FLUID_STACK, Collections.singleton(new FluidStack(fluid, 81000L)));
        manager.removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, Collections.singleton(new class_1799((class_1935)bucket)));
    }

    private static Iterable<class_6880<class_1792>> getTag(class_2960 name) {
        return JEIPlugin.getTag((class_6862<class_1792>)class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)name));
    }

    private static Iterable<class_6880<class_1792>> getTag(class_6862<class_1792> name) {
        return Objects.requireNonNull(class_7923.field_41178.method_40286(name));
    }

    private static void optionalItem(IIngredientManager manager, class_1935 item, String tagName) {
        Iterable<class_6880<class_1792>> tag = JEIPlugin.getTag(new class_2960("c", tagName));
        if (Iterables.isEmpty(tag)) {
            manager.removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, Collections.singletonList(new class_1799(item)));
        }
    }

    private static void optionalCast(IIngredientManager manager, CastItemObject cast) {
        Iterable<class_6880<class_1792>> tag = JEIPlugin.getTag(new class_2960("c", cast.getName().method_12832() + "_blocks"));
        if (Iterables.isEmpty(tag)) {
            manager.removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, (Collection)cast.values().stream().map(class_1799::new).collect(Collectors.toList()));
        }
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        IIngredientManager manager = jeiRuntime.getIngredientManager();
        class_2371 modifierCrystals = class_2371.method_10211();
        if (!modifierCrystals.isEmpty()) {
            manager.removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, (Collection)modifierCrystals);
        }
        JEIPlugin.removeFluid(manager, (class_3611)TinkerFluids.moltenSoulsteel.get(), TinkerFluids.moltenSoulsteel.method_8389());
        JEIPlugin.removeFluid(manager, (class_3611)TinkerFluids.moltenKnightslime.get(), TinkerFluids.moltenKnightslime.method_8389());
        for (SmelteryCompat compat : SmelteryCompat.values()) {
            Iterable<class_6880<class_1792>> ingot = JEIPlugin.getTag(new class_2960("c", compat.getName() + "_ingots"));
            if (!Iterables.isEmpty(ingot)) continue;
            JEIPlugin.removeFluid(manager, (class_3611)compat.getFluid().get(), compat.getBucket());
        }
        if (!FabricLoader.getInstance().isModLoaded("ceramics")) {
            JEIPlugin.removeFluid(manager, (class_3611)TinkerFluids.moltenPorcelain.get(), TinkerFluids.moltenPorcelain.method_8389());
        }
        JEIPlugin.optionalCast(manager, TinkerSmeltery.plateCast);
        JEIPlugin.optionalCast(manager, TinkerSmeltery.gearCast);
        JEIPlugin.optionalCast(manager, TinkerSmeltery.coinCast);
        JEIPlugin.optionalCast(manager, TinkerSmeltery.wireCast);
        JEIPlugin.optionalItem(manager, TinkerMaterials.necroniumBone, "uranium_ingots");
        modIdHelper = jeiRuntime.getJeiHelpers().getModIdHelper();
    }

    public static enum ToolSubtypeInterpreter implements IIngredientSubtypeInterpreter<class_1799>
    {
        ALWAYS,
        INGREDIENT;


        public String apply(class_1799 itemStack, UidContext context) {
            if (this == ALWAYS || context == UidContext.Ingredient) {
                StringBuilder builder = new StringBuilder();
                List<MaterialVariantId> materialList = MaterialIdNBT.from(itemStack).getMaterials();
                if (!materialList.isEmpty()) {
                    builder.append(materialList.get(0));
                    for (int i = 1; i < materialList.size(); ++i) {
                        builder.append(',');
                        builder.append(materialList.get(i).getId());
                    }
                }
                return builder.toString();
            }
            return "";
        }
    }

    public static class GuiContainerTankHandler<C extends class_1703, T extends class_465<C>>
    implements IGuiContainerHandler<T> {
        @Nullable
        public Object getIngredientUnderMouse(T containerScreen, double mouseX, double mouseY) {
            return ((IScreenWithFluidTank)containerScreen).getIngredientUnderMouse(mouseX, mouseY);
        }
    }
}

