/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.stat;

import com.google.gson.JsonObject;
import java.util.function.Predicate;
import net.minecraft.class_3518;
import slimeknights.tconstruct.library.tools.nbt.StatsNBT;
import slimeknights.tconstruct.library.tools.stat.INumericToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public record StatPredicate(INumericToolStat<?> stat, float min, float max) implements Predicate<StatsNBT>
{
    public static StatPredicate match(INumericToolStat<?> stat, float value) {
        return new StatPredicate(stat, value, value);
    }

    public static StatPredicate min(INumericToolStat<?> stat, float min) {
        return new StatPredicate(stat, min, Float.POSITIVE_INFINITY);
    }

    public static StatPredicate max(INumericToolStat<?> stat, float max) {
        return new StatPredicate(stat, Float.NEGATIVE_INFINITY, max);
    }

    @Override
    public boolean test(StatsNBT statsNBT) {
        float value = ((Number)statsNBT.get(this.stat)).floatValue();
        return value >= this.min && value <= this.max;
    }

    public static StatPredicate deserialize(JsonObject json) {
        return new StatPredicate(ToolStats.numericFromJson(class_3518.method_15265((JsonObject)json, (String)"stat")), class_3518.method_15277((JsonObject)json, (String)"min", (float)Float.NEGATIVE_INFINITY), class_3518.method_15277((JsonObject)json, (String)"max", (float)Float.NEGATIVE_INFINITY));
    }

    public JsonObject serialize() {
        JsonObject json = new JsonObject();
        json.addProperty("stat", this.stat.getName().toString());
        if (this.min > Float.NEGATIVE_INFINITY) {
            json.addProperty("min", (Number)Float.valueOf(this.min));
        }
        if (this.max < Float.POSITIVE_INFINITY) {
            json.addProperty("max", (Number)Float.valueOf(this.max));
        }
        return json;
    }
}

