/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.helper;

import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_1304;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5134;
import net.minecraft.class_5250;
import net.minecraft.class_7923;
import slimeknights.mantle.client.SafeClientAccess;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.client.materials.MaterialTooltipCache;
import slimeknights.tconstruct.library.materials.IMaterialRegistry;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.tools.definition.PartRequirement;
import slimeknights.tconstruct.library.tools.definition.ToolDefinition;
import slimeknights.tconstruct.library.tools.helper.TooltipBuilder;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.item.IModifiableDisplay;
import slimeknights.tconstruct.library.tools.item.ITinkerStationDisplay;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.MaterialNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.utils.TooltipKey;
import slimeknights.tconstruct.library.utils.Util;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class TooltipUtil {
    public static final String KEY_FORMAT = TConstruct.makeTranslationKey("item", "tool.format");
    public static final String KEY_ID_FORMAT = TConstruct.makeTranslationKey("item", "tool.id_format");
    private static final class_2561 MATERIAL_SEPARATOR = TConstruct.makeTranslation("item", "tool.material_separator");
    public static final String KEY_DISPLAY = "tic_display";
    private static final String KEY_NAME = "tic_name";
    public static final BiPredicate<class_1320, class_1322.class_1323> SHOW_ALL_ATTRIBUTES = (att, op) -> true;
    public static final BiPredicate<class_1320, class_1322.class_1323> SHOW_MELEE_ATTRIBUTES = (att, op) -> op != class_1322.class_1323.field_6328 || att != class_5134.field_23721 && att != class_5134.field_23723 && att != class_5134.field_23724 && att != class_5134.field_23725 && att != class_5134.field_23718;
    public static final BiPredicate<class_1320, class_1322.class_1323> SHOW_ARMOR_ATTRIBUTES = (att, op) -> op != class_1322.class_1323.field_6328 || att != class_5134.field_23724 && att != class_5134.field_23725 && att != class_5134.field_23718;
    private static final int DEFAULT_HIDE_FLAGS = class_1799.class_5422.field_25768.method_30269();
    private static final int MODIFIER_HIDE_FLAGS = class_1799.class_5422.field_25768.method_30269() | class_1799.class_5422.field_25769.method_30269();
    public static final class_2561 TOOLTIP_HOLD_SHIFT = TConstruct.makeTranslation("tooltip", "hold_shift", TConstruct.makeTranslation("key", "shift").method_27695(new class_124[]{class_124.field_1054, class_124.field_1056}));
    public static final class_2561 TOOLTIP_HOLD_CTRL = TConstruct.makeTranslation("tooltip", "hold_ctrl", TConstruct.makeTranslation("key", "ctrl").method_27695(new class_124[]{class_124.field_1075, class_124.field_1056}));
    private static final class_2561 NO_DATA = TConstruct.makeTranslation("tooltip", "missing_data").method_27692(class_124.field_1080);
    private static final class_2561 UNINITIALIZED = TConstruct.makeTranslation("tooltip", "uninitialized").method_27692(class_124.field_1080);
    private static final class_2561 RANDOM_MATERIALS = TConstruct.makeTranslation("tooltip", "random_materials").method_27692(class_124.field_1080);

    private TooltipUtil() {
    }

    public static boolean isDisplay(class_1799 stack) {
        class_2487 nbt = stack.method_7969();
        return nbt != null && nbt.method_10577(KEY_DISPLAY);
    }

    @Nullable
    private static class_2561 nameFor(String itemKey, class_2561 itemName, MaterialVariantId variantId) {
        String materialKey = MaterialTooltipCache.getKey(variantId);
        String key = itemKey + "." + materialKey;
        if (Util.canTranslate(key)) {
            return class_2561.method_43471((String)key);
        }
        String formatKey = materialKey + ".format";
        if (Util.canTranslate(formatKey)) {
            return class_2561.method_43469((String)formatKey, (Object[])new Object[]{itemName});
        }
        if (Util.canTranslate(materialKey)) {
            return class_2561.method_43469((String)KEY_FORMAT, (Object[])new Object[]{class_2561.method_43471((String)materialKey), itemName});
        }
        return null;
    }

    private static class_2561 getMaterialItemName(class_1799 stack, class_2561 itemName, MaterialVariantId material) {
        class_2561 component;
        String itemKey = stack.method_7922();
        if (material.hasVariant() && (component = TooltipUtil.nameFor(itemKey, itemName, material)) != null) {
            return component;
        }
        component = TooltipUtil.nameFor(itemKey, itemName, material.getId());
        if (component != null) {
            return component;
        }
        return itemName;
    }

    private static class_2561 getCombinedItemName(class_2561 itemName, Collection<class_2561> materials) {
        if (materials.isEmpty()) {
            return itemName;
        }
        class_5250 name = class_2561.method_43470((String)"");
        Iterator<class_2561> iter = materials.iterator();
        name.method_10852(iter.next());
        while (iter.hasNext()) {
            name.method_10852(MATERIAL_SEPARATOR).method_10852(iter.next());
        }
        return class_2561.method_43469((String)KEY_FORMAT, (Object[])new Object[]{name, itemName});
    }

    public static void setDisplayName(class_1799 tool, String name) {
        if (name.isEmpty()) {
            class_2487 tag = tool.method_7969();
            if (tag != null) {
                tag.method_10551(KEY_NAME);
            }
        } else {
            tool.method_7948().method_10582(KEY_NAME, name);
        }
        tool.method_7925();
    }

    public static String getDisplayName(class_1799 tool) {
        class_2487 tag = tool.method_7969();
        if (tag != null) {
            return tag.method_10558(KEY_NAME);
        }
        return "";
    }

    public static class_2561 getDisplayName(class_1799 stack, ToolDefinition toolDefinition) {
        return TooltipUtil.getDisplayName(stack, null, toolDefinition);
    }

    public static class_2561 getDisplayName(class_1799 stack, @Nullable IToolStackView tool, ToolDefinition toolDefinition) {
        MaterialNBT materials;
        String name = TooltipUtil.getDisplayName(stack);
        if (!name.isEmpty()) {
            return class_2561.method_43470((String)name);
        }
        List<PartRequirement> components = toolDefinition.getData().getParts();
        class_5250 baseName = class_2561.method_43471((String)stack.method_7922());
        if (components.isEmpty()) {
            return baseName;
        }
        if (tool == null) {
            tool = ToolStack.from(stack);
        }
        if ((materials = tool.getMaterials()).size() != components.size()) {
            return baseName;
        }
        LinkedHashSet nameMaterials = Sets.newLinkedHashSet();
        MaterialVariantId firstMaterial = null;
        IMaterialRegistry registry = MaterialRegistry.getInstance();
        for (int i = 0; i < components.size(); ++i) {
            MaterialVariantId material;
            if (i >= materials.size() || !registry.canRepair(components.get(i).getStatType()) || IMaterial.UNKNOWN_ID.equals(material = materials.get(i).getVariant())) continue;
            if (firstMaterial == null) {
                firstMaterial = material;
            }
            nameMaterials.add(MaterialTooltipCache.getDisplayName(material));
        }
        if (nameMaterials.size() == 1) {
            return TooltipUtil.getMaterialItemName(stack, (class_2561)baseName, firstMaterial);
        }
        return TooltipUtil.getCombinedItemName((class_2561)baseName, nameMaterials);
    }

    @Deprecated
    public static void addInformation(IModifiableDisplay item, class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, TooltipKey tooltipKey, class_1836 tooltipFlag) {
        TooltipUtil.addInformation(item, stack, world, tooltip, tooltipKey.asMantle(), tooltipFlag);
    }

    public static void addInformation(IModifiableDisplay item, class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, slimeknights.mantle.client.TooltipKey tooltipKey, class_1836 tooltipFlag) {
        class_1657 player = world == null ? null : SafeClientAccess.getPlayer();
        TooltipUtil.addInformation(item, stack, player, tooltip, tooltipKey, tooltipFlag);
    }

    @Deprecated
    public static void addInformation(IModifiableDisplay item, class_1799 stack, @Nullable class_1657 player, List<class_2561> tooltip, TooltipKey tooltipKey, class_1836 tooltipFlag) {
        TooltipUtil.addInformation(item, stack, player, tooltip, tooltipKey.asMantle(), tooltipFlag);
    }

    public static void addInformation(IModifiableDisplay item, class_1799 stack, @Nullable class_1657 player, List<class_2561> tooltip, slimeknights.mantle.client.TooltipKey tooltipKey, class_1836 tooltipFlag) {
        ToolDefinition definition = item.getToolDefinition();
        if (TooltipUtil.isDisplay(stack)) {
            ToolStack tool = ToolStack.from(stack);
            TooltipUtil.addModifierNames(stack, tool, tooltip, tooltipFlag);
        } else if (!definition.isDataLoaded()) {
            tooltip.add(NO_DATA);
        } else if (!ToolStack.isInitialized(stack)) {
            class_2487 nbt;
            tooltip.add(UNINITIALIZED);
            if (definition.isMultipart() && ((nbt = stack.method_7969()) == null || !nbt.method_10573("tic_materials", 9))) {
                tooltip.add(RANDOM_MATERIALS);
            }
        } else {
            switch (tooltipKey) {
                case SHIFT: {
                    item.getStatInformation(ToolStack.from(stack), player, tooltip, tooltipKey, tooltipFlag);
                    break;
                }
                case CONTROL: {
                    if (definition.isMultipart()) {
                        TooltipUtil.getComponents(item, stack, tooltip, tooltipFlag);
                        break;
                    }
                }
                default: {
                    ToolStack tool = ToolStack.from(stack);
                    TooltipUtil.getDefaultInfo(stack, tool, tooltip, tooltipFlag);
                }
            }
        }
    }

    @Deprecated
    public static void addModifierNames(class_1799 stack, IToolStackView tool, List<class_2561> tooltips) {
        TooltipUtil.addModifierNames(stack, tool, tooltips, (class_1836)class_1836.class_1837.field_41070);
    }

    public static void addModifierNames(class_1799 stack, IToolStackView tool, List<class_2561> tooltips, class_1836 flag) {
        class_2487 tag;
        for (ModifierEntry entry : tool.getModifierList()) {
            if (!entry.getModifier().shouldDisplay(false)) continue;
            class_2561 name = entry.getModifier().getDisplayName(tool, entry.getLevel());
            if (flag.method_8035() && ((Boolean)Config.CLIENT.modifiersIDsInAdvancedTooltips.get()).booleanValue()) {
                tooltips.add((class_2561)class_2561.method_43469((String)KEY_ID_FORMAT, (Object[])new Object[]{name, class_2561.method_43470((String)entry.getModifier().getId().toString())}).method_27692(class_124.field_1063));
                continue;
            }
            tooltips.add(name);
        }
        if (!stack.method_7960() && (tag = stack.method_7969()) != null && tag.method_10573("Enchantments", 9)) {
            class_2499 enchantments = tag.method_10554("Enchantments", 10);
            for (int i = 0; i < enchantments.size(); ++i) {
                class_2487 enchantmentTag = enchantments.method_10602(i);
                class_7923.field_41176.method_17966(class_2960.method_12829((String)enchantmentTag.method_10558("id"))).ifPresent(enchantment -> {
                    if (enchantment.method_8195()) {
                        tooltips.add(enchantment.method_8179(enchantmentTag.method_10550("lvl")));
                    }
                });
            }
        }
    }

    @Deprecated
    public static void getDefaultInfo(class_1799 stack, List<class_2561> tooltips) {
        TooltipUtil.getDefaultInfo(stack, ToolStack.from(stack), tooltips);
    }

    @Deprecated
    public static void getDefaultInfo(class_1799 stack, IToolStackView tool, List<class_2561> tooltips) {
        TooltipUtil.getDefaultInfo(stack, tool, tooltips, (class_1836)class_1836.class_1837.field_41070);
    }

    public static void getDefaultInfo(class_1799 stack, IToolStackView tool, List<class_2561> tooltips, class_1836 flag) {
        if (tool.getItem().method_7846() && !tool.isUnbreakable() && tool.hasTag(TinkerTags.Items.DURABILITY)) {
            tooltips.add(TooltipBuilder.formatDurability(tool.getCurrentDurability(), tool.getStats().getInt(ToolStats.DURABILITY), true));
        }
        TooltipUtil.addModifierNames(stack, tool, tooltips, flag);
        tooltips.add((class_2561)class_2561.method_43473());
        tooltips.add(TOOLTIP_HOLD_SHIFT);
        if (tool.getDefinition().isMultipart()) {
            tooltips.add(TOOLTIP_HOLD_CTRL);
        }
    }

    @Deprecated
    public static List<class_2561> getDefaultStats(IToolStackView tool, @Nullable class_1657 player, List<class_2561> tooltip, TooltipKey key, class_1836 flag) {
        return TooltipUtil.getDefaultStats(tool, player, tooltip, key.asMantle(), flag);
    }

    public static List<class_2561> getDefaultStats(IToolStackView tool, @Nullable class_1657 player, List<class_2561> tooltip, slimeknights.mantle.client.TooltipKey key, class_1836 flag) {
        TooltipBuilder builder = new TooltipBuilder(tool, tooltip);
        if (tool.hasTag(TinkerTags.Items.DURABILITY)) {
            builder.addDurability();
        }
        if (tool.hasTag(TinkerTags.Items.RANGED)) {
            builder.add(ToolStats.DRAW_SPEED);
            builder.add(ToolStats.VELOCITY);
            builder.add(ToolStats.PROJECTILE_DAMAGE);
            builder.add(ToolStats.ACCURACY);
        }
        if (tool.hasTag(TinkerTags.Items.MELEE)) {
            builder.addWithAttribute(ToolStats.ATTACK_DAMAGE, class_5134.field_23721);
            builder.add(ToolStats.ATTACK_SPEED);
        }
        if (tool.hasTag(TinkerTags.Items.HARVEST)) {
            if (tool.hasTag(TinkerTags.Items.HARVEST_PRIMARY)) {
                builder.addTier();
            }
            builder.add(ToolStats.MINING_SPEED);
        }
        if (tool.hasTag(TinkerTags.Items.ARMOR)) {
            builder.add(ToolStats.ARMOR);
            builder.addOptional(ToolStats.ARMOR_TOUGHNESS);
            builder.addOptional(ToolStats.KNOCKBACK_RESISTANCE, 10.0f);
        }
        if (tool.getModifierLevel(TinkerModifiers.blocking.getId()) > 0 || tool.getModifierLevel(TinkerModifiers.parrying.getId()) > 0) {
            builder.add(ToolStats.BLOCK_AMOUNT);
            builder.add(ToolStats.BLOCK_ANGLE);
        }
        builder.addAllFreeSlots();
        for (ModifierEntry entry : tool.getModifierList()) {
            entry.getHook(TinkerHooks.TOOLTIP).addTooltip(tool, entry, player, tooltip, key, flag);
        }
        return builder.getTooltips();
    }

    @Deprecated
    public static List<class_2561> getArmorStats(IToolStackView tool, @Nullable class_1657 player, List<class_2561> tooltip, TooltipKey key, class_1836 flag) {
        return TooltipUtil.getArmorStats(tool, player, tooltip, key.asMantle(), flag);
    }

    public static List<class_2561> getArmorStats(IToolStackView tool, @Nullable class_1657 player, List<class_2561> tooltip, slimeknights.mantle.client.TooltipKey key, class_1836 flag) {
        TooltipBuilder builder = new TooltipBuilder(tool, tooltip);
        if (tool.hasTag(TinkerTags.Items.DURABILITY)) {
            builder.addDurability();
        }
        if (tool.hasTag(TinkerTags.Items.ARMOR)) {
            builder.add(ToolStats.ARMOR);
            builder.addOptional(ToolStats.ARMOR_TOUGHNESS);
            builder.addOptional(ToolStats.KNOCKBACK_RESISTANCE, 10.0f);
        }
        if (tool.hasTag(TinkerTags.Items.UNARMED)) {
            builder.addWithAttribute(ToolStats.ATTACK_DAMAGE, class_5134.field_23721);
        }
        builder.addAllFreeSlots();
        for (ModifierEntry entry : tool.getModifierList()) {
            entry.getHook(TinkerHooks.TOOLTIP).addTooltip(tool, entry, player, tooltip, key, flag);
        }
        return builder.getTooltips();
    }

    @Deprecated
    public static void getComponents(IModifiable item, class_1799 stack, List<class_2561> tooltips) {
        TooltipUtil.getComponents(item, stack, tooltips, (class_1836)class_1836.class_1837.field_41070);
    }

    public static void getComponents(IModifiable item, class_1799 stack, List<class_2561> tooltips, class_1836 flag) {
        List<PartRequirement> components = item.getToolDefinition().getData().getParts();
        if (components.isEmpty()) {
            return;
        }
        MaterialNBT materials = ToolStack.from(stack).getMaterials();
        if (materials.size() == 0) {
            tooltips.add(NO_DATA);
            return;
        }
        if (materials.size() < components.size()) {
            return;
        }
        int max = components.size() - 1;
        for (int i = 0; i <= max; ++i) {
            PartRequirement requirement = components.get(i);
            MaterialVariantId material = materials.get(i).getVariant();
            tooltips.add((class_2561)requirement.nameForMaterial(material).method_27661().method_27692(class_124.field_1073).method_27694(style -> style.method_27703(MaterialTooltipCache.getColor(material))));
            if (flag.method_8035()) {
                tooltips.add((class_2561)class_2561.method_43470((String)material.toString()).method_27692(class_124.field_1063));
            }
            MaterialRegistry.getInstance().getMaterialStats(material.getId(), requirement.getStatType()).ifPresent(stat -> tooltips.addAll(stat.getLocalizedInfo()));
            if (i == max) continue;
            tooltips.add((class_2561)class_2561.method_43473());
        }
    }

    public static void addAttributes(ITinkerStationDisplay item, IToolStackView tool, @Nullable class_1657 player, List<class_2561> tooltip, BiPredicate<class_1320, class_1322.class_1323> showAttribute, class_1304 ... slots) {
        for (class_1304 slot : slots) {
            Multimap<class_1320, class_1322> modifiers = item.getAttributeModifiers(tool, slot);
            if (modifiers.isEmpty()) continue;
            if (slots.length > 1) {
                tooltip.add((class_2561)class_2561.method_43473());
                tooltip.add((class_2561)class_2561.method_43471((String)("item.modifiers." + slot.method_5923())).method_27692(class_124.field_1080));
            }
            for (Map.Entry entry : modifiers.entries()) {
                class_1322 modifier;
                class_1322.class_1323 operation;
                class_1320 attribute = (class_1320)entry.getKey();
                if (!showAttribute.test(attribute, operation = (modifier = (class_1322)entry.getValue()).method_6182())) continue;
                double amount = modifier.method_6186();
                boolean showEquals = false;
                if (player != null) {
                    if (modifier.method_6189() == class_1792.field_8006) {
                        amount += player.method_26826(class_5134.field_23721);
                        showEquals = true;
                    } else if (modifier.method_6189() == class_1792.field_8001) {
                        amount += player.method_26826(class_5134.field_23723);
                        showEquals = true;
                    }
                }
                double displayValue = amount;
                if (modifier.method_6182() == class_1322.class_1323.field_6328) {
                    if (attribute.equals(class_5134.field_23718)) {
                        displayValue *= 10.0;
                    }
                } else {
                    displayValue *= 100.0;
                }
                class_5250 name = class_2561.method_43471((String)attribute.method_26830());
                if (showEquals) {
                    tooltip.add((class_2561)class_2561.method_43470((String)" ").method_10852((class_2561)class_2561.method_43469((String)("attribute.modifier.equals." + operation.method_6191()), (Object[])new Object[]{class_1799.field_8029.format(displayValue), name})).method_27692(class_124.field_1077));
                    continue;
                }
                if (amount > 0.0) {
                    tooltip.add((class_2561)class_2561.method_43469((String)("attribute.modifier.plus." + operation.method_6191()), (Object[])new Object[]{class_1799.field_8029.format(displayValue), name}).method_27692(class_124.field_1078));
                    continue;
                }
                if (!(amount < 0.0)) continue;
                tooltip.add((class_2561)class_2561.method_43469((String)("attribute.modifier.take." + operation.method_6191()), (Object[])new Object[]{class_1799.field_8029.format(displayValue *= -1.0), name}).method_27692(class_124.field_1061));
            }
        }
    }

    public static int getModifierHideFlags(ToolDefinition definition) {
        slimeknights.mantle.client.TooltipKey key = SafeClientAccess.getTooltipKey();
        if (key == slimeknights.mantle.client.TooltipKey.SHIFT || key == slimeknights.mantle.client.TooltipKey.CONTROL && definition.isMultipart()) {
            return MODIFIER_HIDE_FLAGS;
        }
        return DEFAULT_HIDE_FLAGS;
    }
}

