/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.capability;

import io.github.fabricators_of_create.porting_lib.common.util.Lazy;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemItemStorages;
import io.github.fabricators_of_create.porting_lib.transfer.item.SlottedStackStorage;
import io.github.fabricators_of_create.porting_lib.util.LazyOptional;
import io.github.fabricators_of_create.porting_lib.util.NetworkHooks;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.item.base.SingleStackStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1269;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_747;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHook;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.recipe.partbuilder.Pattern;
import slimeknights.tconstruct.library.tools.capability.InventoryModifierHookIterator;
import slimeknights.tconstruct.library.tools.capability.ToolCapabilityProvider;
import slimeknights.tconstruct.library.tools.definition.ToolDefinition;
import slimeknights.tconstruct.library.tools.helper.TooltipUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.tools.menu.ToolContainerMenu;

public class ToolInventoryCapability
extends InventoryModifierHookIterator<ModifierEntry>
implements SlottedStackStorage,
TransactionContext.CloseCallback {
    public static final class_2960 TOTAL_SLOTS = TConstruct.getResource("total_item_slots");
    public static final class_2960 INCLUDE_OFFHAND = TConstruct.getResource("inventory_show_offhand");
    public static final ModifierHook<InventoryModifierHook> HOOK = ModifierHooks.register(TConstruct.getResource("inventory"), InventoryModifierHook.class, new InventoryModifierHook(){

        @Override
        public int getSlots(IToolStackView tool, ModifierEntry modifier) {
            IInventoryModifier inventory = modifier.getModifier().getModule(IInventoryModifier.class);
            if (inventory != null) {
                return inventory.getSlots(tool, modifier.getLevel());
            }
            return 0;
        }

        @Override
        public class_1799 getStack(IToolStackView tool, ModifierEntry modifier, int slot) {
            IInventoryModifier inventory = modifier.getModifier().getModule(IInventoryModifier.class);
            if (inventory != null) {
                return inventory.getStack(tool, modifier.getLevel(), slot);
            }
            return class_1799.field_8037;
        }

        @Override
        public void setStack(IToolStackView tool, ModifierEntry modifier, int slot, class_1799 stack) {
            IInventoryModifier inventory = modifier.getModifier().getModule(IInventoryModifier.class);
            if (inventory != null) {
                inventory.setStack(tool, modifier.getLevel(), slot, stack);
            }
        }

        @Override
        public void updateSnapshots(IToolStackView tool, ModifierEntry modifier, int slot, TransactionContext transaction) {
            IInventoryModifier inventory = modifier.getModifier().getModule(IInventoryModifier.class);
            if (inventory != null) {
                inventory.updateSnapshots(tool, modifier.getLevel(), slot, transaction);
            }
        }

        @Override
        public int getSlotLimit(IToolStackView tool, ModifierEntry modifier, int slot) {
            IInventoryModifier inventory = modifier.getModifier().getModule(IInventoryModifier.class);
            if (inventory != null) {
                return inventory.getSlotLimit(tool, slot);
            }
            return 0;
        }

        @Override
        public boolean isItemValid(IToolStackView tool, ModifierEntry modifier, int slot, ItemVariant stack) {
            IInventoryModifier inventory = modifier.getModifier().getModule(IInventoryModifier.class);
            if (inventory != null) {
                return inventory.isItemValid(tool, slot, stack);
            }
            return false;
        }

        @Override
        @Nullable
        public Pattern getPattern(IToolStackView tool, ModifierEntry modifier, int slot, boolean hasStack) {
            IInventoryModifier inventory = modifier.getModifier().getModule(IInventoryModifier.class);
            if (inventory != null) {
                return inventory.getPattern(tool, modifier.getLevel(), slot, hasStack);
            }
            return null;
        }
    }, InventoryModifierHookMerger::new);
    private final ContainerItemContext container;
    private final Supplier<? extends IToolStackView> tool;
    private class_1799[] cachedStacks;
    private int slots = -1;
    private final List<class_1799[]> snapshots = new ArrayList<class_1799[]>();

    @Nullable
    public static ToolInventoryCapability getCap(ContainerItemContext context, class_1799 stack) {
        if (ToolStack.from(stack).getVolatileData().getInt(TOTAL_SLOTS) > 0) {
            return new ToolInventoryCapability(context, (Supplier<? extends IToolStackView>)Lazy.of(() -> ToolStack.from(stack)));
        }
        return null;
    }

    public int getSlotCount() {
        if (this.slots == -1) {
            this.slots = this.tool.get().getVolatileData().getInt(TOTAL_SLOTS);
        }
        return this.slots;
    }

    public SingleSlotStorage<ItemVariant> getSlot(int slot) {
        return new ToolInventoryStack(slot, this);
    }

    @Override
    protected Iterator<ModifierEntry> getIterator(IToolStackView tool) {
        return new ReversedListIterator<ModifierEntry>(tool.getModifierList());
    }

    @Override
    protected InventoryModifierHook getHook(ModifierEntry entry) {
        this.indexEntry = entry;
        return entry.getHook(HOOK);
    }

    public static boolean isBlacklisted(class_1799 stack) {
        return !stack.method_7909().method_31568() || stack.method_31573(TinkerTags.Items.TOOL_INVENTORY_BLACKLIST) || ItemItemStorages.ITEM.find(stack, (Object)ContainerItemContext.withConstant((class_1799)stack)) != null;
    }

    public boolean isItemValid(int slot, ItemVariant stack, int count) {
        if (!stack.isBlank() && ToolInventoryCapability.isBlacklisted(stack.toStack(count))) {
            return false;
        }
        IToolStackView tool = this.tool.get();
        InventoryModifierHook inventory = (InventoryModifierHook)this.findHook(tool, slot);
        if (inventory != null) {
            return inventory.isItemValid(tool, this.indexEntry, slot - this.startIndex, stack);
        }
        return false;
    }

    public int getSlotLimit(int slot) {
        IToolStackView tool = this.tool.get();
        InventoryModifierHook inventory = (InventoryModifierHook)this.findHook(tool, slot);
        if (inventory != null) {
            return inventory.getSlotLimit(tool, this.indexEntry, slot - this.startIndex);
        }
        return 0;
    }

    private void clearCache() {
        this.slots = -1;
        this.cachedStacks = null;
    }

    private void cacheStack(int slot, class_1799 stack) {
        int slots;
        if (slot >= 0 && slot < (slots = this.getSlotCount())) {
            if (this.cachedStacks == null) {
                this.cachedStacks = new class_1799[this.getSlotCount()];
            }
            this.cachedStacks[slot] = stack;
        }
    }

    @Nullable
    private class_1799 getCachedStack(int slot) {
        if (this.cachedStacks != null && slot >= 0 && slot < this.getSlotCount()) {
            return this.cachedStacks[slot];
        }
        return null;
    }

    private void setAndCache(InventoryModifierHook inventory, int localSlot, int globalSlot, class_1799 stack) {
        inventory.setStack(this.tool.get(), this.indexEntry, localSlot, stack);
        this.cacheStack(globalSlot, stack);
    }

    public void setStackInSlot(int slot, class_1799 stack) {
        InventoryModifierHook inventory = (InventoryModifierHook)this.findHook(this.tool.get(), slot);
        if (inventory != null) {
            this.setAndCache(inventory, slot - this.startIndex, slot, stack);
        }
    }

    private class_1799 getAndCache(InventoryModifierHook inventory, int localSlot, int globalSlot) {
        class_1799 stack = inventory.getStack(this.tool.get(), this.indexEntry, localSlot);
        this.cacheStack(globalSlot, stack);
        return stack;
    }

    private class_1799 getCached(InventoryModifierHook inventory, int localSlot, int globalSlot) {
        class_1799 stack = this.getCachedStack(globalSlot);
        if (stack == null) {
            stack = this.getAndCache(inventory, localSlot, globalSlot);
        }
        return stack;
    }

    @Nonnull
    public class_1799 getStackInSlot(int slot) {
        class_1799 cached = this.getCachedStack(slot);
        if (cached != null) {
            return cached;
        }
        InventoryModifierHook inventory = (InventoryModifierHook)this.findHook(this.tool.get(), slot);
        if (inventory != null) {
            return this.getAndCache(inventory, slot - this.startIndex, slot);
        }
        return class_1799.field_8037;
    }

    public long insertSlot(int slot, ItemVariant resource, long maxAmount, TransactionContext transaction) {
        if (resource.isBlank()) {
            return 0L;
        }
        if (ToolInventoryCapability.isBlacklisted(resource.toStack())) {
            return 0L;
        }
        IToolStackView tool = this.tool.get();
        InventoryModifierHook inventory = (InventoryModifierHook)this.findHook(tool, slot);
        if (inventory == null) {
            return 0L;
        }
        int localSlot = slot - this.startIndex;
        if (!inventory.isItemValid(tool, this.indexEntry, localSlot, resource)) {
            return 0L;
        }
        class_1799 current = this.getCached(inventory, localSlot, slot);
        int slotLimit = inventory.getSlotLimit(tool, this.indexEntry, localSlot);
        if (current.method_7960()) {
            long canInsert = Math.min(maxAmount, (long)Math.min(resource.getItem().method_7882(), slotLimit));
            this.updateSnapshots(transaction);
            inventory.updateSnapshots(tool, this.indexEntry, localSlot, transaction);
            this.setAndCache(inventory, localSlot, slot, resource.toStack((int)canInsert));
            return canInsert;
        }
        int limit = Math.min(current.method_7914(), slotLimit);
        if (current.method_7947() >= limit || !current.method_31574(resource.getItem())) {
            return 0L;
        }
        long maxSize = (long)current.method_7947() + maxAmount;
        long newSize = Math.min(maxSize, (long)limit);
        this.updateSnapshots(transaction);
        inventory.updateSnapshots(tool, this.indexEntry, localSlot, transaction);
        current.method_7939((int)newSize);
        inventory.setStack(tool, this.indexEntry, localSlot, current);
        return newSize;
    }

    public long extractSlot(int slot, ItemVariant resource, long amount, TransactionContext transaction) {
        if (amount <= 0L) {
            return 0L;
        }
        IToolStackView tool = this.tool.get();
        InventoryModifierHook inventory = (InventoryModifierHook)this.findHook(tool, slot);
        if (inventory == null) {
            return 0L;
        }
        int localSlot = slot - this.startIndex;
        class_1799 current = this.getCached(inventory, localSlot, slot);
        if (current.method_7960()) {
            return 0L;
        }
        if (amount > (long)current.method_7947()) {
            amount = current.method_7947();
        }
        this.updateSnapshots(transaction);
        inventory.updateSnapshots(tool, this.indexEntry, localSlot, transaction);
        if (amount == (long)current.method_7947()) {
            this.setAndCache(inventory, localSlot, slot, class_1799.field_8037);
        } else {
            current.method_7934((int)amount);
            inventory.setStack(tool, this.indexEntry, localSlot, current);
        }
        return amount;
    }

    public long insert(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        long inserted = maxAmount;
        for (int i = 0; i < this.cachedStacks.length && (maxAmount -= (inserted += this.insertSlot(i, resource, maxAmount, transaction))) != 0L; ++i) {
        }
        return inserted;
    }

    public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        long extracted = maxAmount;
        for (int i = 0; i < this.cachedStacks.length && (maxAmount -= (extracted += this.extractSlot(i, resource, maxAmount, transaction))) != 0L; ++i) {
        }
        return extracted;
    }

    public void updateSnapshots(TransactionContext transaction) {
        while (this.snapshots.size() <= transaction.nestingDepth()) {
            this.snapshots.add(null);
        }
        if (this.snapshots.get(transaction.nestingDepth()) == null) {
            class_1799[] snapshot = this.createSnapshot();
            Objects.requireNonNull(snapshot, "Snapshot may not be null!");
            this.snapshots.set(transaction.nestingDepth(), snapshot);
            transaction.addCloseCallback((TransactionContext.CloseCallback)this);
        }
    }

    protected class_1799[] createSnapshot() {
        return Arrays.copyOf(this.cachedStacks, this.cachedStacks.length);
    }

    protected void readSnapshot(class_1799[] snapshot) {
        this.cachedStacks = snapshot;
    }

    public void onClose(TransactionContext transaction, TransactionContext.Result result) {
        class_1799[] snapshot = this.snapshots.set(transaction.nestingDepth(), null);
        if (result.wasAborted()) {
            this.readSnapshot(snapshot);
        } else if (transaction.nestingDepth() > 0 && this.snapshots.get(transaction.nestingDepth() - 1) == null) {
            this.snapshots.set(transaction.nestingDepth() - 1, snapshot);
            transaction.getOpenTransaction(transaction.nestingDepth() - 1).addCloseCallback((TransactionContext.CloseCallback)this);
        }
    }

    public static void addSlots(ModDataNBT volatileData, int count) {
        volatileData.putInt(TOTAL_SLOTS, volatileData.getInt(TOTAL_SLOTS) + count);
    }

    public static class_1269 tryOpenContainer(class_1799 stack, IToolStackView tool, class_1657 player, class_1304 slotType) {
        return ToolInventoryCapability.tryOpenContainer(stack, tool, tool.getDefinition(), player, slotType);
    }

    public static class_1269 tryOpenContainer(class_1799 stack, @Nullable IToolStackView tool, ToolDefinition definition, class_1657 player, class_1304 slotType) {
        Storage handler = (Storage)ItemItemStorages.ITEM.find(stack, (Object)ContainerItemContext.withConstant((class_1799)stack));
        if (handler != null && handler instanceof SlottedStackStorage) {
            SlottedStackStorage storage = (SlottedStackStorage)handler;
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                NetworkHooks.openScreen((class_3222)serverPlayer, (class_3908)new class_747((id, inventory, p) -> new ToolContainerMenu(id, inventory, stack, storage, slotType), TooltipUtil.getDisplayName(stack, tool, definition)), buf -> buf.method_10817((Enum)slotType));
            }
            return class_1269.method_29236((boolean)player.method_37908().field_9236);
        }
        return class_1269.field_5811;
    }

    public ToolInventoryCapability(ContainerItemContext container, Supplier<? extends IToolStackView> tool) {
        this.container = container;
        this.tool = tool;
    }

    public ContainerItemContext getContainer() {
        return this.container;
    }

    public static class ToolInventoryStack
    extends SingleStackStorage {
        private final int index;
        public final ToolInventoryCapability capability;

        protected class_1799 getStack() {
            return this.capability.cachedStacks[this.index];
        }

        protected void setStack(class_1799 stack) {
            this.capability.cachedStacks[this.index] = stack;
        }

        public ToolInventoryStack(int index, ToolInventoryCapability capability) {
            this.index = index;
            this.capability = capability;
        }
    }

    private static class ReversedListIterator<T>
    implements Iterator<T> {
        private final List<T> list;
        private int index;

        public ReversedListIterator(List<T> list) {
            this.list = list;
            this.index = list.size() - 1;
        }

        @Override
        public boolean hasNext() {
            return this.index >= 0;
        }

        @Override
        public T next() {
            T element = this.list.get(this.index);
            --this.index;
            return element;
        }
    }

    public static interface InventoryModifierHook {
        public int getSlots(IToolStackView var1, ModifierEntry var2);

        public class_1799 getStack(IToolStackView var1, ModifierEntry var2, int var3);

        public void setStack(IToolStackView var1, ModifierEntry var2, int var3, class_1799 var4);

        public void updateSnapshots(IToolStackView var1, ModifierEntry var2, int var3, TransactionContext var4);

        default public int getSlotLimit(IToolStackView tool, ModifierEntry modifier, int slot) {
            return 64;
        }

        default public boolean isItemValid(IToolStackView tool, ModifierEntry modifier, int slot, ItemVariant stack) {
            return true;
        }

        @Nullable
        default public Pattern getPattern(IToolStackView tool, ModifierEntry modifier, int slot, boolean hasStack) {
            return null;
        }
    }

    public static class Provider
    implements ToolCapabilityProvider.IToolCapabilityProvider {
        private final LazyOptional<ToolInventoryCapability> handler = LazyOptional.of(() -> new ToolInventoryCapability(stack, tool));

        public Provider(ContainerItemContext stack, Supplier<? extends IToolStackView> tool) {
        }

        @Override
        public void clearCache() {
            this.handler.ifPresent(ToolInventoryCapability::clearCache);
        }
    }

    private static class InventoryModifierHookMerger
    extends InventoryModifierHookIterator<InventoryModifierHook>
    implements InventoryModifierHook {
        private final Collection<InventoryModifierHook> modules;

        @Override
        protected Iterator<InventoryModifierHook> getIterator(IToolStackView tool) {
            return this.modules.iterator();
        }

        @Override
        protected InventoryModifierHook getHook(InventoryModifierHook hook) {
            return hook;
        }

        @Nullable
        private InventoryModifierHook findHook(IToolStackView tool, ModifierEntry modifier, int slot) {
            this.indexEntry = modifier;
            return (InventoryModifierHook)this.findHook(tool, slot);
        }

        @Override
        public int getSlots(IToolStackView tool, ModifierEntry modifier) {
            int sum = 0;
            for (InventoryModifierHook module : this.modules) {
                sum += module.getSlots(tool, modifier);
            }
            return sum;
        }

        @Override
        public class_1799 getStack(IToolStackView tool, ModifierEntry modifier, int slot) {
            InventoryModifierHook module = this.findHook(tool, modifier, slot);
            if (module != null) {
                return module.getStack(tool, modifier, slot - this.startIndex);
            }
            return class_1799.field_8037;
        }

        @Override
        public void setStack(IToolStackView tool, ModifierEntry modifier, int slot, class_1799 stack) {
            InventoryModifierHook module = this.findHook(tool, modifier, slot);
            if (module != null) {
                module.setStack(tool, modifier, slot - this.startIndex, stack);
            }
        }

        @Override
        public void updateSnapshots(IToolStackView tool, ModifierEntry modifier, int slot, TransactionContext transaction) {
            InventoryModifierHook module = this.findHook(tool, modifier, slot);
            if (module != null) {
                module.updateSnapshots(tool, modifier, slot - this.startIndex, transaction);
            }
        }

        @Override
        public int getSlotLimit(IToolStackView tool, ModifierEntry modifier, int slot) {
            InventoryModifierHook module = this.findHook(tool, modifier, slot);
            if (module != null) {
                return module.getSlotLimit(tool, modifier, slot - this.startIndex);
            }
            return 0;
        }

        @Override
        public boolean isItemValid(IToolStackView tool, ModifierEntry modifier, int slot, ItemVariant stack) {
            InventoryModifierHook module = this.findHook(tool, modifier, slot);
            if (module != null) {
                return module.isItemValid(tool, modifier, slot - this.startIndex, stack);
            }
            return false;
        }

        @Override
        @Nullable
        public Pattern getPattern(IToolStackView tool, ModifierEntry modifier, int slot, boolean hasStack) {
            InventoryModifierHook module = this.findHook(tool, modifier, slot);
            if (module != null) {
                return module.getPattern(tool, modifier, slot - this.startIndex, hasStack);
            }
            return null;
        }

        public InventoryModifierHookMerger(Collection<InventoryModifierHook> modules) {
            this.modules = modules;
        }
    }

    @Deprecated
    public static interface IInventoryModifier {
        public int getSlots(IToolStackView var1, int var2);

        public class_1799 getStack(IToolStackView var1, int var2, int var3);

        public void setStack(IToolStackView var1, int var2, int var3, class_1799 var4);

        public void updateSnapshots(IToolStackView var1, int var2, int var3, TransactionContext var4);

        default public int getSlotLimit(IToolStackView tool, int slot) {
            return 64;
        }

        default public boolean isItemValid(IToolStackView tool, int slot, ItemVariant stack) {
            return true;
        }

        @Nullable
        default public Pattern getPattern(IToolStackView tool, int level, int slot, boolean hasStack) {
            return null;
        }
    }
}

