/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.capability;

import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.base.SingleFluidStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_2960;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHook;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.tools.capability.FluidModifierHookIterator;
import slimeknights.tconstruct.library.tools.capability.ToolCapabilityProvider;
import slimeknights.tconstruct.library.tools.nbt.IModDataView;
import slimeknights.tconstruct.library.tools.nbt.IToolContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;

public class ToolFluidCapability
extends FluidModifierHookIterator<ModifierEntry>
implements SingleSlotStorage<FluidVariant> {
    public static final class_2960 TOTAL_TANKS = TConstruct.getResource("total_tanks");
    public static final ModifierHook<FluidModifierHook> HOOK = ModifierHooks.register(TConstruct.getResource("fluid"), FluidModifierHook.class, new FluidModifierHook(){

        @Override
        public int getTanks(IToolContext tool, Modifier modifier) {
            IFluidModifier hook = modifier.getModule(IFluidModifier.class);
            if (hook != null) {
                return hook.getTanks(tool.getVolatileData());
            }
            return 0;
        }

        @Override
        public SingleSlotStorage<FluidVariant> getSlot(IToolStackView tool, ModifierEntry modifier, int tank) {
            IFluidModifier hook = modifier.getModifier().getModule(IFluidModifier.class);
            if (hook != null) {
                return hook.getSlot(tool, modifier.getLevel(), tank);
            }
            return SingleFluidStorage.withFixedCapacity((long)0L, () -> {});
        }

        @Override
        public FluidStack getFluidInTank(IToolStackView tool, ModifierEntry modifier, int tank) {
            IFluidModifier hook = modifier.getModifier().getModule(IFluidModifier.class);
            if (hook != null) {
                return hook.getFluidInTank(tool, modifier.getLevel(), tank);
            }
            return FluidStack.EMPTY;
        }

        @Override
        public long getTankCapacity(IToolStackView tool, ModifierEntry modifier, int tank) {
            IFluidModifier hook = modifier.getModifier().getModule(IFluidModifier.class);
            if (hook != null) {
                return hook.getTankCapacity(tool, modifier.getLevel(), tank);
            }
            return 0L;
        }

        @Override
        public boolean isFluidValid(IToolStackView tool, ModifierEntry modifier, int tank, FluidStack fluid) {
            IFluidModifier hook = modifier.getModifier().getModule(IFluidModifier.class);
            if (hook != null) {
                return hook.isFluidValid(tool, modifier.getLevel(), tank, fluid);
            }
            return false;
        }

        @Override
        public long fill(ContainerItemContext context, IToolStackView tool, ModifierEntry modifier, FluidVariant resource, long maxAmount, TransactionContext tx) {
            IFluidModifier hook = modifier.getModifier().getModule(IFluidModifier.class);
            if (hook != null) {
                return hook.fill(context, tool, modifier.getLevel(), resource, maxAmount, tx);
            }
            return 0L;
        }

        @Override
        public long drain(ContainerItemContext context, IToolStackView tool, ModifierEntry modifier, FluidVariant resource, long maxAmount, TransactionContext tx) {
            IFluidModifier hook = modifier.getModifier().getModule(IFluidModifier.class);
            if (hook != null) {
                return hook.drain(context, tool, modifier.getLevel(), resource, maxAmount, tx);
            }
            return 0L;
        }
    }, FluidModifierHookMerger::new);
    private final ContainerItemContext container;
    private final Supplier<? extends IToolStackView> tool;

    public int getSlotCount() {
        return this.tool.get().getVolatileData().getInt(TOTAL_TANKS);
    }

    @Override
    protected Iterator<ModifierEntry> getIterator(IToolStackView tool) {
        return tool.getModifierList().iterator();
    }

    @Override
    protected FluidModifierHook getHook(ModifierEntry entry) {
        this.indexEntry = entry;
        return entry.getHook(HOOK);
    }

    public SingleSlotStorage<FluidVariant> getSlot(int tank) {
        IToolStackView tool = this.tool.get();
        FluidModifierHook hook = (FluidModifierHook)this.findHook(tool, tank);
        if (hook != null) {
            return hook.getSlot(tool, this.indexEntry, tank - this.startIndex);
        }
        return SingleFluidStorage.withFixedCapacity((long)0L, () -> {});
    }

    public long insert(FluidVariant resource, long maxAmount, TransactionContext tx) {
        return this.fill(this.container, this.tool.get(), resource, maxAmount, tx);
    }

    public long extract(FluidVariant resource, long maxAmount, TransactionContext transaction) {
        return this.drain(this.container, this.tool.get(), resource, maxAmount, transaction);
    }

    public boolean isResourceBlank() {
        IToolStackView tool = this.tool.get();
        FluidModifierHook hook = (FluidModifierHook)this.findHook(tool, 0);
        if (hook != null) {
            return hook.getFluidInTank(tool, this.indexEntry, this.startIndex).getType().isBlank();
        }
        return true;
    }

    public FluidVariant getResource() {
        IToolStackView tool = this.tool.get();
        FluidModifierHook hook = (FluidModifierHook)this.findHook(tool, 0);
        if (hook != null) {
            return hook.getFluidInTank(tool, this.indexEntry, this.startIndex).getType();
        }
        return FluidVariant.blank();
    }

    public long getAmount() {
        IToolStackView tool = this.tool.get();
        FluidModifierHook hook = (FluidModifierHook)this.findHook(tool, 0);
        if (hook != null) {
            return hook.getFluidInTank(tool, this.indexEntry, this.startIndex).getAmount();
        }
        return 0L;
    }

    public long getCapacity() {
        IToolStackView tool = this.tool.get();
        FluidModifierHook hook = (FluidModifierHook)this.findHook(tool, 0);
        if (hook != null) {
            return hook.getTankCapacity(tool, this.indexEntry, this.startIndex);
        }
        return 0L;
    }

    @Deprecated
    public static void addTanks(ModDataNBT volatileData, IFluidModifier modifier) {
        volatileData.putInt(TOTAL_TANKS, modifier.getTanks(volatileData) + volatileData.getInt(TOTAL_TANKS));
    }

    public static void addTanks(IToolContext tool, Modifier modifier, ModDataNBT volatileData, FluidModifierHook hook) {
        volatileData.putInt(TOTAL_TANKS, hook.getTanks(tool, modifier) + volatileData.getInt(TOTAL_TANKS));
    }

    public ToolFluidCapability(ContainerItemContext container, Supplier<? extends IToolStackView> tool) {
        this.container = container;
        this.tool = tool;
    }

    public ContainerItemContext getContainer() {
        return this.container;
    }

    public static interface FluidModifierHook {
        default public int getTanks(IToolContext tool, Modifier modifier) {
            return 1;
        }

        public SingleSlotStorage<FluidVariant> getSlot(IToolStackView var1, ModifierEntry var2, int var3);

        default public FluidStack getFluidInTank(IToolStackView tool, ModifierEntry modifier, int tank) {
            return FluidStack.EMPTY;
        }

        default public long getTankCapacity(IToolStackView tool, ModifierEntry modifier, int tank) {
            return 0L;
        }

        default public boolean isFluidValid(IToolStackView tool, ModifierEntry modifier, int tank, FluidStack fluid) {
            return true;
        }

        public long fill(ContainerItemContext var1, IToolStackView var2, ModifierEntry var3, FluidVariant var4, long var5, TransactionContext var7);

        public long drain(ContainerItemContext var1, IToolStackView var2, ModifierEntry var3, FluidVariant var4, long var5, TransactionContext var7);
    }

    @Deprecated
    public static interface IFluidModifier {
        default public int getTanks(IModDataView volatileData) {
            return 0;
        }

        default public SingleSlotStorage<FluidVariant> getSlot(IToolStackView tool, int level, int tank) {
            return SingleFluidStorage.withFixedCapacity((long)0L, () -> {});
        }

        default public FluidStack getFluidInTank(IToolStackView tool, int level, int tank) {
            return FluidStack.EMPTY;
        }

        default public long getTankCapacity(IToolStackView tool, int level, int tank) {
            return 0L;
        }

        default public boolean isFluidValid(IToolStackView tool, int level, int tank, FluidStack fluid) {
            return true;
        }

        public long fill(ContainerItemContext var1, IToolStackView var2, int var3, FluidVariant var4, long var5, TransactionContext var7);

        public long drain(ContainerItemContext var1, IToolStackView var2, int var3, FluidVariant var4, long var5, TransactionContext var7);
    }

    public static class Provider
    implements ToolCapabilityProvider.IToolCapabilityProvider {
        public Provider(ContainerItemContext stack, Supplier<? extends IToolStackView> toolStack) {
        }
    }

    private static class FluidModifierHookMerger
    extends FluidModifierHookIterator<FluidModifierHook>
    implements FluidModifierHook {
        private final Collection<FluidModifierHook> modules;

        @Override
        protected Iterator<FluidModifierHook> getIterator(IToolStackView tool) {
            return this.modules.iterator();
        }

        @Override
        protected FluidModifierHook getHook(FluidModifierHook entry) {
            return entry;
        }

        @Nullable
        private FluidModifierHook findHook(IToolStackView tool, ModifierEntry modifier, int tank) {
            this.indexEntry = modifier;
            return (FluidModifierHook)this.findHook(tool, tank);
        }

        @Override
        public int getTanks(IToolContext tool, Modifier modifier) {
            int sum = 0;
            for (FluidModifierHook module : this.modules) {
                sum += module.getTanks(tool, modifier);
            }
            return sum;
        }

        @Override
        public SingleSlotStorage<FluidVariant> getSlot(IToolStackView tool, ModifierEntry modifier, int tank) {
            FluidModifierHook hook = this.findHook(tool, modifier, tank);
            if (hook != null) {
                return hook.getSlot(tool, modifier, tank - this.startIndex);
            }
            return SingleFluidStorage.withFixedCapacity((long)0L, () -> {});
        }

        @Override
        public long getTankCapacity(IToolStackView tool, ModifierEntry modifier, int tank) {
            FluidModifierHook hook = this.findHook(tool, modifier, tank);
            if (hook != null) {
                return hook.getTankCapacity(tool, modifier, tank - this.startIndex);
            }
            return 0L;
        }

        @Override
        public boolean isFluidValid(IToolStackView tool, ModifierEntry modifier, int tank, FluidStack fluid) {
            FluidModifierHook hook = this.findHook(tool, modifier, tank);
            if (hook != null) {
                return hook.isFluidValid(tool, modifier, tank - this.startIndex, fluid);
            }
            return false;
        }

        @Override
        public long fill(ContainerItemContext context, IToolStackView tool, ModifierEntry modifier, FluidVariant resource, long maxAmount, TransactionContext tx) {
            this.indexEntry = modifier;
            return this.fill(context, tool, resource, maxAmount, tx);
        }

        @Override
        public long drain(ContainerItemContext context, IToolStackView tool, ModifierEntry modifier, FluidVariant resource, long maxAmount, TransactionContext tx) {
            this.indexEntry = modifier;
            return this.drain(context, tool, resource, maxAmount, tx);
        }

        public FluidModifierHookMerger(Collection<FluidModifierHook> modules) {
            this.modules = modules;
        }
    }
}

