/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.tinkerstation.repairing;

import com.mojang.datafixers.util.Pair;
import java.util.Iterator;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_1852;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_5455;
import net.minecraft.class_7710;
import net.minecraft.class_8566;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.recipe.tinkerstation.repairing.ModifierRepairRecipeSerializer;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class ModifierRepairCraftingRecipe
extends class_1852
implements ModifierRepairRecipeSerializer.IModifierRepairRecipe {
    private final ModifierId modifier;
    private final class_1856 ingredient;
    private final int repairAmount;

    public ModifierRepairCraftingRecipe(class_2960 idIn, ModifierId modifier, class_1856 ingredient, int repairAmount) {
        super(idIn, class_7710.field_40251);
        this.modifier = modifier;
        this.ingredient = ingredient;
        this.repairAmount = repairAmount;
    }

    @Nullable
    protected Pair<ToolStack, Integer> getRelevantInputs(class_8566 inv) {
        ToolStack tool = null;
        int itemsFound = 0;
        int modifierLevel = 0;
        for (int i = 0; i < inv.method_5439(); ++i) {
            class_1799 stack = inv.method_5438(i);
            if (stack.method_7960()) continue;
            if (stack.method_31573(TinkerTags.Items.DURABILITY)) {
                if (tool != null) {
                    return null;
                }
                tool = ToolStack.from(stack);
                if (!tool.isBroken() && tool.getDamage() == 0) {
                    return null;
                }
                modifierLevel = tool.getModifierLevel(this.modifier);
                if (modifierLevel != 0) continue;
                return null;
            }
            if (this.ingredient.method_8093(stack)) {
                ++itemsFound;
                continue;
            }
            return null;
        }
        if (tool == null || itemsFound == 0) {
            return null;
        }
        return Pair.of(tool, (Object)(this.repairAmount * itemsFound * modifierLevel));
    }

    public boolean matches(class_8566 inv, class_1937 world) {
        return this.getRelevantInputs(inv) != null;
    }

    public class_1799 assemble(class_8566 inv, class_5455 registryAccess) {
        Pair<ToolStack, Integer> inputs = this.getRelevantInputs(inv);
        if (inputs == null) {
            TConstruct.LOG.error("Recipe repair on {} failed to find items after matching", (Object)this.method_8114());
            return class_1799.field_8037;
        }
        float repairAmount = ((Integer)inputs.getSecond()).intValue();
        ToolStack tool = (ToolStack)inputs.getFirst();
        for (ModifierEntry entry : tool.getModifierList()) {
            repairAmount = entry.getHook(TinkerHooks.REPAIR_FACTOR).getRepairFactor(tool, entry, repairAmount);
            if (!(repairAmount <= 0.0f)) continue;
            return class_1799.field_8037;
        }
        tool = tool.copy();
        ToolDamageUtil.repair(tool, (int)repairAmount);
        return tool.createStack();
    }

    public class_2371<class_1799> getRemainingItems(class_8566 inv) {
        class_2371 list = class_2371.method_10213((int)inv.method_5439(), (Object)class_1799.field_8037);
        Pair<ToolStack, Integer> inputs = this.getRelevantInputs(inv);
        int repairPerItem = 0;
        int repairNeeded = 0;
        if (inputs != null) {
            ToolStack tool = (ToolStack)inputs.getFirst();
            repairNeeded = tool.getDamage();
            float repairFloat = tool.getModifierLevel(this.modifier) * this.repairAmount;
            if (repairFloat > 0.0f) {
                ModifierEntry entry;
                Iterator<ModifierEntry> iterator = tool.getModifierList().iterator();
                while (iterator.hasNext() && !((repairFloat = (entry = iterator.next()).getHook(TinkerHooks.REPAIR_FACTOR).getRepairFactor(tool, entry, repairFloat)) <= 0.0f)) {
                }
                repairPerItem = (int)repairFloat;
            }
        }
        for (int i = 0; i < inv.method_5439(); ++i) {
            class_1799 remainder;
            class_1799 stack = inv.method_5438(i);
            if (this.ingredient.method_8093(stack)) {
                if (repairNeeded <= 0) continue;
                repairNeeded -= repairPerItem;
            }
            if ((remainder = stack.getRecipeRemainder()) == null || remainder.method_7960()) continue;
            list.set(i, (Object)remainder);
        }
        return list;
    }

    public boolean method_8113(int width, int height) {
        return width * height >= 2;
    }

    public class_1865<?> method_8119() {
        return (class_1865)TinkerModifiers.craftingModifierRepair.get();
    }

    @Override
    public ModifierId getModifier() {
        return this.modifier;
    }

    @Override
    public class_1856 getIngredient() {
        return this.ingredient;
    }

    @Override
    public int getRepairAmount() {
        return this.repairAmount;
    }
}

