/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.molding;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import slimeknights.mantle.recipe.ICommonRecipe;
import slimeknights.mantle.recipe.helper.ItemOutput;
import slimeknights.mantle.recipe.helper.LoggingRecipeSerializer;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.library.recipe.TinkerRecipeTypes;
import slimeknights.tconstruct.library.recipe.molding.IMoldingContainer;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public abstract class MoldingRecipe
implements ICommonRecipe<IMoldingContainer> {
    private final class_2960 id;
    private final class_1856 material;
    private final class_1856 pattern;
    private final boolean patternConsumed;
    private final ItemOutput recipeOutput;

    public boolean matches(IMoldingContainer inv, class_1937 worldIn) {
        return this.material.method_8093(inv.getMaterial()) && this.pattern.method_8093(inv.getPattern());
    }

    public class_2371<class_1856> method_8117() {
        return class_2371.method_10212((Object)class_1856.field_9017, (Object[])new class_1856[]{this.material, this.pattern});
    }

    public class_1799 method_8110(class_5455 registryAccess) {
        return this.recipeOutput.get();
    }

    public MoldingRecipe(class_2960 id, class_1856 material, class_1856 pattern, boolean patternConsumed, ItemOutput recipeOutput) {
        this.id = id;
        this.material = material;
        this.pattern = pattern;
        this.patternConsumed = patternConsumed;
        this.recipeOutput = recipeOutput;
    }

    public class_2960 method_8114() {
        return this.id;
    }

    public class_1856 getMaterial() {
        return this.material;
    }

    public class_1856 getPattern() {
        return this.pattern;
    }

    public boolean isPatternConsumed() {
        return this.patternConsumed;
    }

    public static class Serializer<T extends MoldingRecipe>
    extends LoggingRecipeSerializer<T> {
        private final IFactory<T> factory;

        public T fromJson(class_2960 id, JsonObject json) {
            class_1856 material = class_1856.method_52177((JsonElement)JsonHelper.getElement((JsonObject)json, (String)"material"));
            class_1856 pattern = class_1856.field_9017;
            boolean patternConsumed = false;
            if (json.has("pattern")) {
                pattern = class_1856.method_52177((JsonElement)json.get("pattern"));
                patternConsumed = class_3518.method_15258((JsonObject)json, (String)"pattern_consumed", (boolean)false);
            }
            ItemOutput output = ItemOutput.fromJson((JsonElement)json.get("result"));
            return this.factory.create(id, material, pattern, patternConsumed, output);
        }

        @Nullable
        protected T fromNetworkSafe(class_2960 id, class_2540 buffer) {
            class_1856 material = class_1856.method_8086((class_2540)buffer);
            class_1856 mold = class_1856.method_8086((class_2540)buffer);
            boolean moldConsumed = buffer.readBoolean();
            ItemOutput output = ItemOutput.read((class_2540)buffer);
            return this.factory.create(id, material, mold, moldConsumed, output);
        }

        protected void toNetworkSafe(class_2540 buffer, MoldingRecipe recipe) {
            recipe.material.method_8088(buffer);
            recipe.pattern.method_8088(buffer);
            buffer.writeBoolean(recipe.patternConsumed);
            recipe.recipeOutput.write(buffer);
        }

        public Serializer(IFactory<T> factory) {
            this.factory = factory;
        }
    }

    @FunctionalInterface
    public static interface IFactory<T extends MoldingRecipe> {
        public T create(class_2960 var1, class_1856 var2, class_1856 var3, boolean var4, ItemOutput var5);
    }

    public static class Basin
    extends MoldingRecipe {
        public Basin(class_2960 id, class_1856 material, class_1856 mold, boolean moldConsumed, ItemOutput recipeOutput) {
            super(id, material, mold, moldConsumed, recipeOutput);
        }

        public class_1865<?> method_8119() {
            return (class_1865)TinkerSmeltery.moldingBasinSerializer.get();
        }

        public class_3956<?> method_17716() {
            return (class_3956)TinkerRecipeTypes.MOLDING_BASIN.get();
        }
    }

    public static class Table
    extends MoldingRecipe {
        public Table(class_2960 id, class_1856 material, class_1856 mold, boolean moldConsumed, ItemOutput recipeOutput) {
            super(id, material, mold, moldConsumed, recipeOutput);
        }

        public class_1865<?> method_8119() {
            return (class_1865)TinkerSmeltery.moldingTableSerializer.get();
        }

        public class_3956<?> method_17716() {
            return (class_3956)TinkerRecipeTypes.MOLDING_TABLE.get();
        }
    }
}

