/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.modifiers;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_2540;
import net.minecraft.class_3518;
import net.minecraft.class_6862;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.ModifierManager;
import slimeknights.tconstruct.library.modifiers.util.LazyModifier;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;

public abstract class ModifierMatch
implements Predicate<List<ModifierEntry>> {
    public static final ModifierMatch ALWAYS = new ListMatch(Collections.emptyList(), 0);

    public static ModifierMatch entry(ModifierId modifier, int level) {
        return new EntryMatch(new ModifierEntry(modifier, level));
    }

    public static ModifierMatch entry(LazyModifier modifier, int level) {
        return new EntryMatch(new ModifierEntry(modifier, level));
    }

    public static ModifierMatch entry(ModifierId modifier) {
        return new EntryMatch(new ModifierEntry(modifier, 1));
    }

    public static ModifierMatch entry(LazyModifier modifier) {
        return new EntryMatch(new ModifierEntry(modifier, 1));
    }

    public static ModifierMatch tag(class_6862<Modifier> tag, int level, int required) {
        return new TagMatch(tag, level, required);
    }

    public static ModifierMatch tag(class_6862<Modifier> tag, int level) {
        return ModifierMatch.tag(tag, level, 1);
    }

    public static ModifierMatch tag(class_6862<Modifier> tag) {
        return ModifierMatch.tag(tag, 1);
    }

    public static ModifierMatch list(int required, ModifierMatch ... matches) {
        return new ListMatch(Arrays.asList(matches), required);
    }

    public static ModifierMatch list(ModifierMatch ... matches) {
        return new ListMatch(Arrays.asList(matches), 1);
    }

    public static ModifierMatch deserialize(JsonObject json) {
        int required = class_3518.method_15282((JsonObject)json, (String)"matches_needed", (int)1);
        if (required == 0) {
            return ALWAYS;
        }
        if (json.has("options")) {
            List options = JsonHelper.parseList((JsonObject)json, (String)"options", ModifierMatch::deserialize);
            return new ListMatch(options, required);
        }
        if (json.has("tag")) {
            class_6862<Modifier> tag = ModifierManager.getTag(JsonHelper.getResourceLocation((JsonObject)json, (String)"tag"));
            int level = class_3518.method_15260((JsonObject)json, (String)"level");
            return new TagMatch(tag, level, required);
        }
        ModifierEntry entry = ModifierEntry.fromJson(json);
        return new EntryMatch(entry);
    }

    public static ModifierMatch read(class_2540 buffer) {
        int size = buffer.method_10816();
        if (size == 1) {
            ModifierEntry entry = ModifierEntry.read(buffer);
            return new EntryMatch(entry);
        }
        int required = buffer.method_10816();
        if (required == 0) {
            return ALWAYS;
        }
        if (size == 0) {
            class_6862<Modifier> tag = ModifierManager.getTag(buffer.method_10810());
            int level = buffer.method_10816();
            return new TagMatch(tag, level, required);
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < size; ++i) {
            builder.add((Object)ModifierMatch.read(buffer));
        }
        return new ListMatch((List<ModifierMatch>)builder.build(), required);
    }

    public abstract void apply(ModifierNBT.Builder var1);

    public abstract int getMinLevel(ModifierId var1);

    public abstract JsonObject serialize();

    public abstract void write(class_2540 var1);

    protected static class EntryMatch
    extends ModifierMatch {
        protected final ModifierEntry entry;

        @Override
        public boolean test(List<ModifierEntry> modifiers) {
            for (ModifierEntry entry : modifiers) {
                if (!entry.matches(this.entry.getId())) continue;
                return entry.getLevel() >= this.entry.getLevel();
            }
            return false;
        }

        @Override
        public int getMinLevel(ModifierId modifier) {
            if (this.entry.matches(modifier)) {
                return this.entry.getLevel();
            }
            return 0;
        }

        @Override
        public void apply(ModifierNBT.Builder builder) {
            builder.add(this.entry);
        }

        @Override
        public JsonObject serialize() {
            return this.entry.toJson();
        }

        @Override
        public void write(class_2540 buffer) {
            buffer.method_10804(1);
            this.entry.write(buffer);
        }

        public EntryMatch(ModifierEntry entry) {
            this.entry = entry;
        }
    }

    protected static class TagMatch
    extends ModifierMatch {
        private final class_6862<Modifier> tag;
        private final int level;
        protected final int required;

        @Override
        public boolean test(List<ModifierEntry> entries) {
            int matches = 0;
            for (ModifierEntry entry : entries) {
                if (!ModifierManager.isInTag(entry.getId(), this.tag) || entry.getLevel() < this.level) continue;
                ++matches;
            }
            return matches >= this.required;
        }

        @Override
        public int getMinLevel(ModifierId modifier) {
            return ModifierManager.isInTag(modifier, this.tag) ? this.level : 0;
        }

        @Override
        public void apply(ModifierNBT.Builder builder) {
            List<Modifier> modifiers = ModifierManager.getTagValues(this.tag);
            int max = Math.min(this.required, modifiers.size());
            for (int i = 0; i < max; ++i) {
                builder.add(modifiers.get(i), this.level);
            }
        }

        @Override
        public JsonObject serialize() {
            if (this.required == 0) {
                return ALWAYS.serialize();
            }
            JsonObject json = new JsonObject();
            json.addProperty("tag", this.tag.comp_327().toString());
            json.addProperty("level", (Number)this.level);
            if (this.required > 1) {
                json.addProperty("required", (Number)this.required);
            }
            return json;
        }

        @Override
        public void write(class_2540 buffer) {
            buffer.method_10804(0);
            buffer.method_10804(this.required);
            if (this.required > 0) {
                buffer.method_10812(this.tag.comp_327());
                buffer.method_10804(this.level);
            }
        }

        public TagMatch(class_6862<Modifier> tag, int level, int required) {
            this.tag = tag;
            this.level = level;
            this.required = required;
        }
    }

    protected static class ListMatch
    extends ModifierMatch {
        protected final List<ModifierMatch> options;
        protected final int required;

        @Override
        public boolean test(List<ModifierEntry> modifiers) {
            int matches = 0;
            for (ModifierMatch match : this.options) {
                if (!match.test(modifiers)) continue;
                ++matches;
            }
            return matches >= this.required;
        }

        @Override
        public int getMinLevel(ModifierId modifier) {
            if (this.required == 0 || this.required >= this.options.size()) {
                return 0;
            }
            return this.options.stream().mapToInt(entry -> entry.getMinLevel(modifier)).sorted().skip(this.required - 1).findFirst().orElse(0);
        }

        @Override
        public void apply(ModifierNBT.Builder builder) {
            int max = Math.min(this.required, this.options.size());
            for (int i = 0; i < max; ++i) {
                this.options.get(i).apply(builder);
            }
        }

        @Override
        public JsonObject serialize() {
            if (this.options.size() == 1) {
                return this.options.get(0).serialize();
            }
            JsonObject json = new JsonObject();
            if (this.required == 0) {
                json.addProperty("matches_needed", (Number)0);
                return json;
            }
            JsonArray array = new JsonArray();
            for (ModifierMatch match : this.options) {
                array.add((JsonElement)match.serialize());
            }
            json.add("options", (JsonElement)array);
            json.addProperty("matches_needed", (Number)this.required);
            return json;
        }

        @Override
        public void write(class_2540 buffer) {
            if (this.options.size() == 1) {
                this.options.get(0).write(buffer);
            } else {
                buffer.method_10804(this.options.size());
                buffer.method_10804(this.required);
                for (ModifierMatch match : this.options) {
                    match.write(buffer);
                }
            }
        }

        public ListMatch(List<ModifierMatch> options, int required) {
            this.options = options;
            this.required = required;
        }
    }
}

