/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.modules;

import com.google.gson.JsonObject;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHook;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.DisplayNameModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.build.ModifierRemovalHook;
import slimeknights.tconstruct.library.modifiers.hook.build.VolatileDataModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.modifiers.util.ModuleWithKey;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.context.ToolRebuildContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;

public record SwappableSlotModule(@Nullable class_2960 key, int slotCount) implements VolatileDataModifierHook,
DisplayNameModifierHook,
ModifierRemovalHook,
ModifierModule,
ModuleWithKey
{
    private static final List<ModifierHook<?>> DEFAULT_HOOKS = List.of(TinkerHooks.VOLATILE_DATA, TinkerHooks.DISPLAY_NAME, TinkerHooks.REMOVE);
    private static final String FORMAT = TConstruct.makeTranslationKey("modifier", "extra_modifier.type_format");
    public static final GenericLoaderRegistry.IGenericLoader<SwappableSlotModule> LOADER = new GenericLoaderRegistry.IGenericLoader<SwappableSlotModule>(){

        public SwappableSlotModule deserialize(JsonObject json) {
            class_2960 key = ModuleWithKey.parseKey(json);
            int slotCount = class_3518.method_15260((JsonObject)json, (String)"slots");
            return new SwappableSlotModule(key, slotCount);
        }

        public void serialize(SwappableSlotModule object, JsonObject json) {
            if (object.key != null) {
                json.addProperty("key", object.key.toString());
            }
            json.addProperty("slots", (Number)object.slotCount);
        }

        public SwappableSlotModule fromNetwork(class_2540 buffer) {
            class_2960 key = ModuleWithKey.fromNetwork(buffer);
            int slotCount = buffer.readInt();
            return new SwappableSlotModule(key, slotCount);
        }

        public void toNetwork(SwappableSlotModule object, class_2540 buffer) {
            ModuleWithKey.toNetwork(object.key, buffer);
            buffer.writeInt(object.slotCount);
        }
    };

    public SwappableSlotModule(int slotCount) {
        this(null, slotCount);
    }

    @Override
    public class_2561 getDisplayName(IToolStackView tool, Modifier modifier, int level, class_2561 name) {
        SlotType type;
        String slotName = tool.getPersistentData().getString(this.getKey(modifier));
        if (!slotName.isEmpty() && (type = SlotType.getIfPresent(slotName)) != null) {
            return class_2561.method_43469((String)FORMAT, (Object[])new Object[]{name.method_27662(), type.getDisplayName()}).method_27694(style -> style.method_27703(type.getColor()));
        }
        return name;
    }

    @Override
    public Integer getPriority() {
        return 50;
    }

    @Override
    public void addVolatileData(ToolRebuildContext context, ModifierEntry modifier, ModDataNBT volatileData) {
        SlotType type;
        String slotName = context.getPersistentData().getString(this.getKey(modifier.getModifier()));
        if (!slotName.isEmpty() && (type = SlotType.getIfPresent(slotName)) != null) {
            volatileData.addSlots(type, this.slotCount);
        }
    }

    @Override
    @Nullable
    public class_2561 onRemoved(IToolStackView tool, Modifier modifier) {
        tool.getPersistentData().remove(modifier.getId());
        return null;
    }

    @Override
    public List<ModifierHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    public GenericLoaderRegistry.IGenericLoader<? extends ModifierModule> getLoader() {
        return LOADER;
    }

    public record BonusSlot(@Nullable class_2960 key, SlotType match, SlotType bonus, int slotCount) implements VolatileDataModifierHook,
    ModifierModule,
    ModuleWithKey
    {
        private static final List<ModifierHook<?>> DEFAULT_HOOKS = List.of(TinkerHooks.VOLATILE_DATA);
        public static final GenericLoaderRegistry.IGenericLoader<BonusSlot> LOADER = new GenericLoaderRegistry.IGenericLoader<BonusSlot>(){

            public BonusSlot deserialize(JsonObject json) {
                class_2960 key = ModuleWithKey.parseKey(json);
                SlotType match = SlotType.getOrCreate(class_3518.method_15265((JsonObject)json, (String)"match"));
                SlotType bonus = SlotType.getOrCreate(class_3518.method_15265((JsonObject)json, (String)"bonus"));
                int slotCount = class_3518.method_15260((JsonObject)json, (String)"slots");
                return new BonusSlot(key, match, bonus, slotCount);
            }

            public void serialize(BonusSlot object, JsonObject json) {
                if (object.key != null) {
                    json.addProperty("key", object.key.toString());
                }
                json.addProperty("match", object.match.getName());
                json.addProperty("bonus", object.bonus.getName());
                json.addProperty("slots", (Number)object.slotCount);
            }

            public BonusSlot fromNetwork(class_2540 buffer) {
                class_2960 key = ModuleWithKey.fromNetwork(buffer);
                SlotType match = SlotType.read(buffer);
                SlotType bonus = SlotType.read(buffer);
                int slots = buffer.readInt();
                return new BonusSlot(key, match, bonus, slots);
            }

            public void toNetwork(BonusSlot object, class_2540 buffer) {
                ModuleWithKey.toNetwork(object.key, buffer);
                object.match.write(buffer);
                object.bonus.write(buffer);
                buffer.writeInt(object.slotCount);
            }
        };

        public BonusSlot(SlotType match, SlotType penalty, int slotCount) {
            this(null, match, penalty, slotCount);
        }

        @Override
        public void addVolatileData(ToolRebuildContext context, ModifierEntry modifier, ModDataNBT volatileData) {
            String slotName = context.getPersistentData().getString(this.getKey(modifier.getModifier()));
            if (!slotName.isEmpty() && this.match.getName().equals(slotName)) {
                volatileData.addSlots(this.bonus, this.slotCount);
            }
        }

        @Override
        public List<ModifierHook<?>> getDefaultHooks() {
            return DEFAULT_HOOKS;
        }

        public GenericLoaderRegistry.IGenericLoader<? extends ModifierModule> getLoader() {
            return LOADER;
        }
    }
}

