/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.materials.definition;

import com.google.common.annotations.VisibleForTesting;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.conditions.v1.ResourceConditions;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3503;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.client.book.data.JsonCondition;
import slimeknights.mantle.client.book.data.deserializer.ConditionDeserializer;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.exception.TinkerJSONException;
import slimeknights.tconstruct.library.json.JsonRedirect;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.Material;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.definition.UpdateMaterialsPacket;
import slimeknights.tconstruct.library.materials.json.MaterialJson;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.utils.GenericTagUtil;
import slimeknights.tconstruct.library.utils.Util;

public class MaterialManager
extends class_4309
implements IdentifiableResourceReloadListener {
    private static final Logger log = LogManager.getLogger(MaterialManager.class);
    public static final String FOLDER = "tinkering/materials/definition";
    public static final String TAG_FOLDER = "tinkering/tags/materials";
    private static final class_5321<? extends class_2378<IMaterial>> REGISTRY_KEY = class_5321.method_29180((class_2960)TConstruct.getResource("materials"));
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(class_2960.class, (Object)new class_2960.class_2961()).registerTypeAdapter(JsonCondition.class, (Object)ConditionDeserializer.DESERIALIZER).registerTypeAdapter(JsonCondition.class, (Object)ConditionDeserializer.SERIALIZER).setPrettyPrinting().disableHtmlEscaping().create();
    private final Runnable onLoaded;
    private Map<MaterialId, IMaterial> materials = Collections.emptyMap();
    private Map<MaterialId, MaterialId> redirects = Collections.emptyMap();
    private List<IMaterial> sortedMaterials = Collections.emptyList();
    private Map<class_2960, Collection<IMaterial>> tags = Collections.emptyMap();
    private Map<MaterialId, Set<class_6862<IMaterial>>> reverseTags = Collections.emptyMap();

    public MaterialManager(Runnable onLoaded) {
        super(GSON, FOLDER);
        this.onLoaded = onLoaded;
    }

    @VisibleForTesting
    MaterialManager() {
        this(() -> {});
    }

    public Collection<IMaterial> getVisibleMaterials() {
        return this.sortedMaterials;
    }

    public Collection<IMaterial> getAllMaterials() {
        return this.materials.values();
    }

    public Optional<IMaterial> getMaterial(MaterialId materialId) {
        return Optional.ofNullable(this.materials.get(materialId));
    }

    public MaterialId resolveRedirect(MaterialId materialId) {
        return this.redirects.getOrDefault(materialId, materialId);
    }

    public static class_6862<IMaterial> getTag(class_2960 id) {
        return class_6862.method_40092(REGISTRY_KEY, (class_2960)id);
    }

    public boolean isIn(MaterialId id, class_6862<IMaterial> tag) {
        return this.reverseTags.getOrDefault(id, Collections.emptySet()).contains(tag);
    }

    public Collection<IMaterial> getValues(class_6862<Modifier> tag) {
        return this.tags.getOrDefault(tag.comp_327(), Collections.emptySet());
    }

    private void onMaterialUpdate() {
        this.sortedMaterials = this.materials.values().stream().filter(mat -> !mat.isHidden()).sorted().collect(Collectors.toList());
        this.onLoaded.run();
    }

    public void updateMaterialsFromServer(Map<MaterialId, IMaterial> materials, Map<MaterialId, MaterialId> redirects, Map<class_2960, Collection<IMaterial>> tags) {
        this.materials = materials;
        this.redirects = redirects;
        this.tags = tags;
        this.reverseTags = GenericTagUtil.reverseTags(REGISTRY_KEY, IMaterial::getIdentifier, tags);
        this.onMaterialUpdate();
    }

    protected void apply(Map<class_2960, JsonElement> splashList, class_3300 resourceManagerIn, class_3695 profilerIn) {
        long time = System.nanoTime();
        HashMap<MaterialId, MaterialId> redirects = new HashMap<MaterialId, MaterialId>();
        this.materials = splashList.entrySet().stream().filter(entry -> ((JsonElement)entry.getValue()).isJsonObject()).map(entry -> this.loadMaterial((class_2960)entry.getKey(), ((JsonElement)entry.getValue()).getAsJsonObject(), redirects)).filter(Objects::nonNull).collect(Collectors.toMap(IMaterial::getIdentifier, material -> material));
        Iterator redirectIterator = redirects.entrySet().iterator();
        while (redirectIterator.hasNext()) {
            Map.Entry entry2 = redirectIterator.next();
            if (this.materials.containsKey(entry2.getValue())) continue;
            log.error("Invalid material redirect {} as material {} does not exist", entry2.getKey(), entry2.getValue());
            redirectIterator.remove();
        }
        this.redirects = redirects;
        this.onMaterialUpdate();
        log.debug("Loaded materials: {}", (Object)Util.toIndentedStringList(this.materials.keySet()));
        log.debug("Loaded redirects: {}", (Object)Util.toIndentedStringList(redirects.keySet()));
        long timeStep = System.nanoTime();
        log.info("Loaded {} materials in {} ms", (Object)this.materials.size(), (Object)Float.valueOf((float)(timeStep - time) / 1000000.0f));
        class_3503 tagLoader = new class_3503(id -> this.getMaterial(new MaterialId((class_2960)id)), TAG_FOLDER);
        this.tags = tagLoader.method_33176(resourceManagerIn);
        this.reverseTags = GenericTagUtil.reverseTags(REGISTRY_KEY, IMaterial::getIdentifier, this.tags);
        log.info("Loaded {} material tags for {} materials in {} ms", (Object)this.tags.size(), (Object)this.reverseTags.size(), (Object)Float.valueOf((float)(System.nanoTime() - timeStep) / 1000000.0f));
    }

    public UpdateMaterialsPacket getUpdatePacket() {
        return new UpdateMaterialsPacket(this.materials, this.redirects, this.tags);
    }

    @Nullable
    private IMaterial loadMaterial(class_2960 materialId, JsonObject jsonObject, Map<MaterialId, MaterialId> redirects) {
        try {
            JsonCondition condition;
            MaterialJson materialJson = (MaterialJson)GSON.fromJson((JsonElement)jsonObject, MaterialJson.class);
            JsonRedirect[] redirectsJson = materialJson.getRedirect();
            if (redirectsJson != null) {
                for (JsonRedirect redirect : redirectsJson) {
                    Predicate<JsonObject> redirectCondition = redirect.getConditionPredicate();
                    if (redirectCondition != null && !redirectCondition.test(jsonObject)) continue;
                    MaterialId redirectTarget = new MaterialId(redirect.getId());
                    log.debug("Redirecting material {} to {}", (Object)materialId, (Object)redirectTarget);
                    redirects.put(new MaterialId(materialId), redirectTarget);
                    return null;
                }
            }
            if ((condition = materialJson.getCondition()) != null && condition.getConditionId() != null && !ResourceConditions.get((class_2960)condition.getConditionId()).test(jsonObject.getAsJsonObject("condition").getAsJsonArray("fabric:load_conditions").get(0).getAsJsonObject())) {
                log.debug("Skipped loading material {} as it did not match the condition", (Object)materialId);
                return null;
            }
            if (materialJson.getCraftable() == null) {
                throw TinkerJSONException.materialJsonWithoutCraftingInformation(materialId);
            }
            boolean isCraftable = Boolean.TRUE.equals(materialJson.getCraftable());
            boolean hidden = Boolean.TRUE.equals(materialJson.getHidden());
            return new Material(materialId, Objects.requireNonNullElse(materialJson.getTier(), 0), Objects.requireNonNullElse(materialJson.getSortOrder(), 100), isCraftable, hidden);
        }
        catch (Exception e) {
            log.error("Could not deserialize material {}. JSON: {}", (Object)materialId, (Object)jsonObject, (Object)e);
            return null;
        }
    }

    public class_2960 getFabricId() {
        return TConstruct.getResource("material_manager");
    }
}

